/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.term;

import com.fuzzylite.Op;
import com.fuzzylite.term.Term;
import java.util.Iterator;
import java.util.List;

public class ZShape
extends Term {
    private double start;
    private double end;

    public ZShape() {
        this("");
    }

    public ZShape(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public ZShape(String name, double start, double end) {
        this(name, start, end, 1.0);
    }

    public ZShape(String name, double start, double end, double height) {
        super(name, height);
        this.start = start;
        this.end = end;
    }

    @Override
    public String parameters() {
        return Op.join(" ", this.start, this.end) + (!Op.isEq(this.height, 1.0) ? " " + Op.str(this.height) : "");
    }

    @Override
    public void configure(String parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        List<String> values = Op.split(parameters, " ");
        int required = 2;
        if (values.size() < required) {
            throw new RuntimeException(String.format("[configuration error] term <%s> requires <%d> parameters", this.getClass().getSimpleName(), required));
        }
        Iterator<String> it = values.iterator();
        this.setStart(Op.toDouble(it.next()));
        this.setEnd(Op.toDouble(it.next()));
        if (values.size() > required) {
            this.setHeight(Op.toDouble(it.next()));
        }
    }

    @Override
    public double membership(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Op.isLE(x, this.start)) {
            return this.height * 1.0;
        }
        if (Op.isLE(x, 0.5 * (this.start + this.end))) {
            return this.height * (1.0 - 2.0 * Math.pow((x - this.start) / (this.end - this.start), 2.0));
        }
        if (Op.isLt(x, this.end)) {
            return this.height * (2.0 * Math.pow((x - this.end) / (this.end - this.start), 2.0));
        }
        return this.height * 0.0;
    }

    @Override
    public double tsukamoto(double activationDegree, double minimum, double maximum) {
        double w = activationDegree;
        double difference = this.end - this.start;
        double a = this.start + Math.sqrt(-0.5 * (w - 1.0) * difference * difference);
        double b = this.end + Math.sqrt(0.5 * w * difference * difference);
        double z = Math.abs(w - this.membership(a)) < Math.abs(w - this.membership(b)) ? a : b;
        return z;
    }

    @Override
    public boolean isMonotonic() {
        return true;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getEnd() {
        return this.end;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    @Override
    public ZShape clone() throws CloneNotSupportedException {
        return (ZShape)super.clone();
    }
}

