/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.variable;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.norm.SNorm;
import com.fuzzylite.term.Aggregated;
import com.fuzzylite.term.Term;
import com.fuzzylite.variable.Variable;
import java.util.Iterator;

public class OutputVariable
extends Variable {
    private Aggregated fuzzyOutput;
    private Defuzzifier defuzzifier;
    private double previousValue;
    private double defaultValue;
    private boolean lockPreviousValue;

    public OutputVariable() {
        this("");
    }

    public OutputVariable(String name) {
        this(name, Double.NaN, Double.NaN);
    }

    public OutputVariable(String name, double minimum, double maximum) {
        super(name, minimum, maximum);
        this.fuzzyOutput = new Aggregated("fuzzyOutput", minimum, maximum);
        this.defuzzifier = null;
        this.previousValue = Double.NaN;
        this.defaultValue = Double.NaN;
        this.lockPreviousValue = false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.fuzzyOutput.setName(name);
    }

    public Aggregated fuzzyOutput() {
        return this.fuzzyOutput;
    }

    @Override
    public void setMinimum(double minimum) {
        super.setMinimum(minimum);
        this.fuzzyOutput().setMinimum(minimum);
    }

    @Override
    public void setMaximum(double maximum) {
        super.setMaximum(maximum);
        this.fuzzyOutput().setMaximum(maximum);
    }

    public Defuzzifier getDefuzzifier() {
        return this.defuzzifier;
    }

    public void setDefuzzifier(Defuzzifier defuzzifier) {
        this.defuzzifier = defuzzifier;
    }

    public SNorm getAggregation() {
        return this.fuzzyOutput.getAggregation();
    }

    public void setAggregation(SNorm aggregation) {
        this.fuzzyOutput.setAggregation(aggregation);
    }

    public double getPreviousValue() {
        return this.previousValue;
    }

    public void setPreviousValue(double previousValue) {
        this.previousValue = previousValue;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isLockPreviousValue() {
        return this.lockPreviousValue;
    }

    public void setLockPreviousValue(boolean lockPreviousValue) {
        this.lockPreviousValue = lockPreviousValue;
    }

    public void defuzzify() {
        boolean isValid;
        if (!this.isEnabled()) {
            return;
        }
        if (Op.isFinite(this.getValue())) {
            this.setPreviousValue(this.getValue());
        }
        String exception = null;
        double result = Double.NaN;
        boolean bl = isValid = !this.fuzzyOutput().getTerms().isEmpty();
        if (isValid) {
            isValid = false;
            if (this.getDefuzzifier() != null) {
                try {
                    result = this.getDefuzzifier().defuzzify(this.fuzzyOutput(), this.getMinimum(), this.getMaximum());
                    isValid = true;
                }
                catch (Exception ex) {
                    exception = ex.toString();
                }
            } else {
                exception = String.format("[defuzzifier error] defuzzifier needed to defuzzify output variable <%s>", this.getName());
            }
        }
        if (!isValid) {
            result = this.isLockPreviousValue() && !Double.isNaN(this.getPreviousValue()) ? this.getPreviousValue() : this.getDefaultValue();
        }
        this.setValue(result);
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    public String fuzzyOutputValue() {
        StringBuilder sb = new StringBuilder();
        Iterator<Term> it = this.getTerms().iterator();
        if (it.hasNext()) {
            Term term = it.next();
            double degree = this.fuzzyOutput.activationDegree(term);
            sb.append(Op.str(degree)).append("/").append(term.getName());
            while (it.hasNext()) {
                term = it.next();
                degree = this.fuzzyOutput.activationDegree(term);
                if (Double.isNaN(degree) || Op.isGE(degree, 0.0)) {
                    sb.append(" + ").append(Op.str(degree));
                } else {
                    sb.append(" - ").append(Op.str(Math.abs(degree)));
                }
                sb.append("/").append(term.getName());
            }
        }
        return sb.toString();
    }

    public void clear() {
        this.fuzzyOutput().clear();
        this.setValue(Double.NaN);
        this.setPreviousValue(Double.NaN);
    }

    @Override
    public Variable.Type type() {
        return Variable.Type.Output;
    }

    @Override
    public String toString() {
        return new FllExporter().toString(this);
    }

    @Override
    public OutputVariable clone() throws CloneNotSupportedException {
        OutputVariable result = (OutputVariable)super.clone();
        result.fuzzyOutput = this.fuzzyOutput.clone();
        if (this.defuzzifier != null) {
            result.defuzzifier = this.defuzzifier.clone();
        }
        return result;
    }
}

