/*
 * Decompiled with CFR 0.152.
 */
package com.fuzzylite.variable;

import com.fuzzylite.Op;
import com.fuzzylite.defuzzifier.Centroid;
import com.fuzzylite.defuzzifier.Defuzzifier;
import com.fuzzylite.imex.FllExporter;
import com.fuzzylite.term.Constant;
import com.fuzzylite.term.Linear;
import com.fuzzylite.term.Term;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class Variable
implements Op.Cloneable {
    private String name;
    private String description;
    private List<Term> terms;
    private double value;
    private double minimum;
    private double maximum;
    private boolean enabled;
    private boolean lockValueInRange;

    public Variable(String name) {
        this(name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public Variable(String name, double minimum, double maximum) {
        this.name = name;
        this.description = "";
        this.terms = new ArrayList<Term>();
        this.value = Double.NaN;
        this.minimum = minimum;
        this.maximum = maximum;
        this.enabled = true;
        this.lockValueInRange = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = this.lockValueInRange ? Op.bound(value, this.minimum, this.maximum) : value;
    }

    public void setRange(double minimum, double maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public double range() {
        return this.maximum - this.minimum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLockValueInRange() {
        return this.lockValueInRange;
    }

    public void setLockValueInRange(boolean lockValueInRange) {
        this.lockValueInRange = lockValueInRange;
    }

    public Type type() {
        return Type.None;
    }

    public String toString() {
        return new FllExporter().toString(this);
    }

    public String fuzzify(double x) {
        StringBuilder sb = new StringBuilder();
        for (Term term : this.getTerms()) {
            double fx = term.membership(x);
            if (sb.length() == 0) {
                sb.append(Op.str(fx));
            } else if (Double.isNaN(fx) || Op.isGE(fx, 0.0)) {
                sb.append(" + ").append(Op.str(fx));
            } else {
                sb.append(" - ").append(Op.str(fx));
            }
            sb.append("/").append(term.getName());
        }
        return sb.toString();
    }

    public Op.Pair<Double, Term> highestMembership(double x) {
        Op.Pair<Double, Object> result = new Op.Pair<Double, Object>(0.0, null);
        for (Term term : this.terms) {
            double y = term.membership(x);
            if (!Op.isGt(y, result.getFirst())) continue;
            result.setFirst(y);
            result.setSecond(term);
        }
        return result;
    }

    public Double highestMembershipValue(double x) {
        return this.highestMembership(x).getFirst();
    }

    public Term highestMembershipTerm(double x) {
        return this.highestMembership(x).getSecond();
    }

    public void sort() {
        PriorityQueue<Op.Pair<Term, Double>> termCentroids = new PriorityQueue<Op.Pair<Term, Double>>(this.terms.size(), new Ascending());
        Centroid defuzzifier = new Centroid();
        for (Term term : this.terms) {
            double centroid;
            try {
                centroid = term instanceof Constant || term instanceof Linear ? term.membership(0.0) : ((Defuzzifier)defuzzifier).defuzzify(term, this.getMinimum(), this.getMaximum());
            }
            catch (Exception ex) {
                centroid = Double.POSITIVE_INFINITY;
            }
            termCentroids.offer(new Op.Pair<Term, Double>(term, centroid));
        }
        ArrayList<Term> sortedTerms = new ArrayList<Term>(this.terms.size());
        while (!termCentroids.isEmpty()) {
            sortedTerms.add(termCentroids.poll().getFirst());
        }
        this.setTerms(sortedTerms);
    }

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    public void insert(Term term, int index) {
        this.terms.add(index, term);
    }

    public Term getTerm(int index) {
        return this.terms.get(index);
    }

    public Term getTerm(String name) {
        for (Term term : this.terms) {
            if (!name.equals(term.getName())) continue;
            return term;
        }
        return null;
    }

    public boolean hasTerm(String name) {
        return this.getTerm(name) != null;
    }

    public boolean removeTerm(Term term) {
        return this.terms.remove(term);
    }

    public Term removeTerm(String name) {
        Iterator<Term> it = this.terms.iterator();
        while (it.hasNext()) {
            Term term = it.next();
            if (!term.getName().equals(name)) continue;
            it.remove();
            return term;
        }
        return null;
    }

    public int numberOfTerms() {
        return this.terms.size();
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    @Override
    public Variable clone() throws CloneNotSupportedException {
        Variable result = (Variable)super.clone();
        result.terms = new ArrayList<Term>(this.terms.size());
        for (Term term : this.terms) {
            result.terms.add(term.clone());
        }
        return result;
    }

    public static class Ascending
    implements Comparator<Op.Pair<Term, Double>> {
        @Override
        public int compare(Op.Pair<Term, Double> a, Op.Pair<Term, Double> b) {
            double result = Math.signum(a.getSecond() - b.getSecond());
            return Double.isNaN(result) ? -1 : (int)result;
        }
    }

    public static enum Type {
        None,
        Input,
        Output;

    }
}

