/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.plugin.adtransparency;

import com.fyber.fairbid.plugin.MediationNetwork;
import com.fyber.fairbid.plugin.TpnMappings;
import com.fyber.fairbid.plugin.adtransparency.AdTransparencyPlugin;
import com.fyber.fairbid.plugin.adtransparency.ApplyNewTransformKt;
import com.fyber.fairbid.plugin.adtransparency.CompatOldAgpKt;
import com.fyber.fairbid.plugin.adtransparency.VersionNumber;
import com.fyber.fairbid.plugin.adtransparency.utils.CompatExtensionsKt;
import com.fyber.fairbid.plugin.adtransparency.utils.TpnInfoCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/fyber/fairbid/plugin/adtransparency/AdTransparencyPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "getAndroidGradlePluginVersion", "Lcom/fyber/fairbid/plugin/adtransparency/VersionNumber;", "getClasspathVersion", "identifier", "", "Companion", "fairbid-sdk-plugin"})
@SourceDebugExtension(value={"SMAP\nAdTransparencyPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdTransparencyPlugin.kt\ncom/fyber/fairbid/plugin/adtransparency/AdTransparencyPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n661#3,11:110\n661#3,11:121\n*E\n*S KotlinDebug\n*F\n+ 1 AdTransparencyPlugin.kt\ncom/fyber/fairbid/plugin/adtransparency/AdTransparencyPlugin\n*L\n96#1,11:110\n101#1,11:121\n*E\n"})
public final class AdTransparencyPlugin
implements Plugin<Project> {
    @NotNull
    public static final String currentFairBidSdkVersion = "3.58.2";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getLogger().info("FairBidSdkPlugin - Applying plugin to " + project.getName());
        Object object = project.findProperty("failIfInjectionProblemWithNetwork");
        if (object != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            project.delete(new Object[]{project.getBuildDir() + "/intermediates/transforms"});
        }
        project.getPlugins().withId("com.android.application", new Action(this, project){
            final /* synthetic */ AdTransparencyPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(@NotNull Plugin<Object> $this$withId) {
                Intrinsics.checkNotNullParameter($this$withId, (String)"$receiver");
                this.$project.getLogger().info("FairBidSdkPlugin - Detected Android application plugin");
                Object object = this.$project.getConfigurations().create("fairbidMediation", (Action)apply.mediationConfig.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations.c\u2026med = false\n            }");
                Configuration mediationConfig2 = (Configuration)object;
                TpnInfoCollector tpnInfoCollector = new TpnInfoCollector();
                this.$project.getConfigurations().configureEach(new Action(this, mediationConfig2, tpnInfoCollector){
                    final /* synthetic */ apply.2 this$0;
                    final /* synthetic */ Configuration $mediationConfig;
                    final /* synthetic */ TpnInfoCollector $tpnInfoCollector;

                    public final void execute(@NotNull Configuration $this$configureEach) {
                        Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$receiver");
                        Configuration config = $this$configureEach;
                        config.resolutionStrategy(new Action(this){
                            final /* synthetic */ apply.1 this$0;

                            public final void execute(@NotNull ResolutionStrategy $this$resolutionStrategy) {
                                Intrinsics.checkNotNullParameter((Object)$this$resolutionStrategy, (String)"$receiver");
                                $this$resolutionStrategy.getDependencySubstitution().all(new Action(this){
                                    final /* synthetic */ apply.1 this$0;

                                    public final void execute(@NotNull DependencySubstitution $this$all) {
                                        ComponentSelector componentSelector;
                                        Intrinsics.checkNotNullParameter((Object)$this$all, (String)"$receiver");
                                        ComponentSelector it = componentSelector = $this$all.getRequested();
                                        boolean bl = false;
                                        if (it instanceof ModuleComponentSelector && Intrinsics.areEqual((Object)((ModuleComponentSelector)it).getGroup(), (Object)"com.fyber") && Intrinsics.areEqual((Object)((ModuleComponentSelector)it).getModule(), (Object)"fairbid-sdk")) {
                                            this.this$0.this$0.this$0.$project.getLogger().info("FairBidSdkPlugin - Setting FairBid SDK target to resolve version 3.58.2");
                                            $this$all.useTarget((Object)"com.fyber:fairbid-sdk:3.58.2", "Version compatible with this plugin");
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                                $this$resolutionStrategy.eachDependency(new Action(this, $this$resolutionStrategy){
                                    final /* synthetic */ apply.1 this$0;
                                    final /* synthetic */ ResolutionStrategy $this_resolutionStrategy;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void execute(@NotNull DependencyResolveDetails $this$eachDependency) {
                                        Intrinsics.checkNotNullParameter((Object)$this$eachDependency, (String)"$receiver");
                                        this.$this_resolutionStrategy.preferProjectModules();
                                        ModuleVersionSelector moduleVersionSelector = $this$eachDependency.getRequested();
                                        Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector, (String)"requested");
                                        if (Intrinsics.areEqual((Object)moduleVersionSelector.getGroup(), (Object)"com.fyber")) {
                                            ModuleVersionSelector moduleVersionSelector2 = $this$eachDependency.getRequested();
                                            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector2, (String)"requested");
                                            if (Intrinsics.areEqual((Object)moduleVersionSelector2.getName(), (Object)"fairbid-sdk")) {
                                                this.this$0.this$0.this$0.$project.getLogger().info("FairBidSdkPlugin - Substituting " + $this$eachDependency.getRequested() + " with " + $this$eachDependency.getTarget());
                                            }
                                        }
                                        if (CompatExtensionsKt.isFairBidMediation($this$eachDependency)) {
                                            void $this$mapTo$iv$iv;
                                            Pair it;
                                            Iterable $this$filterTo$iv$iv;
                                            Iterable $this$filter$iv = TpnMappings.INSTANCE.getPackageToTpn();
                                            boolean $i$f$filter = false;
                                            Iterable iterable = $this$filter$iv;
                                            Collection destination$iv$iv = new ArrayList<E>();
                                            boolean $i$f$filterTo = false;
                                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                it = (Pair)element$iv$iv;
                                                boolean bl = false;
                                                String string = (String)it.getFirst();
                                                StringBuilder stringBuilder = new StringBuilder();
                                                ModuleVersionSelector moduleVersionSelector3 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector3, (String)"requested");
                                                StringBuilder stringBuilder2 = stringBuilder.append(moduleVersionSelector3.getGroup()).append(':');
                                                ModuleVersionSelector moduleVersionSelector4 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector4, (String)"requested");
                                                if (!Intrinsics.areEqual((Object)string, (Object)stringBuilder2.append(moduleVersionSelector4.getName()).toString())) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            Iterable $this$map$iv = (List)destination$iv$iv;
                                            boolean $i$f$map = false;
                                            $this$filterTo$iv$iv = $this$map$iv;
                                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                            boolean $i$f$mapTo = false;
                                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                it = (Pair)item$iv$iv;
                                                Collection collection = destination$iv$iv;
                                                boolean bl = false;
                                                MediationNetwork mediationNetwork = (MediationNetwork)((Object)it.getSecond());
                                                collection.add(mediationNetwork);
                                            }
                                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                                            boolean $i$f$forEach = false;
                                            for (E element$iv : $this$forEach$iv) {
                                                MediationNetwork mediationNetwork = (MediationNetwork)((Object)element$iv);
                                                boolean bl = false;
                                                Logger logger2 = this.this$0.this$0.this$0.$project.getLogger();
                                                StringBuilder stringBuilder = new StringBuilder().append("FairBidSdkPlugin - Detected mediation network - ").append(mediationNetwork.getTpnName()).append(" with version ");
                                                ModuleVersionSelector moduleVersionSelector5 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector5, (String)"requested");
                                                logger2.info(stringBuilder.append(moduleVersionSelector5.getVersion()).toString());
                                                DependencySet dependencySet = this.this$0.this$0.$mediationConfig.getDependencies();
                                                ModuleVersionSelector moduleVersionSelector6 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector6, (String)"requested");
                                                String string = moduleVersionSelector6.getGroup();
                                                ModuleVersionSelector moduleVersionSelector7 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector7, (String)"requested");
                                                String string2 = moduleVersionSelector7.getName();
                                                ModuleVersionSelector moduleVersionSelector8 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector8, (String)"requested");
                                                dependencySet.add((Object)new DefaultExternalModuleDependency(string, string2, String.valueOf(moduleVersionSelector8.getVersion())));
                                                TpnInfoCollector tpnInfoCollector = this.this$0.this$0.$tpnInfoCollector;
                                                ModuleVersionSelector moduleVersionSelector9 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector9, (String)"requested");
                                                String string3 = moduleVersionSelector9.getGroup();
                                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requested.group");
                                                ModuleVersionSelector moduleVersionSelector10 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector10, (String)"requested");
                                                String string4 = moduleVersionSelector10.getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"requested.name");
                                                ModuleVersionSelector moduleVersionSelector11 = $this$eachDependency.getRequested();
                                                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelector11, (String)"requested");
                                                tpnInfoCollector.addTpnInfo(mediationNetwork, new TpnInfoCollector.TpnInfo(string3, string4, String.valueOf(moduleVersionSelector11.getVersion())));
                                            }
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$this_resolutionStrategy = resolutionStrategy;
                                    }
                                });
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$mediationConfig = configuration;
                        this.$tpnInfoCollector = tpnInfoCollector;
                    }
                });
                Configuration configuration = this.$project.getConfigurations().getByName("implementation");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.getByName(\"implementation\")");
                Configuration implementationConfig = configuration;
                tpnInfoCollector.addTpnInfo(MediationNetwork.FAIRBID, new TpnInfoCollector.TpnInfo("com.fyber", "fairbid-sdk", "3.58.2"));
                DefaultExternalModuleDependency fairBidSdkDep = new DefaultExternalModuleDependency("com.fyber", "fairbid-sdk", "3.58.2");
                this.$project.getLogger().info("FairBidSdkPlugin - Adding FairBid dependency to the project - " + fairBidSdkDep);
                implementationConfig.getDependencies().add((Object)fairBidSdkDep);
                VersionNumber agpVersion = AdTransparencyPlugin.access$getAndroidGradlePluginVersion(this.this$0, this.$project);
                if (agpVersion != null) {
                    this.$project.getLogger().info("FairBidSdkPlugin - Detected AGP version " + agpVersion);
                    if (agpVersion.compareTo(VersionNumber.Companion.parse("8.0.0")) < 0) {
                        CompatOldAgpKt.useOldTransformer(this.$project, tpnInfoCollector, "3.58.2", agpVersion.toString());
                    } else {
                        ApplyNewTransformKt.applyNewTransform(this.$project, tpnInfoCollector, "3.58.2", agpVersion.toString());
                    }
                } else {
                    this.$project.getLogger().warn("FairBidSdkPlugin - Impossible to apply plugin - Could not detect Android Gradle Plugin version");
                }
            }
            {
                this.this$0 = adTransparencyPlugin;
                this.$project = project;
            }
        });
    }

    private final VersionNumber getAndroidGradlePluginVersion(Project project) {
        return this.getClasspathVersion(project, "com.android.tools.build:gradle");
    }

    private final VersionNumber getClasspathVersion(Project project, String identifier) {
        Object v16;
        block7: {
            Object v6;
            block6: {
                ScriptHandler scriptHandler = project.getBuildscript();
                Intrinsics.checkNotNullExpressionValue((Object)scriptHandler, (String)"project.buildscript");
                Configuration configuration = scriptHandler.getConfigurations().getByName("classpath");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.buildscript.conf\u2026ns.getByName(\"classpath\")");
                ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"project.buildscript.conf\u2026h\").resolvedConfiguration");
                Set set = resolvedConfiguration.getResolvedArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.buildscript.conf\u2026uration.resolvedArtifacts");
                Iterable $this$singleOrNull$iv = set;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ResolvedArtifact it = (ResolvedArtifact)element$iv;
                    boolean bl = false;
                    ResolvedArtifact resolvedArtifact = it;
                    Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifact, (String)"it");
                    ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"it.moduleVersion");
                    if (!StringsKt.startsWith$default((String)resolvedModuleVersion.getId().toString(), (String)(identifier + ':'), (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v6 = null;
                        break block6;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v6 = !found$iv ? null : single$iv;
            }
            ResolvedArtifact artifact = v6;
            if (artifact != null) {
                ResolvedModuleVersion resolvedModuleVersion = artifact.getModuleVersion();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"artifact.moduleVersion");
                ModuleVersionIdentifier moduleVersionIdentifier = resolvedModuleVersion.getId();
                Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"artifact.moduleVersion.id");
                return VersionNumber.Companion.parse(moduleVersionIdentifier.getVersion());
            }
            Project project2 = project.getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
            ScriptHandler scriptHandler = project2.getBuildscript();
            Intrinsics.checkNotNullExpressionValue((Object)scriptHandler, (String)"project.rootProject.buildscript");
            Configuration configuration = scriptHandler.getConfigurations().getByName("classpath");
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.rootProject.buil\u2026ns.getByName(\"classpath\")");
            ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"project.rootProject.buil\u2026h\").resolvedConfiguration");
            Set set = resolvedConfiguration.getResolvedArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.rootProject.buil\u2026uration.resolvedArtifacts");
            Iterable $this$singleOrNull$iv = set;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ResolvedArtifact it = (ResolvedArtifact)element$iv;
                boolean bl = false;
                ResolvedArtifact resolvedArtifact = it;
                Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifact, (String)"it");
                ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"it.moduleVersion");
                if (!StringsKt.startsWith$default((String)resolvedModuleVersion.getId().toString(), (String)(identifier + ':'), (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    v16 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v16 = !found$iv ? null : single$iv;
        }
        ResolvedArtifact rootArtifact = v16;
        if (rootArtifact != null) {
            ResolvedModuleVersion resolvedModuleVersion = rootArtifact.getModuleVersion();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"rootArtifact.moduleVersion");
            ModuleVersionIdentifier moduleVersionIdentifier = resolvedModuleVersion.getId();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"rootArtifact.moduleVersion.id");
            return VersionNumber.Companion.parse(moduleVersionIdentifier.getVersion());
        }
        return null;
    }

    public static final /* synthetic */ VersionNumber access$getAndroidGradlePluginVersion(AdTransparencyPlugin $this, Project project) {
        return $this.getAndroidGradlePluginVersion(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/fyber/fairbid/plugin/adtransparency/AdTransparencyPlugin$Companion;", "", "()V", "currentFairBidSdkVersion", "", "fairbid-sdk-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

