/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.plugin.adtransparency;

import com.fyber.fairbid.plugin.adtransparency.utils.LogLevel;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/fyber/fairbid/plugin/adtransparency/AppLovinClassesIdentifier;", "", "()V", "identifyAdEventNotifierClassInJar", "", "pool", "Ljavassist/ClassPool;", "allClassesInJar", "", "logger", "Lkotlin/Function2;", "Lcom/fyber/fairbid/plugin/adtransparency/utils/LogLevel;", "", "patternMatchForAdEventNotifierClass", "", "clazz", "Ljavassist/CtClass;", "fairbid-sdk-plugin_common"})
public final class AppLovinClassesIdentifier {
    @NotNull
    public static final AppLovinClassesIdentifier INSTANCE;

    @NotNull
    public final String identifyAdEventNotifierClassInJar(@NotNull ClassPool pool, @NotNull List<String> allClassesInJar, @NotNull Function2<? super String, ? super LogLevel, Unit> logger2) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter(allClassesInJar, (String)"allClassesInJar");
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        for (String className : allClassesInJar) {
            try {
                CtClass expectedImpClass;
                if (!StringsKt.contains$default((CharSequence)className, (CharSequence)"com.applovin.impl", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)className, (CharSequence)"com.applovin.impl.sdk.utils", (boolean)false, (int)2, null)) continue;
                String classNameWithoutExtension = StringsKt.removeSuffix((String)className, (CharSequence)".class");
                CtClass ctClass = expectedImpClass = pool.get(classNameWithoutExtension);
                Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"expectedImpClass");
                if (!this.patternMatchForAdEventNotifierClass(ctClass, logger2)) continue;
                String string = expectedImpClass.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expectedImpClass.name");
                return string;
            }
            catch (NotFoundException e) {
                logger2.invoke((Object)("Class not found: " + className), (Object)LogLevel.WARN);
            }
            catch (Exception e) {
                logger2.invoke((Object)("Error processing class '" + className + "': " + e.getMessage()), (Object)LogLevel.ERROR);
            }
        }
        return "Not Found";
    }

    private final boolean patternMatchForAdEventNotifierClass(CtClass clazz, Function2<? super String, ? super LogLevel, Unit> logger2) {
        if (clazz.getDeclaredFields().length > 1) {
            CtField ctField = clazz.getDeclaredFields()[0];
            Intrinsics.checkNotNullExpressionValue((Object)ctField, (String)"clazz.declaredFields[0]");
            CtClass ctClass = ctField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"clazz.declaredFields[0].type");
            String string = ctClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.declaredFields[0].type.simpleName");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"boolean", (boolean)false, (int)2, null)) {
                CtField ctField2 = clazz.getDeclaredFields()[1];
                Intrinsics.checkNotNullExpressionValue((Object)ctField2, (String)"clazz.declaredFields[1]");
                CtClass ctClass2 = ctField2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)ctClass2, (String)"clazz.declaredFields[1].type");
                String string2 = ctClass2.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clazz.declaredFields[1].type.simpleName");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"boolean", (boolean)false, (int)2, null) && clazz.getDeclaredMethods().length > 49) {
                    logger2.invoke((Object)("Output for Class " + clazz.getName() + " matches"), (Object)LogLevel.WARN);
                    return true;
                }
            }
        }
        return false;
    }

    private AppLovinClassesIdentifier() {
    }

    static {
        AppLovinClassesIdentifier appLovinClassesIdentifier;
        INSTANCE = appLovinClassesIdentifier = new AppLovinClassesIdentifier();
    }
}

