/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.plugin.adtransparency;

import com.fyber.fairbid.plugin.MediationNetwork;
import com.fyber.fairbid.plugin.adtransparency.exceptions.InjectionException;
import com.fyber.fairbid.plugin.adtransparency.mediation.AppLovinInjector;
import com.fyber.fairbid.plugin.adtransparency.mediation.ChartboostInjector;
import com.fyber.fairbid.plugin.adtransparency.mediation.Injector;
import com.fyber.fairbid.plugin.adtransparency.mediation.IronSourceInjector;
import com.fyber.fairbid.plugin.adtransparency.mediation.MintegralInjector;
import com.fyber.fairbid.plugin.adtransparency.mediation.PangleInjector;
import com.fyber.fairbid.plugin.adtransparency.mediation.UnityAdsInjector;
import com.fyber.fairbid.plugin.adtransparency.mediation.VungleInjector;
import com.fyber.fairbid.plugin.adtransparency.utils.ExtensionsKt;
import com.fyber.fairbid.plugin.adtransparency.utils.Helpers;
import com.fyber.fairbid.plugin.adtransparency.utils.LogLevel;
import com.fyber.fairbid.plugin.adtransparency.utils.TpnInfoCollector;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0016\u001a\u00020\u000fJ(\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\rJ_\u0010\u001c\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010!\u001a\u0002H\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00050#2\u001a\u0010$\u001a\u0016\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00140\r2\u0006\u0010%\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010&J\u0085\u0001\u0010'\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u001d2\u0006\u0010!\u001a\u0002H\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u001e\u0010(\u001a\u001a\u0012\u0004\u0012\u0002H\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)\u0012\u0004\u0012\u00020\u000b0\r2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020,0#2\u001a\u0010$\u001a\u0016\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00140\r2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00050#\u00a2\u0006\u0002\u0010-R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/fyber/fairbid/plugin/adtransparency/InjectionCommonProcess;", "", "tpnInfoCollector", "Lcom/fyber/fairbid/plugin/adtransparency/utils/TpnInfoCollector;", "sourceName", "", "currentFairBidVersion", "agpVersion", "gradleVersion", "failIfInjectionProblemWithNetwork", "failIfInjectionProblem", "", "logger", "Lkotlin/Function2;", "Lcom/fyber/fairbid/plugin/adtransparency/utils/LogLevel;", "", "(Lcom/fyber/fairbid/plugin/adtransparency/utils/TpnInfoCollector;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLkotlin/jvm/functions/Function2;)V", "transformers", "", "Lkotlin/Pair;", "Lcom/fyber/fairbid/plugin/MediationNetwork;", "Lcom/fyber/fairbid/plugin/adtransparency/mediation/Injector;", "checkInjectionFinalStatus", "generateControllingClass", "pool", "Ljavassist/ClassPool;", "actualWrite", "Ljavassist/CtClass;", "handleException", "T", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "input", "copyFileToDestination", "Lkotlin/Function1;", "mediationNetworkFromInput", "message", "(Ljava/lang/Exception;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Ljava/lang/String;)V", "processInput", "shouldProcess", "", "Lcom/fyber/fairbid/plugin/adtransparency/utils/TpnInfoCollector$TpnInfo;", "inputConvertToFile", "Ljava/io/File;", "(Ljava/lang/Object;Ljavassist/ClassPool;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "Companion", "fairbid-sdk-plugin_common"})
@SourceDebugExtension(value={"SMAP\nInjectionCommonProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectionCommonProcess.kt\ncom/fyber/fairbid/plugin/adtransparency/InjectionCommonProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,232:1\n288#2,2:233\n1194#2,2:235\n1222#2,4:237\n1855#2,2:248\n1855#2,2:252\n1855#2,2:254\n515#3:241\n500#3,6:242\n13579#4,2:250\n*E\n*S KotlinDebug\n*F\n+ 1 InjectionCommonProcess.kt\ncom/fyber/fairbid/plugin/adtransparency/InjectionCommonProcess\n*L\n61#1,2:233\n71#1,2:235\n71#1,4:237\n90#1,2:248\n138#1,2:252\n218#1,2:254\n73#1:241\n73#1,6:242\n133#1,2:250\n*E\n"})
public final class InjectionCommonProcess {
    private final Set<Pair<MediationNetwork, Injector>> transformers;
    private final TpnInfoCollector tpnInfoCollector;
    private final String sourceName;
    private final String currentFairBidVersion;
    private final String agpVersion;
    private final String gradleVersion;
    private final String failIfInjectionProblemWithNetwork;
    private final boolean failIfInjectionProblem;
    private final Function2<String, LogLevel, Unit> logger;
    private static final String INJECTION_STATUS_CLASS = "com.fyber.fairbid.InjectionStatus";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final <T> void processInput(T input, @NotNull ClassPool pool, @NotNull Function2<? super T, ? super List<TpnInfoCollector.TpnInfo>, Boolean> shouldProcess, @NotNull Function1<? super T, ? extends File> inputConvertToFile, @NotNull Function2<? super T, ? super TpnInfoCollector, ? extends MediationNetwork> mediationNetworkFromInput, @NotNull Function1<? super T, String> copyFileToDestination) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter(shouldProcess, (String)"shouldProcess");
        Intrinsics.checkNotNullParameter(inputConvertToFile, (String)"inputConvertToFile");
        Intrinsics.checkNotNullParameter(mediationNetworkFromInput, (String)"mediationNetworkFromInput");
        Intrinsics.checkNotNullParameter(copyFileToDestination, (String)"copyFileToDestination");
        this.logger.invoke((Object)(this.sourceName + " - Processing jar " + input), (Object)LogLevel.INFO);
        try {
            Object v0;
            Object element$iv;
            Object $this$firstOrNull$iv;
            block13: {
                $this$firstOrNull$iv = this.transformers;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    Pair $dstr$network$_u24__u24 = (Pair)element$iv;
                    boolean bl = false;
                    MediationNetwork network = (MediationNetwork)((Object)$dstr$network$_u24__u24.component1());
                    if (!((Boolean)shouldProcess.invoke(input, this.tpnInfoCollector.getTpnInfoFor(network))).booleanValue()) continue;
                    v0 = element$iv;
                    break block13;
                }
                v0 = null;
            }
            Pair pair = v0;
            if (pair != null) {
                void $this$filterTo$iv$iv;
                Map classesToBeTransformed;
                Object it;
                Object element$iv$iv;
                Map $this$associateByTo$iv$iv;
                void network;
                $this$firstOrNull$iv = pair;
                Iterable $dstr$network$injector = $this$firstOrNull$iv;
                boolean bl = false;
                element$iv = (MediationNetwork)((Object)$dstr$network$injector.component1());
                Injector injector = (Injector)$dstr$network$injector.component2();
                this.logger.invoke((Object)(this.sourceName + " - Found transformer for " + network), (Object)LogLevel.INFO);
                File inputFile = (File)inputConvertToFile.invoke(input);
                List<String> allClassesInJar = ExtensionsKt.getListOfClasses(inputFile);
                List<CtClass> transformedClasses = injector.transform(pool, allClassesInJar);
                Iterable $this$associateBy$iv = transformedClasses;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                Iterator<Object> iterator = $this$associateByTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = iterator.next();
                    CtClass ctClass = (CtClass)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl2 = false;
                    String string = ExtensionsKt.asClassFileName((CtClass)it);
                    map.put(string, element$iv$iv);
                }
                Map $this$filter$iv = classesToBeTransformed = destination$iv$iv;
                boolean $i$f$filter = false;
                $this$associateByTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    it = element$iv$iv = (Map.Entry)iterator.next();
                    boolean bl3 = false;
                    if (!allClassesInJar.contains(it.getKey())) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map classesInJarToBeTransformed = destination$iv$iv;
                $this$filter$iv = classesInJarToBeTransformed;
                if (!$this$filter$iv.isEmpty()) {
                    this.logger.invoke((Object)(this.sourceName + " - The " + network + " jar contains classes that should be transformed"), (Object)LogLevel.INFO);
                    ExtensionsKt.addClasses(inputFile, classesInJarToBeTransformed.values());
                    String jarDestination = (String)copyFileToDestination.invoke(input);
                    this.logger.invoke((Object)(this.sourceName + " - Output for " + network + " written to " + jarDestination), (Object)LogLevel.INFO);
                } else {
                    this.logger.invoke((Object)(this.sourceName + " - The " + network + " jar does not contain any class that should be transformed"), (Object)LogLevel.INFO);
                    copyFileToDestination.invoke(input);
                }
                if (injector.getHasMultipleMavenEntries()) {
                    Iterable $this$forEach$iv = this.tpnInfoCollector.getTpnInfoFor((MediationNetwork)network);
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        TpnInfoCollector.TpnInfo it2 = (TpnInfoCollector.TpnInfo)element$iv2;
                        boolean bl4 = false;
                        injector.getVersions().add(it2.getVersion());
                    }
                }
            } else {
                $this$firstOrNull$iv = this;
                InjectionCommonProcess $this$run = (InjectionCommonProcess)$this$firstOrNull$iv;
                boolean bl = false;
                String cfr_ignored_0 = (String)copyFileToDestination.invoke(input);
            }
        }
        catch (CannotCompileException e) {
            this.handleException((Exception)((Object)e), input, copyFileToDestination, mediationNetworkFromInput, this.sourceName + " - Error when injecting code - " + e.getMessage());
        }
        catch (NotFoundException e) {
            this.handleException((Exception)((Object)e), input, copyFileToDestination, mediationNetworkFromInput, this.sourceName + " - Error in the transformer when looking for a class - " + e.getMessage());
        }
        catch (Exception e) {
            this.handleException(e, input, copyFileToDestination, mediationNetworkFromInput, this.sourceName + " - Error in the transformer - " + e.getMessage());
        }
    }

    private final <T> void handleException(Exception e, T input, Function1<? super T, String> copyFileToDestination, Function2<? super T, ? super TpnInfoCollector, ? extends MediationNetwork> mediationNetworkFromInput, String message) {
        block3: {
            block2: {
                this.logger.invoke((Object)(message + '\n' + ExtensionsKt.stackTraceToString(e)), (Object)LogLevel.ERROR);
                copyFileToDestination.invoke(input);
                MediationNetwork mediationNetwork = (MediationNetwork)((Object)mediationNetworkFromInput.invoke(input, (Object)this.tpnInfoCollector));
                if (this.failIfInjectionProblem) break block2;
                MediationNetwork mediationNetwork2 = mediationNetwork;
                if (!StringsKt.equals((String)this.failIfInjectionProblemWithNetwork, (String)(mediationNetwork2 != null ? mediationNetwork2.getTpnName() : null), (boolean)true)) break block3;
            }
            throw (Throwable)new InjectionException("Error when injecting code", e.getCause());
        }
    }

    public final void generateControllingClass(@NotNull ClassPool pool, @NotNull Function2<? super CtClass, ? super String, Unit> actualWrite) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter(actualWrite, (String)"actualWrite");
        try {
            CtField ctField;
            this.logger.invoke((Object)(this.sourceName + " - Creating new controlling class\u2026"), (Object)LogLevel.INFO);
            ClassFile classFile = new ClassFile(false, INJECTION_STATUS_CLASS, null);
            CtClass ctClass = pool.makeClass(classFile, false);
            Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"pool.makeClass(classFile, false)");
            CtClass controllingClass = ctClass;
            CtField[] ctFieldArray = controllingClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)ctFieldArray, (String)"controllingClass.fields");
            Object $this$forEach$iv = ctFieldArray;
            boolean $i$f$forEach = false;
            int n = ((CtField[])$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                CtField element$iv;
                CtField it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                controllingClass.removeField(it);
            }
            $this$forEach$iv = this.transformers;
            $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                CtField ctField2;
                Object element$iv = iterator.next();
                Pair $dstr$_u24__u24$injector = (Pair)element$iv;
                boolean bl = false;
                Injector injector = (Injector)$dstr$_u24__u24$injector.component2();
                CtField $this$apply = ctField2 = new CtField(CtClass.booleanType, injector.getNetwork().getCanonicalName(), controllingClass);
                boolean bl2 = false;
                $this$apply.setModifiers(10);
                CtField injectedField = ctField2;
                controllingClass.addField(injectedField, String.valueOf(injector.isNetworkFullyTransformed()));
                CtField $this$apply2 = $this$apply = new CtField(CtClass.booleanType, injector.getNetwork().getCanonicalName() + "VersionMatch", controllingClass);
                boolean bl3 = false;
                $this$apply2.setModifiers(10);
                CtField versionMatchField = $this$apply;
                boolean versionMatch = injector.getHasMultipleMavenEntries() ? injector.getVersions().size() == 1 : true;
                controllingClass.addField(versionMatchField, String.valueOf(versionMatch));
            }
            CtField $this$apply = $i$f$forEach = new CtField(pool.get("java.lang.String"), "pluginVersion", controllingClass);
            boolean bl = false;
            $this$apply.setModifiers(10);
            CtField pluginVersionField = $i$f$forEach;
            controllingClass.addField(pluginVersionField, '\"' + this.currentFairBidVersion + '\"');
            CtField $this$apply3 = $this$apply = new CtField(pool.get("java.lang.String"), "agpVersion", controllingClass);
            boolean bl4 = false;
            $this$apply3.setModifiers(10);
            CtField agpVersionField = $this$apply;
            controllingClass.addField(agpVersionField, '\"' + Helpers.INSTANCE.sanitizeVersion(this.agpVersion) + '\"');
            CtField $this$apply4 = ctField = new CtField(pool.get("java.lang.String"), "gradleVersion", controllingClass);
            boolean bl5 = false;
            $this$apply4.setModifiers(10);
            CtField gradleVersionField = ctField;
            controllingClass.addField(gradleVersionField, '\"' + Helpers.INSTANCE.sanitizeVersion(this.gradleVersion) + '\"');
            actualWrite.invoke((Object)controllingClass, (Object)INJECTION_STATUS_CLASS);
            this.logger.invoke((Object)(this.sourceName + " - Output for com.fyber.fairbid.InjectionStatus written"), (Object)LogLevel.INFO);
        }
        catch (Exception e) {
            this.logger.invoke((Object)(this.sourceName + " - There was an error creating InjectionStatus class: \n" + ExtensionsKt.stackTraceToString(e)), (Object)LogLevel.ERROR);
        }
    }

    public final void checkInjectionFinalStatus() {
        Iterable $this$forEach$iv = this.transformers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean shouldThrow;
            Pair $dstr$_u24__u24$injector = (Pair)element$iv;
            boolean bl = false;
            Injector injector = (Injector)$dstr$_u24__u24$injector.component2();
            String tpnName = injector.getNetwork().getCanonicalName();
            boolean bl2 = shouldThrow = !injector.isNetworkFullyTransformed();
            if (!StringsKt.equals((String)this.failIfInjectionProblemWithNetwork, (String)tpnName, (boolean)true) || !shouldThrow) continue;
            throw (Throwable)new InjectionException("Error when injecting code - Network '" + tpnName + "' needs changes!");
        }
    }

    public InjectionCommonProcess(@NotNull TpnInfoCollector tpnInfoCollector, @NotNull String sourceName, @NotNull String currentFairBidVersion, @NotNull String agpVersion, @NotNull String gradleVersion, @NotNull String failIfInjectionProblemWithNetwork, boolean failIfInjectionProblem, @NotNull Function2<? super String, ? super LogLevel, Unit> logger2) {
        Intrinsics.checkNotNullParameter((Object)tpnInfoCollector, (String)"tpnInfoCollector");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)currentFairBidVersion, (String)"currentFairBidVersion");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        Intrinsics.checkNotNullParameter((Object)failIfInjectionProblemWithNetwork, (String)"failIfInjectionProblemWithNetwork");
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        this.tpnInfoCollector = tpnInfoCollector;
        this.sourceName = sourceName;
        this.currentFairBidVersion = currentFairBidVersion;
        this.agpVersion = agpVersion;
        this.gradleVersion = gradleVersion;
        this.failIfInjectionProblemWithNetwork = failIfInjectionProblemWithNetwork;
        this.failIfInjectionProblem = failIfInjectionProblem;
        this.logger = logger2;
        this.transformers = SetsKt.setOf((Object[])new Pair[]{TuplesKt.to((Object)((Object)MediationNetwork.APPLOVIN), (Object)new AppLovinInjector(this.logger)), TuplesKt.to((Object)((Object)MediationNetwork.CHARTBOOST), (Object)new ChartboostInjector(this.logger)), TuplesKt.to((Object)((Object)MediationNetwork.IRONSOURCE), (Object)new IronSourceInjector(this.logger)), TuplesKt.to((Object)((Object)MediationNetwork.MINTEGRAL), (Object)new MintegralInjector(this.logger)), TuplesKt.to((Object)((Object)MediationNetwork.UNITYADS), (Object)new UnityAdsInjector(this.logger)), TuplesKt.to((Object)((Object)MediationNetwork.VUNGLE), (Object)new VungleInjector(this.logger)), TuplesKt.to((Object)((Object)MediationNetwork.PANGLE), (Object)new PangleInjector(this.logger))});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/fyber/fairbid/plugin/adtransparency/InjectionCommonProcess$Companion;", "", "()V", "INJECTION_STATUS_CLASS", "", "fairbid-sdk-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

