/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.adtransparency.interceptors.applovin;

import android.util.Log;
import com.applovin.sdk.AppLovinAdType;
import com.fyber.fairbid.adtransparency.common.MissingMetadataException;
import com.fyber.fairbid.adtransparency.interceptors.AbstractInterceptor;
import com.fyber.fairbid.adtransparency.interceptors.MetadataReport;
import com.fyber.fairbid.adtransparency.interceptors.MetadataStore;
import com.fyber.fairbid.internal.Constants;
import com.fyber.fairbid.internal.Logger;
import com.fyber.fairbid.mediation.Network;
import com.fyber.fairbid.yk;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002J\"\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016R\u001a\u0010\u000f\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/fyber/fairbid/adtransparency/interceptors/applovin/AppLovinInterceptor;", "Lcom/fyber/fairbid/adtransparency/interceptors/AbstractInterceptor;", "", "adJsonRaw", "", "processAd", "Lcom/fyber/fairbid/internal/Constants$AdType;", "adType", "adId", "content", "storeMetadataForInstance", "a", "Ljava/lang/String;", "getNetwork", "()Ljava/lang/String;", "network", "TAG", "<init>", "()V", "fairbid-sdk_release"})
public final class AppLovinInterceptor
extends AbstractInterceptor {
    @NotNull
    public static final AppLovinInterceptor INSTANCE = new AppLovinInterceptor();
    @NotNull
    public static final String a = Network.APPLOVIN.getCanonicalName();
    @NotNull
    public static final String TAG = "AppLovinInterceptor";
    @NotNull
    public static final LinkedHashMap b = new LinkedHashMap();
    @NotNull
    public static final LinkedHashMap c = new LinkedHashMap();
    @NotNull
    public static final LinkedHashMap d = new LinkedHashMap();

    @Override
    @NotNull
    public String getNetwork() {
        return a;
    }

    public final void processAd(@NotNull String string2) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"adJsonRaw");
        Object object = jSONObject;
        jSONObject = new JSONObject(string2);
        Logger.warn("AppLovinInterceptor - received a JSONObject with an ad!");
        string2 = jSONObject.optString("zone_id");
        if (string2 == null) {
            return;
        }
        JSONArray jSONArray = object.optJSONArray("ads");
        if (jSONArray == null) {
            return;
        }
        String string3 = object.optString("ad_type");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"adJson.optString(\"ad_type\")");
        object = AppLovinAdType.fromString((String)string3);
        object = (Intrinsics.areEqual((Object)object, (Object)AppLovinAdType.AUTO_INCENTIVIZED) ? true : Intrinsics.areEqual((Object)object, (Object)AppLovinAdType.INCENTIVIZED)) ? Constants.AdType.REWARDED : (Intrinsics.areEqual((Object)object, (Object)AppLovinAdType.REGULAR) ? Constants.AdType.INTERSTITIAL : Constants.AdType.UNKNOWN);
        int n10 = jSONArray.length();
        for (int i10 = 0; i10 < n10; ++i10) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i10);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"ads.getJSONObject(i)");
            String string4 = jSONObject2.getString("ad_id");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"adId");
            d.put(string2, string4);
            this.storeMetadataForInstance((Constants.AdType)((Object)object), string4, jSONObject2.toString());
        }
    }

    @Override
    public void storeMetadataForInstance(@NotNull Constants.AdType object, @NotNull String object2, @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"adType");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"adId");
        AppLovinInterceptor appLovinInterceptor = TuplesKt.to((Object)object, (Object)object2);
        if (!(string2 == null || string2.length() == 0)) {
            object = "AppLovinInterceptor - Storing metadata for key [" + appLovinInterceptor + ']';
            Intrinsics.checkNotNullParameter((Object)object, (String)"s");
            if (yk.a) {
                Log.v((String)"Snoopy", (String)object);
            }
            b.put(appLovinInterceptor, string2);
            object = c;
            object2 = (MetadataStore.MetadataCallback)((LinkedHashMap)object).get(appLovinInterceptor);
            if (object2 != null) {
                object2.onSuccess(new MetadataReport(null, string2));
                MetadataStore.MetadataCallback cfr_ignored_0 = (MetadataStore.MetadataCallback)object.remove(appLovinInterceptor);
            }
        } else {
            object = c;
            object2 = (MetadataStore.MetadataCallback)((LinkedHashMap)object).get(appLovinInterceptor);
            if (object2 != null) {
                object2.onError(MissingMetadataException.Companion.getAdNotInterceptedException());
                MetadataStore.MetadataCallback cfr_ignored_1 = (MetadataStore.MetadataCallback)object.remove(appLovinInterceptor);
            }
        }
    }

    @Override
    public final void getMetadataForInstanceInternal(@NotNull Constants.AdType object, @NotNull String object2, @NotNull MetadataStore.MetadataCallback object3) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"adType");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"instanceId");
        Intrinsics.checkNotNullParameter((Object)object3, (String)"callback");
        Object object4 = (String)d.get(object2);
        if (object4 == null) {
            object4 = "Unable to find the adId for given instanceId";
            Intrinsics.checkNotNullParameter((Object)"Unable to find the adId for given instanceId", (String)"msg");
            if (yk.a) {
                Log.e((String)"Snoopy", (String)object4);
            }
            return;
        }
        object4 = TuplesKt.to((Object)object, (Object)object4);
        object = c;
        object.put(object4, object3);
        object2 = b;
        if (object2.containsKey(object4)) {
            boolean bl2 = (object2 = (String)((LinkedHashMap)object2).get(object4)) == null || ((String)object2).length() == 0;
            if (bl2) {
                object2 = "Metadata is empty for the key " + object4 + ". Waiting for the callback.";
                Intrinsics.checkNotNullParameter((Object)object2, (String)"s");
                if (yk.a) {
                    Log.i((String)"Snoopy", (String)object2);
                }
            } else {
                MetadataReport metadataReport;
                MetadataStore.MetadataCallback metadataCallback = object3;
                object3 = metadataReport;
                metadataReport = new MetadataReport(null, (String)object2);
                metadataCallback.onSuccess((MetadataReport)object3);
            }
            object.remove(object4);
        } else {
            object4 = "There is no metadata for the key " + object4 + ". Waiting for the callback.";
            Intrinsics.checkNotNullParameter((Object)object4, (String)"s");
            if (yk.a) {
                Log.i((String)"Snoopy", (String)object4);
            }
        }
    }
}

