/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.common.lifecycle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fyber.fairbid.common.lifecycle.FetchFailure;
import com.fyber.fairbid.internal.Utils;

public class FetchResult {
    public final FetchFailure a;
    public final long b;

    public FetchResult(long l10) {
        this.b = l10;
        this.a = null;
    }

    public FetchResult(long l10, @NonNull FetchFailure fetchFailure) {
        this.b = l10;
        this.a = fetchFailure;
    }

    public boolean isSuccess() {
        return this.a == null;
    }

    @Nullable
    public FetchFailure getFetchFailure() {
        return this.a;
    }

    public String toString() {
        return "FetchResult{success=" + this.isSuccess() + ", fetchFailure=" + this.a + ", fetchTime" + this.b + '}';
    }

    public long getTime() {
        return this.b;
    }

    public static class Factory {
        public final Utils.ClockHelper a;

        public Factory(Utils.ClockHelper clockHelper) {
            this.a = clockHelper;
        }

        public FetchResult getSuccess() {
            return new FetchResult(this.a.getCurrentTimeMillis());
        }

        public FetchResult getTimeout() {
            return new FetchResult(this.a.getCurrentTimeMillis(), FetchFailure.TIMEOUT);
        }

        public FetchResult getNoFill() {
            return new FetchResult(this.a.getCurrentTimeMillis(), FetchFailure.NO_FILL);
        }

        public FetchResult getCapped() {
            return new FetchResult(this.a.getCurrentTimeMillis(), FetchFailure.CAPPED);
        }

        public FetchResult getAdapterNotStarted() {
            return new FetchResult(this.a.getCurrentTimeMillis(), FetchFailure.ADAPTER_NOT_STARTED);
        }

        public FetchResult getUnknown() {
            return new FetchResult(this.a.getCurrentTimeMillis(), FetchFailure.UNKNOWN);
        }

        public FetchResult getFailedFetchResult(FetchFailure fetchFailure) {
            return new FetchResult(this.a.getCurrentTimeMillis(), fetchFailure);
        }
    }
}

