/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.http;

import android.annotation.TargetApi;
import android.net.Uri;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J.\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00022\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u0002H\u0007J.\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00032\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0007J$\u0010\u000f\u001a\u00020\u00032\u001c\u0010\u0005\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00040\u0002\u00a8\u0006\u0012"}, d2={"Lcom/fyber/fairbid/http/FairBidHttpUtils;", "", "", "", "", "headers", "concatenateListIntoString", "url", "requestParams", "scheme", "Ljava/net/URL;", "urlBuilder", "", "isCleartextPermitted", "domain", "getContentType", "<init>", "()V", "fairbid-sdk_release"})
@SourceDebugExtension(value={"SMAP\nFairBidHttpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FairBidHttpUtils.kt\ncom/fyber/fairbid/http/FairBidHttpUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,62:1\n215#2,2:63\n215#2,2:65\n*S KotlinDebug\n*F\n+ 1 FairBidHttpUtils.kt\ncom/fyber/fairbid/http/FairBidHttpUtils\n*L\n38#1:63,2\n54#1:65,2\n*E\n"})
public final class FairBidHttpUtils {
    @NotNull
    public static final FairBidHttpUtils INSTANCE = new FairBidHttpUtils();

    @JvmStatic
    @NotNull
    public static final Map<String, String> concatenateListIntoString(@NotNull Map<String, ? extends List<String>> treeMap) {
        TreeMap<String, String> treeMap2;
        TreeMap<String, String> treeMap3 = treeMap;
        Intrinsics.checkNotNullParameter(treeMap3, (String)"headers");
        treeMap = treeMap2;
        treeMap2 = new TreeMap<String, String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        for (Map.Entry entry : treeMap3.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = TextUtils.join((CharSequence)",", (Iterable)((List)entry.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(\",\", value)");
            treeMap.put(string2, string3);
        }
        return treeMap;
    }

    @JvmStatic
    @NotNull
    public static final URL urlBuilder(@NotNull String string2, @NotNull Map<String, String> object, @NotNull String string3) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)object, (String)"requestParams");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"scheme");
        string2 = Uri.parse((String)string2).buildUpon();
        for (Map.Entry entry : object.entrySet()) {
            string2.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if ((string2 = string2.build()).isRelative()) {
            string2 = string2.buildUpon().scheme(string3).build();
        }
        return new URL(string2.toString());
    }

    @TargetApi(value=23)
    public final boolean isCleartextPermitted() {
        return Build.VERSION.SDK_INT >= 23 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() : true;
    }

    @TargetApi(value=23)
    public final boolean isCleartextPermitted(@Nullable String string2) {
        return Build.VERSION.SDK_INT >= 24 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(string2) : this.isCleartextPermitted();
    }

    @NotNull
    public final String getContentType(@NotNull Map<String, ? extends List<String>> map) {
        Map<String, ? extends List<String>> map2 = map;
        Intrinsics.checkNotNullParameter(map2, (String)"headers");
        List<String> list = map2.get("Content-Type");
        boolean bl2 = list == null || list.isEmpty();
        return !bl2 && !TextUtils.isEmpty((CharSequence)((CharSequence)list.get(0))) ? (String)list.get(0) : "";
    }
}

