/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fyber.fairbid.bi;
import com.fyber.fairbid.dm;
import com.fyber.fairbid.em;
import com.fyber.fairbid.internal.Constants;
import com.fyber.fairbid.internal.Logger;
import com.fyber.fairbid.kk;
import com.fyber.fairbid.t8;
import com.fyber.fairbid.u6;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.jvm.internal.Intrinsics;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    public static final Pattern a = Pattern.compile("[1-9][0-9]*");
    public static Pattern SEMVER_PATTERN = Pattern.compile("^([0-9]+)(?:\\.([0-9]+))?(?:\\.([0-9]+))?(?:\\.([0-9]+))?(?:-([0-9A-Za-z-]+(?:\\.[0-9A-Za-z-]+)*))?(?:\\+[0-9A-Za-z-]+)?$");
    public static Boolean b = null;
    public static String c = "unknown";
    public static final HashSet d = new HashSet<String>();

    public String getAppNameInstance(@NonNull Context context) {
        return Utils.getAppName(context);
    }

    public Locale getLocaleInstance(@NonNull Context context) {
        return Utils.getLocale(context);
    }

    public Boolean _classExists(String string2) {
        return Utils.classExists(string2);
    }

    public String _getValueWithoutInlining(String string2, String string3, String string4) {
        return Utils.getValueWithoutInlining(string2, string3, string4);
    }

    public dm isSemVersionEqualOrGreaterThan(@NonNull String string2, @NonNull String string3) {
        boolean bl2;
        block4: {
            try {
                int n10 = Utils.a(string2, string3);
                if (n10 != 0 && n10 != 1) {
                    bl2 = false;
                    break block4;
                }
                bl2 = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return dm.d;
            }
        }
        return em.a(bl2);
    }

    public boolean isEmulator() {
        String string2 = Build.PRODUCT;
        Iterator iterator = d.iterator();
        while (iterator.hasNext()) {
            if (!string2.startsWith((String)iterator.next())) continue;
            return true;
        }
        return Build.DEVICE.startsWith("generic");
    }

    public boolean isRunningOnAmazonDevice() {
        return Build.MANUFACTURER.equals("Amazon");
    }

    public boolean packageHasPermissions(Context context, @NonNull List<String> object) {
        Iterator<String> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)object, (String)"permission");
            boolean bl2 = context.getPackageManager().checkPermission((String)object, context.getPackageName()) == 0;
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public static void setDebug(boolean bl2) {
        b = bl2;
    }

    public static Boolean isDebug(Context context) {
        if (b == null) {
            boolean bl2 = bi.a(context, Constants.TEST_APP_PACKAGE) || bi.a(context, Constants.TEST_APP_PACKAGE_RELEASE);
            if (bl2) {
                Log.i((String)"FairbidUtils", (String)"debugging logging turned on because test app is present on the device");
            }
            Utils.setDebug(bl2);
        }
        return b;
    }

    public static String getAppName(Context context) {
        if (c.equals("unknown") && context != null) {
            c = context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString();
        }
        return c;
    }

    @Nullable
    public static String getCountryIso(@NonNull Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkCountryIso();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Locale getLocale(@NonNull Context context) {
        context = context.getResources().getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            return context.getLocales().get(0);
        }
        return context.locale;
    }

    @NonNull
    public static Boolean classExists(String string2) {
        try {
            Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean methodExists(@NonNull String methodArray, @NonNull String string2, @Nullable t8<Class[], Boolean> t82, @Nullable t8<Class, Boolean> t83) {
        if (Utils.classExists((String)methodArray).booleanValue()) {
            Method[] methodArray2 = methodArray;
            methodArray = new Method[]{};
            try {
                methodArray = Class.forName((String)methodArray2).getMethods();
            }
            catch (ClassNotFoundException classNotFoundException) {}
            for (Method method : methodArray) {
                if (!string2.equals(method.getName()) || t82 != null && !t82.apply(method.getParameterTypes()).booleanValue() || t83 != null && !t83.apply(method.getReturnType()).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExpired(long l10, int n10) {
        return (long)n10 < System.currentTimeMillis() - l10;
    }

    public static boolean activityExistsInPackage(Context context, Class clazz) {
        return new Intent(context, clazz).resolveActivityInfo(context.getPackageManager(), 0) != null;
    }

    public static boolean activityExistsInPackage(Context context, String string2) {
        try {
            return Utils.activityExistsInPackage(context, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getValueWithoutInlining(String string2, String string3, String string4) {
        try {
            return Utils.getValueWithoutInlining(Class.forName(string2), string3, string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string4;
        }
    }

    public static String getValueWithoutInlining(@NonNull Class clazz, String string2, String string3) {
        try {
            string3 = clazz.getDeclaredField(string2).get(null).toString();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return string3;
    }

    @Nullable
    public static <T> T getClassFieldValue(@NonNull Class<?> clazz, String string2) {
        return Utils.getClassFieldValue(clazz.getName(), string2);
    }

    @Nullable
    public static <T> T getClassFieldValue(String string2, String string3) {
        try {
            Field field = Class.forName(string2).getDeclaredField(string3);
            ((AccessibleObject)field).setAccessible(true);
            return (T)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Logger.warn("Utils - Error when accessing '" + string3 + "' in '" + string2 + "'");
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.warn("Utils - Error when accessing '" + string3 + "' in '" + string2 + "'");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.warn("Utils - Error when accessing '" + string3 + "' in '" + string2 + "'");
        }
        return null;
    }

    @NonNull
    public static String getMapAsUrlParams(Map<String, String> object) {
        if (object != null && !object.isEmpty()) {
            Uri.Builder builder;
            Uri.Builder builder2 = object;
            object = builder;
            builder = new Uri.Builder();
            for (Map.Entry entry : builder2.entrySet()) {
                object.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
            if ((object = object.build().getEncodedQuery()) == null) {
                object = "";
            }
            return object;
        }
        return "";
    }

    @Nullable
    public static Map<String, String> getMapFromJsonString(String string2) {
        Iterator iterator;
        JSONObject jSONObject;
        HashMap<String, String> hashMap;
        if (string2 == null) {
            return null;
        }
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        JSONObject jSONObject2 = jSONObject;
        try {
            iterator = new JSONObject(string2).keys();
        }
        catch (JSONException jSONException) {
            Log.e((String)"FairBidSDK", (String)"unable to convert the json dictionary: ".concat(string2));
            return null;
        }
        while (true) {
            if (!iterator.hasNext()) break;
            HashMap<String, String> hashMap3 = hashMap2;
            JSONObject jSONObject3 = jSONObject2;
            String string3 = (String)iterator.next();
            hashMap3.put(string3, jSONObject3.getString(string3));
        }
        return hashMap2;
    }

    @NonNull
    public static Map<String, Object> createMapFromJsonObject(@Nullable JSONObject jSONObject) {
        HashMap<String, Object> hashMap;
        if (jSONObject == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap = new HashMap<String, Object>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashMap2.put(string2, jSONObject.opt(string2));
        }
        return hashMap2;
    }

    @NonNull
    public static JSONObject createJsonObjectFromString(@Nullable String string2) {
        if (string2 == null) {
            return new JSONObject();
        }
        try {
            return new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            Logger.error("Cannot create JSONObject from string - ".concat(string2));
            return new JSONObject();
        }
    }

    @NonNull
    public static JSONObject getJSONEntryOrEmpty(@Nullable JSONObject jSONObject, String string2) {
        if (jSONObject != null && jSONObject.has(string2)) {
            try {
                return jSONObject.getJSONObject(string2);
            }
            catch (JSONException jSONException) {}
        }
        return new JSONObject();
    }

    @Nullable
    public static int[] getIntArrayFromJSONArray(@Nullable JSONArray jSONArray) {
        if (jSONArray != null) {
            int n10 = jSONArray.length();
            int[] nArray = new int[n10];
            for (int i10 = 0; i10 < n10; ++i10) {
                nArray[i10] = jSONArray.optInt(i10);
            }
            return nArray;
        }
        return null;
    }

    @Nullable
    public static long[] getLongArrayFromJSONArray(@Nullable JSONArray jSONArray) {
        return Utils.getLongArrayFromJSONArray(jSONArray, null);
    }

    @Nullable
    public static long[] getLongArrayFromJSONArray(@Nullable JSONArray jSONArray, @Nullable u6<Long> u62) {
        if (jSONArray != null) {
            int n10 = jSONArray.length();
            long[] lArray = new long[n10];
            int n11 = 0;
            for (int i10 = 0; i10 < jSONArray.length(); ++i10) {
                long l10 = jSONArray.optLong(i10, Long.MIN_VALUE);
                if (l10 != Long.MIN_VALUE && (u62 == null || u62.a(l10))) {
                    lArray[i10 - n11] = l10;
                    continue;
                }
                ++n11;
            }
            return Arrays.copyOfRange(lArray, 0, n10 - n11);
        }
        return null;
    }

    public static int a(String string2, String object) throws IllegalArgumentException {
        Matcher matcher = SEMVER_PATTERN.matcher(string2);
        Matcher matcher2 = SEMVER_PATTERN.matcher((CharSequence)object);
        if (matcher.matches() && matcher2.matches()) {
            int n10 = 4;
            object = new int[4];
            int[] nArray = new int[4];
            for (int i10 = 1; i10 <= n10; ++i10) {
                String string3 = matcher.group(i10);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    int n11 = i10 - 1;
                    object[n11] = Integer.parseInt(string3);
                }
                if (TextUtils.isEmpty((CharSequence)(string3 = matcher2.group(i10)))) continue;
                int n12 = i10 - 1;
                nArray[n12] = Integer.parseInt(string3);
            }
            return Utils.a((int[])object, nArray);
        }
        throw new IllegalArgumentException("Non semantic version provided: " + string2 + " - " + (String)object);
    }

    public static int a(int[] nArray, int[] nArray2) {
        if (nArray.length == 0) {
            return 0;
        }
        int n10 = nArray[0];
        int n11 = nArray2[0];
        if (n10 > n11) {
            return 1;
        }
        if (n10 < n11) {
            return -1;
        }
        return Utils.a(Arrays.copyOfRange(nArray, 1, nArray.length), Arrays.copyOfRange(nArray2, 1, nArray2.length));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generateDigestForString(@NonNull String object, String object2) {
        Object[] objectArray;
        Object object3;
        Formatter formatter;
        Formatter formatter2;
        Object object4 = object2;
        object2 = "nosignature";
        byte[] byArray = MessageDigest.getInstance((String)object4).digest(((String)object).getBytes());
        object = byArray;
        Formatter formatter3 = formatter2;
        try {
            formatter2 = new Formatter();
            int n10 = byArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                formatter = formatter3;
                object3 = object[i10];
                objectArray = new Object[1];
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return object2;
        }
        {
            Object[] objectArray2 = objectArray;
            objectArray[0] = (byte)object3;
            formatter.format("%02x", objectArray2);
            continue;
        }
        Formatter formatter4 = formatter3;
        object = formatter4.toString();
        formatter4.close();
        return object;
    }

    @Nullable
    public static String generateSignature(@NonNull String object) {
        BigInteger bigInteger;
        try {
            object = ((String)object).getBytes(Charset.defaultCharset());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.error("Error while creating signature", noSuchAlgorithmException);
            return null;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update((byte[])object);
        object = messageDigest.digest();
        BigInteger bigInteger2 = bigInteger;
        bigInteger = new BigInteger(1, (byte[])object);
        Locale locale = Locale.US;
        StringBuilder stringBuilder = new StringBuilder("%0");
        int n10 = ((Object)object).length;
        return String.format(locale, stringBuilder.append(n10 << 1).append("x").toString(), bigInteger2);
    }

    public static int parseId(String string2) {
        if (string2 != null && a.matcher(string2).matches()) {
            try {
                int n10 = Integer.parseInt(string2, 10);
                if (n10 <= 0) {
                    n10 = -1;
                }
                return n10;
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    @Nullable
    public static String safeJsonPrettyPrint(@Nullable JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            return jSONObject.toString(2);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    public static String getGradleVersion() {
        return (String)kk.a("com.fyber.fairbid.InjectionStatus", "gradleVersion");
    }

    static {
        d.add("vbox86tp");
        d.add("vbox86p");
        d.add("google_sdk");
        d.add("sdk");
    }

    public static class ClockHelper {
        public long getCurrentTimeMillis() {
            return System.currentTimeMillis();
        }

        public final double getUnixTimestamp() {
            return (double)this.getCurrentTimeMillis() * 0.001;
        }
    }
}

