/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.fairbid.sdk.session;

import android.content.Context;
import android.content.SharedPreferences;
import com.fyber.fairbid.internal.Constants;
import com.fyber.fairbid.internal.Logger;
import com.fyber.fairbid.sdk.session.Storage;
import com.fyber.fairbid.sdk.session.UserSessionState;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0004\u001a\u00020\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0016R0\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/fyber/fairbid/sdk/session/UserSessionStorage;", "Lcom/fyber/fairbid/sdk/session/Storage;", "", "resetAllData", "resetLastSession", "Lcom/fyber/fairbid/sdk/session/UserSessionState;", "getLastSession", "", "startTimestamp", "saveStart", "duration", "saveDuration", "Lcom/fyber/fairbid/internal/Constants$AdType;", "adType", "", "number", "saveImpressions", "saveClicks", "saveCompletions", "disablePersistence", "enablePersistence", "", "value", "getStoredSessions", "()Ljava/util/List;", "setStoredSessions", "(Ljava/util/List;)V", "storedSessions", "Landroid/content/SharedPreferences;", "storagePrefs", "<init>", "(Landroid/content/SharedPreferences;)V", "Companion", "fairbid-sdk_release"})
@SourceDebugExtension(value={"SMAP\nUserSessionStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserSessionStorage.kt\ncom/fyber/fairbid/sdk/session/UserSessionStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1549#2:169\n1620#2,3:170\n1549#2:173\n1620#2,3:174\n1549#2:177\n1620#2,3:178\n1855#2,2:181\n*S KotlinDebug\n*F\n+ 1 UserSessionStorage.kt\ncom/fyber/fairbid/sdk/session/UserSessionStorage\n*L\n34#1:169\n34#1:170,3\n36#1:173\n36#1:174,3\n41#1:177\n41#1:178,3\n52#1:181,2\n*E\n"})
public final class UserSessionStorage
implements Storage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFERENCES_FILE_NAME = "com.fyber.fairbid.user_sessions";
    @NotNull
    public static final String PAST_SESSIONS = "past_sessions";
    @NotNull
    public static final String START = "start";
    @NotNull
    public static final String DURATION = "duration";
    @NotNull
    public static final String REW_IMPRESSIONS = "rew_impressions";
    @NotNull
    public static final String INT_IMPRESSIONS = "int_impressions";
    @NotNull
    public static final String BAN_IMPRESSIONS = "ban_impressions";
    @NotNull
    public static final String REW_CLICKS = "rew_clicks";
    @NotNull
    public static final String INT_CLICKS = "int_clicks";
    @NotNull
    public static final String BAN_CLICKS = "ban_clicks";
    @NotNull
    public static final String REW_COMPLETIONS = "rew_completions";
    @NotNull
    public final SharedPreferences a;
    public final SharedPreferences.Editor b;
    public boolean c;

    public UserSessionStorage(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"storagePrefs");
        this.a = sharedPreferences;
        this.b = sharedPreferences.edit();
    }

    @NotNull
    public final List<UserSessionState> getStoredSessions() {
        ArrayList arrayList;
        ArrayList<JSONObject> arrayList2;
        Object object = ((UserSessionStorage)object).a.getStringSet(PAST_SESSIONS, null);
        if (object == null) {
            object = SetsKt.emptySet();
        }
        Object object2 = arrayList2;
        arrayList2 = new ArrayList<JSONObject>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            object2.add(new JSONObject(string2));
        }
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            EnumMap enumMap;
            EnumMap enumMap2;
            JSONObject jSONObject = (JSONObject)object2.next();
            long l10 = jSONObject.getLong(START);
            long l11 = jSONObject.optLong(DURATION, 0L);
            int n10 = jSONObject.optInt(REW_CLICKS, 0);
            int n11 = jSONObject.optInt(INT_CLICKS, 0);
            int n12 = jSONObject.optInt(BAN_CLICKS, 0);
            int n13 = jSONObject.optInt(REW_IMPRESSIONS, 0);
            int n14 = jSONObject.optInt(INT_IMPRESSIONS, 0);
            int n15 = jSONObject.optInt(BAN_IMPRESSIONS, 0);
            int n16 = jSONObject.optInt(REW_COMPLETIONS, 0);
            EnumMap enumMap3 = enumMap2;
            Pair[] pairArray = new Pair[3];
            Constants.AdType adType = Constants.AdType.INTERSTITIAL;
            pairArray[0] = TuplesKt.to((Object)((Object)adType), (Object)n11);
            Constants.AdType adType2 = Constants.AdType.REWARDED;
            pairArray[1] = TuplesKt.to((Object)((Object)adType2), (Object)n10);
            Constants.AdType adType3 = Constants.AdType.BANNER;
            pairArray[2] = TuplesKt.to((Object)((Object)adType3), (Object)n12);
            enumMap2 = new EnumMap(MapsKt.mapOf((Pair[])pairArray));
            EnumMap enumMap4 = enumMap;
            Pair[] pairArray2 = new Pair[3];
            Pair[] pairArray3 = pairArray2;
            pairArray3[0] = TuplesKt.to((Object)((Object)adType), (Object)n14);
            pairArray3[1] = TuplesKt.to((Object)((Object)adType2), (Object)n13);
            pairArray2[2] = TuplesKt.to((Object)((Object)adType3), (Object)n15);
            enumMap = new EnumMap(MapsKt.mapOf((Pair[])pairArray2));
            object.add(new UserSessionState(l10, l11, enumMap4, enumMap3, n16, null, 32, null));
        }
        return object;
    }

    public final void setStoredSessions(@NotNull List<UserSessionState> object) {
        ArrayList<String> arrayList;
        List<UserSessionState> list = object;
        Intrinsics.checkNotNullParameter(list, (String)"value");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        for (Object object2 : list) {
            JSONObject jSONObject;
            Object object3 = jSONObject;
            UserSessionState userSessionState = object2;
            JSONObject jSONObject2 = object3;
            UserSessionState userSessionState2 = object2;
            JSONObject jSONObject3 = object3;
            UserSessionState userSessionState3 = object2;
            JSONObject jSONObject4 = object3;
            UserSessionState userSessionState4 = object2;
            JSONObject jSONObject5 = object3;
            UserSessionState userSessionState5 = object2;
            JSONObject jSONObject6 = object3;
            UserSessionState userSessionState6 = object2;
            UserSessionState userSessionState7 = object2;
            object3();
            long l10 = object2.getStartTimestamp();
            object3.put(START, l10);
            l10 = object2.getDuration();
            object3.put(DURATION, l10);
            object2 = Constants.AdType.REWARDED;
            object3.put(REW_CLICKS, userSessionState7.clicksFor((Constants.AdType)((Object)object2)));
            object3 = Constants.AdType.INTERSTITIAL;
            jSONObject6.put(INT_CLICKS, userSessionState6.clicksFor((Constants.AdType)((Object)object3)));
            Constants.AdType adType = Constants.AdType.BANNER;
            jSONObject5.put(BAN_CLICKS, userSessionState5.clicksFor(adType));
            jSONObject4.put(REW_IMPRESSIONS, userSessionState4.impressionsFor((Constants.AdType)((Object)object2)));
            jSONObject3.put(INT_IMPRESSIONS, userSessionState3.impressionsFor((Constants.AdType)((Object)object3)));
            jSONObject2.put(BAN_IMPRESSIONS, userSessionState2.impressionsFor(adType));
            jSONObject.put(REW_COMPLETIONS, userSessionState.getCompletions());
            arrayList2.add(jSONObject.toString());
        }
        UserSessionStorage userSessionStorage = set;
        Set set = CollectionsKt.toSet(arrayList2);
        userSessionStorage.a.edit().putStringSet(PAST_SESSIONS, set).apply();
    }

    public final void resetAllData() {
        this.b.clear().apply();
    }

    public final void resetLastSession() {
        for (String string2 : CollectionsKt.listOf((Object[])new String[]{START, DURATION, REW_IMPRESSIONS, INT_IMPRESSIONS, BAN_IMPRESSIONS, REW_CLICKS, INT_CLICKS, BAN_CLICKS, REW_COMPLETIONS})) {
            this.b.remove(string2);
        }
        this.b.apply();
    }

    @Nullable
    public final UserSessionState getLastSession() {
        if (this.a.contains(START)) {
            EnumMap enumMap;
            EnumMap enumMap2;
            UserSessionStorage userSessionStorage = this;
            int n10 = userSessionStorage.a.getInt(INT_CLICKS, 0);
            int n11 = userSessionStorage.a.getInt(REW_CLICKS, 0);
            int n12 = userSessionStorage.a.getInt(BAN_CLICKS, 0);
            int n13 = userSessionStorage.a.getInt(INT_IMPRESSIONS, 0);
            int n14 = userSessionStorage.a.getInt(REW_IMPRESSIONS, 0);
            int n15 = userSessionStorage.a.getInt(BAN_IMPRESSIONS, 0);
            long l10 = userSessionStorage.a.getLong(START, 0L);
            long l11 = userSessionStorage.a.getLong(DURATION, 0L);
            int n16 = userSessionStorage.a.getInt(REW_COMPLETIONS, 0);
            EnumMap enumMap3 = enumMap2;
            Pair[] pairArray = new Pair[3];
            Constants.AdType adType = Constants.AdType.INTERSTITIAL;
            pairArray[0] = TuplesKt.to((Object)((Object)adType), (Object)n10);
            Constants.AdType adType2 = Constants.AdType.REWARDED;
            pairArray[1] = TuplesKt.to((Object)((Object)adType2), (Object)n11);
            Constants.AdType adType3 = Constants.AdType.BANNER;
            pairArray[2] = TuplesKt.to((Object)((Object)adType3), (Object)n12);
            enumMap2 = new EnumMap(MapsKt.mapOf((Pair[])pairArray));
            EnumMap enumMap4 = enumMap;
            Pair[] pairArray2 = new Pair[3];
            Pair[] pairArray3 = pairArray2;
            pairArray3[0] = TuplesKt.to((Object)((Object)adType), (Object)n13);
            pairArray3[1] = TuplesKt.to((Object)((Object)adType2), (Object)n14);
            pairArray2[2] = TuplesKt.to((Object)((Object)adType3), (Object)n15);
            enumMap = new EnumMap(MapsKt.mapOf((Pair[])pairArray2));
            return new UserSessionState(l10, l11, enumMap4, enumMap3, n16, null, 32, null);
        }
        return null;
    }

    @Override
    public void saveStart(long l10) {
        if (((UserSessionStorage)((Object)string2)).c) {
            UserSessionStorage userSessionStorage = string2;
            String string2 = START;
            userSessionStorage.b.putLong(string2, l10).apply();
        }
    }

    @Override
    public void saveDuration(long l10) {
        if (((UserSessionStorage)((Object)string2)).c) {
            UserSessionStorage userSessionStorage = string2;
            String string2 = DURATION;
            userSessionStorage.b.putLong(string2, l10).apply();
        }
    }

    @Override
    public void saveImpressions(@NotNull Constants.AdType adType, int n10) {
        Intrinsics.checkNotNullParameter((Object)((Object)adType), (String)"adType");
        if (this.c) {
            int n11 = WhenMappings.$EnumSwitchMapping$0[adType.ordinal()];
            if (n11 != 1) {
                if (n11 != 2) {
                    if (n11 != 3) {
                        Logger.error("Cannot save impression for " + (Object)((Object)adType));
                    } else {
                        this.a(n10, BAN_IMPRESSIONS);
                    }
                } else {
                    this.a(n10, INT_IMPRESSIONS);
                }
            } else {
                this.a(n10, REW_IMPRESSIONS);
            }
        }
    }

    @Override
    public void saveClicks(@NotNull Constants.AdType adType, int n10) {
        Intrinsics.checkNotNullParameter((Object)((Object)adType), (String)"adType");
        if (this.c) {
            int n11 = WhenMappings.$EnumSwitchMapping$0[adType.ordinal()];
            if (n11 != 1) {
                if (n11 != 2) {
                    if (n11 != 3) {
                        Logger.error("Cannot save click for " + (Object)((Object)adType));
                    } else {
                        this.a(n10, BAN_CLICKS);
                    }
                } else {
                    this.a(n10, INT_CLICKS);
                }
            } else {
                this.a(n10, REW_CLICKS);
            }
        }
    }

    @Override
    public void saveCompletions(int n10) {
        if (this.c) {
            this.a(n10, REW_COMPLETIONS);
        }
    }

    @Override
    public void disablePersistence() {
        this.c = false;
    }

    @Override
    public void enablePersistence() {
        this.c = true;
    }

    public final void a(int n10, String string2) {
        this.b.putInt(string2, n10).apply();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/fyber/fairbid/sdk/session/UserSessionStorage$Companion;", "", "()V", "BAN_CLICKS", "", "BAN_IMPRESSIONS", "DURATION", "INT_CLICKS", "INT_IMPRESSIONS", "PAST_SESSIONS", "PREFERENCES_FILE_NAME", "REW_CLICKS", "REW_COMPLETIONS", "REW_IMPRESSIONS", "START", "sharedPrefs", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "fairbid-sdk_release"})
    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @NotNull
        public final SharedPreferences sharedPrefs(@NotNull Context context) {
            Context context2 = context;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            SharedPreferences sharedPreferences = context2.getSharedPreferences(UserSessionStorage.PREFERENCES_FILE_NAME, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
            return sharedPreferences;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Constants.AdType.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Constants.AdType.REWARDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Constants.AdType.INTERSTITIAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Constants.AdType.BANNER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

