/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

import com.fyber.inneractive.sdk.config.IAUnitConfigProvider;

import java.util.concurrent.TimeUnit;

/**
 * Base class for defining an ad request
 * <br>Currently used only for native ads. Banners and Interstitials still use a direct API
 */
public class InneractiveAdRequest extends com.fyber.inneractive.sdk.flow.InternalAdRequest {
	// Members

	// Global request params
	/** Spot id */
	private String mSpotId;
	/** The selected unit config, which will be used when reusing this request */
	private IAUnitConfigProvider selectedUnitConfig;

	/**
	 * Constructor
	 * @param spotId AKA appId. As provided in the Inneractive console
	 */
	public InneractiveAdRequest(String spotId) {
		mSpotId = spotId;
	}

	/** Returns the attached spot id */
	public String getSpotId() {
		return mSpotId;
	}
	
	/**
	 * @deprecated use {@link InneractiveAdManager#setUserParams(InneractiveUserConfig)})}
	 * Set user related parameters specific for this ad
	 * @param userParams InneractiveUserConfig object, defining user related parameters
	 */
	@Deprecated
	public void setUserParams(InneractiveUserConfig userParams) {
		InneractiveAdManager.setUserParams(userParams);
	}
	
	/**
	 * @deprecated use {@link InneractiveAdManager#setKeywords(String)}
	 * Set mKeywords specific to this ad
	 * @param keywords	Comma separated string of words
	 */
	@Deprecated
	public void setKeywords(String keywords) {
		InneractiveAdManager.setKeywords(keywords);
	}

	/**
	 * @deprecated use {@link com.fyber.inneractive.sdk.external.InneractiveAdManager#setMuteVideo(boolean)}
	 * Set muteVideo for full screen videos
	 * @param muteVideo set to true or false
	 */
	@Deprecated
	public void setMuteVideo(boolean muteVideo) {
		InneractiveAdManager.setMuteVideo(muteVideo);
	}

	// Getters
	/** Getter for user parameters */
	@Deprecated
	public InneractiveUserConfig getUserParams() {
		return InneractiveAdManager.getUserParams();
	}

	/** Getter for mKeywords */
	@Deprecated
	public String getKeywords() {
		return InneractiveAdManager.getKeywords();
	}

	/** Call this if you want this request to use a specific unit configuration */
	public void setSelectedUnitConfig(IAUnitConfigProvider unitConfig) {
		selectedUnitConfig = unitConfig;
	}

	/** Getter for selected unit config */
	public IAUnitConfigProvider getSelectedUnitConfig() {
		return selectedUnitConfig;
	}

	/** Getter for mute video state */
	@Deprecated
	public boolean getMuteVideo() {
		return InneractiveAdManager.getMuteVideo();
    }
}
