/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

import com.fyber.inneractive.sdk.external.InneractiveUnitController.AdDisplayError;

/**
 * External interface for a fullscreen ad unit controller
 */

public interface InneractiveFullscreenAdEventsListener extends InneractiveUnitController.EventsListener {
    /**
     * Called after Inneractive tracked an ad impression
     * @param adSpot
     */
    public void onAdImpression(InneractiveAdSpot adSpot);

    /**
     * Called after Inneractive tracked an ad click
     * @param adSpot
     */
    public void onAdClicked(InneractiveAdSpot adSpot);

    /**
     * Called after Inneractive decided to open another application, due to a click
     * @param adSpot
     */
    public void onAdWillOpenExternalApp(InneractiveAdSpot adSpot);

    /**
     * Called when an ad has entered an error state, this will only happen when the ad is being shown
     * @param adSpot the relevant ad spot
     */
    public void onAdEnteredErrorState(InneractiveAdSpot adSpot, AdDisplayError error);

    /**
     * Called after Inneractive decided to open another application, due to a click
     * @param adSpot
     */
    public void onAdWillCloseInternalBrowser(InneractiveAdSpot adSpot);

    /**
     * Called when the full screen unit have been dismissed
     */
    public void onAdDismissed(InneractiveAdSpot adSpot);
}
