/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.inneractive.sdk.config.enums;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;

public enum Orientation {
    LANDSCAPE("landscape", false),
    PORTRAIT("portrait", false),
    USER("user", true),
    NONE("none", true);

    private static final Map<String, Orientation> CONSTANTS;
    private final String value;
    public boolean allowOrientationChange;

    private Orientation(String string2, boolean bl) {
        this.value = string2;
        this.allowOrientationChange = bl;
    }

    public static Orientation fromValue(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return CONSTANTS.get(string);
    }

    static {
        CONSTANTS = new HashMap<String, Orientation>();
        for (Orientation orientation : Orientation.values()) {
            CONSTANTS.put(orientation.value, orientation);
        }
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }
}

