/*
 * Decompiled with CFR 0.152.
 */
package com.fyber.inneractive.sdk.config.enums;

import java.util.HashMap;
import java.util.Map;

public enum UnitDisplayType {
    INTERSTITIAL("interstitial", false),
    LANDSCAPE("landscape", true),
    MRECT("mrect", false),
    BANNER("banner", false),
    REWARDED("rewarded", false),
    SQUARE("square", true),
    VERTICAL("vertical", true),
    DEFAULT("default", false);

    private static final Map<String, UnitDisplayType> CONSTANTS;
    private final boolean deprecated;
    private String stringValue;

    private UnitDisplayType(String string2, boolean bl) {
        this.stringValue = string2;
        this.deprecated = bl;
    }

    public static UnitDisplayType fromValue(String object) {
        if ((object = CONSTANTS.get(object)) == null) {
            object = DEFAULT;
        }
        return object;
    }

    static {
        CONSTANTS = new HashMap<String, UnitDisplayType>();
        for (UnitDisplayType unitDisplayType : UnitDisplayType.values()) {
            CONSTANTS.put(unitDisplayType.stringValue, unitDisplayType);
        }
    }

    public String value() {
        return this.stringValue;
    }

    public boolean isFullscreenUnit() {
        return this == INTERSTITIAL || this == REWARDED;
    }

    public String toString() {
        return this.stringValue;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }
}

