/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

/**
 * Public Configuration class
 * <br>MediationName values are ADMOB, DFP, FYBER and OTHER. if you're using a mediation, please set the mediation name to improve your performance.
 */
public enum InneractiveMediationName {
	ADMOB (InneractiveMediationNameConsts.ADMOB),
    DFP(InneractiveMediationNameConsts.DFP),
    FYBER(InneractiveMediationNameConsts.FYBER),
	OTHER (InneractiveMediationNameConsts.OTHER);

    // Members
    /** Map enum to String, for logging and events */
	final String key;

    /**
     * Constructor
     * @param key key string value
     */
	InneractiveMediationName(String key) {
        this.key = key;
    }

    /** Getter for key */
    public String getKey() {
        return this.key;
    }
}