/*
 * Copyright (c) 2020. Fyber N.V -  All Rights Reserved
 */

package com.fyber.inneractive.sdk.external;

import com.fyber.inneractive.sdk.flow.InneractiveAdContent;
import com.fyber.inneractive.sdk.flow.InneractiveVideoAdContent;
import com.fyber.inneractive.sdk.flow.InneractiveVideoContentControllerBase;
import com.fyber.inneractive.sdk.renderers.InneractiveFullscreenVideoAdRenderer;

import java.lang.ref.WeakReference;

/**
 * Add specific full screen video content controllering options
 */

public class InneractiveFullscreenVideoContentController extends InneractiveVideoContentControllerBase {
    // Members
    /** The controller renderer */
    WeakReference<InneractiveFullscreenVideoAdRenderer> mRenderer;

    /**
     * Sets the renderer this content controller will control. Called by unit controller
     * @param renderer
     */
    public void setControlledRenderer(InneractiveFullscreenVideoAdRenderer renderer) {
        mRenderer = new WeakReference<InneractiveFullscreenVideoAdRenderer>(renderer);
    }

    @Override
    public boolean canControl(InneractiveAdSpot adSpot) {
        // TODO: Also check that the unit type is fullscreen
        InneractiveAdContent adContent = adSpot.getAdContent();
        if (adContent instanceof InneractiveVideoAdContent) {
            return true;
        }

        return false;
    }
}
