/*
 * Decompiled with CFR 0.152.
 */
package com.gabrielittner.threetenbp;

import android.content.Context;
import com.gabrielittner.threetenbp.LazyZoneRules;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.threeten.bp.jdk8.Jdk8Methods;
import org.threeten.bp.zone.ZoneRules;
import org.threeten.bp.zone.ZoneRulesCompat;
import org.threeten.bp.zone.ZoneRulesException;
import org.threeten.bp.zone.ZoneRulesProvider;

final class LazyZoneRulesProvider
extends ZoneRulesProvider {
    private final Context context;
    private final NavigableMap<String, ZoneRules> map = new ConcurrentSkipListMap<String, ZoneRules>();

    LazyZoneRulesProvider(Context context) {
        this.context = context;
    }

    protected Set<String> provideZoneIds() {
        return new HashSet<String>(LazyZoneRules.REGION_IDS);
    }

    protected ZoneRules provideRules(String zoneId, boolean forCaching) {
        Jdk8Methods.requireNonNull((Object)zoneId, (String)"zoneId");
        ZoneRules rules = (ZoneRules)this.map.get(zoneId);
        if (rules == null) {
            rules = this.loadData(zoneId);
            this.map.put(zoneId, rules);
        }
        return rules;
    }

    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        String versionId = "2018g";
        ZoneRules rules = this.provideRules(zoneId, false);
        return new TreeMap<String, ZoneRules>(Collections.singletonMap(versionId, rules));
    }

    private ZoneRules loadData(String zoneId) {
        String fileName = "tzdb/" + zoneId + ".dat";
        InputStream is = null;
        try {
            is = this.context.getAssets().open(fileName);
            ZoneRules zoneRules = this.loadData(is);
            this.close(is);
            return zoneRules;
        }
        catch (Exception ex) {
            try {
                throw new ZoneRulesException("Invalid binary time-zone data: " + fileName, (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(is);
                throw throwable;
            }
        }
    }

    private ZoneRules loadData(InputStream in) throws Exception {
        DataInputStream dis = new DataInputStream(in);
        if (dis.readByte() != 1) {
            throw new StreamCorruptedException("File format not recognised");
        }
        String groupId = dis.readUTF();
        if (!"TZDB-ZONE".equals(groupId)) {
            throw new StreamCorruptedException("File format not recognised");
        }
        return ZoneRulesCompat.readZoneRules(dis);
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

