/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.support;

import com.galenframework.api.Galen;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestReport;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.support.LayoutValidationException;
import com.galenframework.utils.GalenUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;

public abstract class GalenJavaTestBase {
    protected ThreadLocal<WebDriver> driver = new ThreadLocal();
    protected ThreadLocal<TestReport> report = new ThreadLocal();
    protected ThreadLocal<GalenTestInfo> testInfo = new ThreadLocal();

    public TestReport getReport() {
        TestReport report = this.report.get();
        if (report == null) {
            throw new RuntimeException("The report is not instantiated yet");
        }
        return report;
    }

    public GalenTestInfo createTestInfo(Method method, Object[] arguments) {
        return GalenTestInfo.fromMethod((Method)method, (Object[])arguments);
    }

    public void load(String url) {
        this.getDriver().get(url);
    }

    public void load(String url, int width, int height) {
        this.load(url);
        this.resize(width, height);
    }

    public void inject(String javaScript) {
        GalenUtils.injectJavascript((WebDriver)this.getDriver(), (String)javaScript);
    }

    public void resize(int width, int height) {
        this.getDriver().manage().window().setSize(new Dimension(width, height));
    }

    public void checkLayout(String specPath, List<String> includedTags) throws IOException {
        this.checkLayout(specPath, new SectionFilter(includedTags, Collections.emptyList()), new Properties(), null);
    }

    public void checkLayout(String specPath, SectionFilter sectionFilter, Properties properties, Map<String, Object> vars) throws IOException {
        String title = "Check layout " + specPath;
        LayoutReport layoutReport = Galen.checkLayout((WebDriver)this.getDriver(), (String)specPath, (SectionFilter)sectionFilter, (Properties)properties, vars);
        this.getReport().layout(layoutReport, title);
        if (layoutReport.errors() > 0) {
            throw new LayoutValidationException(specPath, layoutReport, sectionFilter);
        }
    }

    public void initDriver(Object[] args) {
        WebDriver driver = this.createDriver(args);
        this.driver.set(driver);
    }

    public abstract WebDriver createDriver(Object[] var1);

    public void quitDriver() {
        this.getDriver().quit();
    }

    public WebDriver getDriver() {
        WebDriver driver = this.driver.get();
        if (driver == null) {
            throw new RuntimeException("The driver is not instantiated yet");
        }
        return driver;
    }
}

