/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j;

import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class ImageHandler {
    private byte[] bytes;
    private int width;
    private int height;
    private static final int BLOCK_SIZE = 3;

    public ImageHandler(BufferedImage image) {
        this.bytes = ImageHandler.readRgbModelFrom(image);
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ImageHandler(int width, int height) {
        this.width = width;
        this.height = height;
        this.bytes = new byte[width * height * 3];
    }

    public ImageHandler(byte[] bytes, int w, int h) {
        this.bytes = bytes;
        this.width = w;
        this.height = h;
    }

    private static byte[] readRgbModelFrom(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] pixels = new int[w * h];
        image.getRGB(0, 0, w, h, pixels, 0, w);
        byte[] rgbBytes = new byte[w * h * 3];
        for (int r = 0; r < h; ++r) {
            for (int c = 0; c < w; ++c) {
                int index = r * w + c;
                int indexRgb = r * w * 3 + c * 3;
                rgbBytes[indexRgb] = (byte)(pixels[index] >> 16 & 0xFF);
                rgbBytes[indexRgb + 1] = (byte)(pixels[index] >> 8 & 0xFF);
                rgbBytes[indexRgb + 2] = (byte)(pixels[index] & 0xFF);
            }
        }
        return rgbBytes;
    }

    public Color getSmoothedColor(int x, int y, int x2, int y2) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.width || y >= this.height) {
            throw new RuntimeException("pixel is out of range");
        }
        if (x2 >= this.width) {
            x2 = this.width - 1;
        }
        if (y2 >= this.height) {
            y2 = this.height - 1;
        }
        long r = 0L;
        long g = 0L;
        long b = 0L;
        long t = 0L;
        for (int i = x; i <= x2; ++i) {
            for (int j = y; j <= y2; ++j) {
                ++t;
                Color c = this.pickColor(i, j);
                r += (long)c.getRed();
                g += (long)c.getGreen();
                b += (long)c.getBlue();
            }
        }
        if (t > 0L) {
            return new Color((int)(r / t), (int)(g / t), (int)(b / t));
        }
        return new Color(0, 0, 0);
    }

    public Color pickColor(int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            int k = y * this.width * 3 + x * 3;
            return new Color(this.bytes[k] & 0xFF, this.bytes[k + 1] & 0xFF, this.bytes[k + 2] & 0xFF);
        }
        return new Color(0, 0, 0);
    }

    public static long colorDiff(Color cA, Color cB) {
        return Math.abs(cA.getRed() - cB.getRed()) + Math.abs(cA.getGreen() - cB.getGreen()) + Math.abs(cB.getBlue() - cB.getBlue());
    }

    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                int index = r * this.width * 3 + c * 3;
                int red = this.bytes[index] & 0xFF;
                int green = this.bytes[index + 1] & 0xFF;
                int blue = this.bytes[index + 2] & 0xFF;
                int rgb = red << 16 | green << 8 | blue;
                image.setRGB(c, r, rgb);
            }
        }
        return image;
    }

    public void applyFilter(ImageFilter filter, Rectangle area) {
        filter.apply(this.bytes, this.width, this.height, area);
    }

    public void setRGB(int x, int y, int r, int g, int b) {
        int k = y * this.width * 3 + x * 3;
        this.bytes[k] = (byte)(r & 0xFF);
        this.bytes[k + 1] = (byte)(g & 0xFF);
        this.bytes[k + 2] = (byte)(b & 0xFF);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void applyFilter(ImageFilter filter) {
        this.applyFilter(filter, new Rectangle(0, 0, this.width, this.height));
    }
}

