/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j;

import com.galenframework.rainbow4j.ColorDistribution;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

public class Spectrum {
    private final int[][][] data;
    private int pixelsAmount;
    private int precision;

    public Spectrum(int[][][] data, int width, int height) {
        this.precision = data.length;
        this.data = data;
        this.pixelsAmount = width * height;
    }

    public float getPercentage(int red, int green, int blue, int range) {
        long counter = 0L;
        int cr = Math.min(red * this.precision / 256, this.precision - 1);
        int cg = Math.min(green * this.precision / 256, this.precision - 1);
        int cb = Math.min(blue * this.precision / 256, this.precision - 1);
        int crange = Math.min(range * this.precision / 256, this.precision - 1);
        int[] rRange = new int[]{Math.max(0, cr - crange), Math.min(cr + crange, this.precision - 1)};
        int[] gRange = new int[]{Math.max(0, cg - crange), Math.min(cg + crange, this.precision - 1)};
        int[] bRange = new int[]{Math.max(0, cb - crange), Math.min(cb + crange, this.precision - 1)};
        for (int ir = rRange[0]; ir <= rRange[1]; ++ir) {
            for (int ig = gRange[0]; ig <= gRange[1]; ++ig) {
                for (int ib = bRange[0]; ib <= bRange[1]; ++ib) {
                    counter += (long)this.data[ir][ig][ib];
                }
            }
        }
        return 100.0f * (float)counter / (float)this.pixelsAmount;
    }

    public void printColors() {
        for (int r = 0; r < this.precision; ++r) {
            for (int g = 0; g < this.precision; ++g) {
                for (int b = 0; b < this.precision; ++b) {
                    if (this.data[r][g][b] <= 0) continue;
                    System.out.println(String.format("(%d, %d, %d) = %d", r, g, b, this.data[r][g][b]));
                }
            }
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public List<ColorDistribution> getColorDistribution(int minPercentage) {
        double usage = 0.0;
        LinkedList<ColorDistribution> colors = new LinkedList<ColorDistribution>();
        for (int r = 0; r < this.precision; ++r) {
            for (int g = 0; g < this.precision; ++g) {
                for (int b = 0; b < this.precision; ++b) {
                    usage = this.data[r][g][b] * 100 / this.pixelsAmount;
                    if (!(usage >= (double)minPercentage)) continue;
                    colors.add(new ColorDistribution(new Color(r, g, b), usage));
                }
            }
        }
        return colors;
    }
}

