/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Rectangle;

public class DenoiseFilter
implements ImageFilter {
    private static final int BLOCK_SIZE = 3;
    private int radius;

    public DenoiseFilter(int radius) {
        this.radius = radius;
    }

    @Override
    public void apply(byte[] bytes, int width, int height, Rectangle area) {
        this.radius = Math.min(this.radius, Math.min(width / 2, height / 2));
        if (this.radius > 1) {
            for (int yc = 0; yc < height; ++yc) {
                for (int xc = 0; xc < width; ++xc) {
                    int blackPixels = 0;
                    int whitePixels = 0;
                    int startY = Math.max(yc - this.radius, 0);
                    int startX = Math.max(xc - this.radius, 0);
                    int endY = Math.min(yc + this.radius, height);
                    int endX = Math.min(xc + this.radius, width);
                    for (int y = startY; y < endY; ++y) {
                        for (int x = startX; x < endX; ++x) {
                            int k = y * width * 3 + x * 3;
                            int r = bytes[k] & 0xFF;
                            int g = bytes[k + 1] & 0xFF;
                            int b = bytes[k + 2] & 0xFF;
                            if (r < 10 && g < 10 && b < 10) {
                                ++blackPixels;
                                continue;
                            }
                            ++whitePixels;
                        }
                    }
                    int k = yc * width * 3 + xc * 3;
                    if (whitePixels <= 0 || blackPixels / whitePixels <= 3) continue;
                    bytes[k] = 0;
                    bytes[k + 1] = 0;
                    bytes[k + 2] = 0;
                }
            }
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

