/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.BpStatus;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.HrType;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class BloodPressureMesg
extends Mesg {
    public static final int TimestampFieldNum = 253;
    public static final int SystolicPressureFieldNum = 0;
    public static final int DiastolicPressureFieldNum = 1;
    public static final int MeanArterialPressureFieldNum = 2;
    public static final int Map3SampleMeanFieldNum = 3;
    public static final int MapMorningValuesFieldNum = 4;
    public static final int MapEveningValuesFieldNum = 5;
    public static final int HeartRateFieldNum = 6;
    public static final int HeartRateTypeFieldNum = 7;
    public static final int StatusFieldNum = 8;
    public static final int UserProfileIndexFieldNum = 9;
    protected static final Mesg bloodPressureMesg = new Mesg("blood_pressure", 51);

    public BloodPressureMesg() {
        super(Factory.createMesg(51));
    }

    public BloodPressureMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    public Integer getSystolicPressure() {
        return this.getFieldIntegerValue(0, 0, 65535);
    }

    public void setSystolicPressure(Integer systolicPressure) {
        this.setFieldValue(0, 0, (Object)systolicPressure, 65535);
    }

    public Integer getDiastolicPressure() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public void setDiastolicPressure(Integer diastolicPressure) {
        this.setFieldValue(1, 0, (Object)diastolicPressure, 65535);
    }

    public Integer getMeanArterialPressure() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public void setMeanArterialPressure(Integer meanArterialPressure) {
        this.setFieldValue(2, 0, (Object)meanArterialPressure, 65535);
    }

    public Integer getMap3SampleMean() {
        return this.getFieldIntegerValue(3, 0, 65535);
    }

    public void setMap3SampleMean(Integer map3SampleMean) {
        this.setFieldValue(3, 0, (Object)map3SampleMean, 65535);
    }

    public Integer getMapMorningValues() {
        return this.getFieldIntegerValue(4, 0, 65535);
    }

    public void setMapMorningValues(Integer mapMorningValues) {
        this.setFieldValue(4, 0, (Object)mapMorningValues, 65535);
    }

    public Integer getMapEveningValues() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public void setMapEveningValues(Integer mapEveningValues) {
        this.setFieldValue(5, 0, (Object)mapEveningValues, 65535);
    }

    public Short getHeartRate() {
        return this.getFieldShortValue(6, 0, 65535);
    }

    public void setHeartRate(Short heartRate) {
        this.setFieldValue(6, 0, (Object)heartRate, 65535);
    }

    public HrType getHeartRateType() {
        Short value = this.getFieldShortValue(7, 0, 65535);
        if (value == null) {
            return null;
        }
        return HrType.getByValue(value);
    }

    public void setHeartRateType(HrType heartRateType) {
        this.setFieldValue(7, 0, (Object)heartRateType.value, 65535);
    }

    public BpStatus getStatus() {
        Short value = this.getFieldShortValue(8, 0, 65535);
        if (value == null) {
            return null;
        }
        return BpStatus.getByValue(value);
    }

    public void setStatus(BpStatus status) {
        this.setFieldValue(8, 0, (Object)status.value, 65535);
    }

    public Integer getUserProfileIndex() {
        return this.getFieldIntegerValue(9, 0, 65535);
    }

    public void setUserProfileIndex(Integer userProfileIndex) {
        this.setFieldValue(9, 0, (Object)userProfileIndex, 65535);
    }

    static {
        bloodPressureMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        bloodPressureMesg.addField(new Field("systolic_pressure", 0, 132, 1.0, 0.0, "mmHg", false, Profile.Type.UINT16));
        bloodPressureMesg.addField(new Field("diastolic_pressure", 1, 132, 1.0, 0.0, "mmHg", false, Profile.Type.UINT16));
        bloodPressureMesg.addField(new Field("mean_arterial_pressure", 2, 132, 1.0, 0.0, "mmHg", false, Profile.Type.UINT16));
        bloodPressureMesg.addField(new Field("map_3_sample_mean", 3, 132, 1.0, 0.0, "mmHg", false, Profile.Type.UINT16));
        bloodPressureMesg.addField(new Field("map_morning_values", 4, 132, 1.0, 0.0, "mmHg", false, Profile.Type.UINT16));
        bloodPressureMesg.addField(new Field("map_evening_values", 5, 132, 1.0, 0.0, "mmHg", false, Profile.Type.UINT16));
        bloodPressureMesg.addField(new Field("heart_rate", 6, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        bloodPressureMesg.addField(new Field("heart_rate_type", 7, 0, 1.0, 0.0, "", false, Profile.Type.HR_TYPE));
        bloodPressureMesg.addField(new Field("status", 8, 0, 1.0, 0.0, "", false, Profile.Type.BP_STATUS));
        bloodPressureMesg.addField(new Field("user_profile_index", 9, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
    }
}

