/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.ProtocolValidator;
import com.garmin.fit.ProtocolValidatorFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.List;

public class BufferEncoder
implements MesgListener,
MesgDefinitionListener {
    private ByteArrayOutputStream byteOutStream;
    private DataOutputStream dataOutStream;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];
    private ProtocolValidator validator;
    private Fit.ProtocolVersion version;

    @Deprecated
    public BufferEncoder() {
        this(Fit.ProtocolVersion.V1_0);
    }

    public BufferEncoder(Fit.ProtocolVersion version) {
        this.version = version;
        this.validator = ProtocolValidatorFactory.getProtocolValidator(version);
        this.byteOutStream = new ByteArrayOutputStream();
        this.dataOutStream = new DataOutputStream(this.byteOutStream);
        this.open();
    }

    public void open() {
        this.byteOutStream.reset();
        this.writeFileHeader();
    }

    private void writeFileHeader() {
        this.byteOutStream.write(14);
        this.byteOutStream.write(this.version.getVersion());
        this.byteOutStream.write(149);
        this.byteOutStream.write(82);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(46);
        this.byteOutStream.write(70);
        this.byteOutStream.write(73);
        this.byteOutStream.write(84);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void write(MesgDefinition mesgDefinition) {
        if (!this.validator.validateMesgDefn(mesgDefinition)) {
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        mesgDefinition.write(this.dataOutStream);
        this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
    }

    public void write(Mesg mesg) {
        if (!this.validator.validateMesg(mesg)) {
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports(mesg)) {
            this.write(new MesgDefinition(mesg));
        }
        mesg.write(this.dataOutStream, this.lastMesgDefinition[mesg.localNum]);
    }

    public void write(List<? extends Mesg> mesgs) {
        for (Mesg mesg : mesgs) {
            this.write(mesg);
        }
    }

    public byte[] close() {
        int i;
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        byte[] buffer = this.byteOutStream.toByteArray();
        long dataSize = buffer.length - 14 - 2;
        buffer[4] = (byte)(dataSize & 0xFFL);
        buffer[5] = (byte)(dataSize >> 8 & 0xFFL);
        buffer[6] = (byte)(dataSize >> 16 & 0xFFL);
        buffer[7] = (byte)(dataSize >> 24 & 0xFFL);
        int crc = 0;
        for (i = 0; i < 12; ++i) {
            crc = CRC.get16(crc, buffer[i]);
        }
        buffer[12] = (byte)(crc & 0xFF);
        buffer[13] = (byte)(crc >> 8 & 0xFF);
        crc = 0;
        for (i = 0; i < buffer.length - 2; ++i) {
            crc = CRC.get16(crc, buffer[i]);
        }
        buffer[buffer.length - 2] = (byte)(crc & 0xFF);
        buffer[buffer.length - 1] = (byte)(crc >> 8 & 0xFF);
        this.open();
        return buffer;
    }
}

