/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import java.util.zip.Checksum;

public class CRC16
implements Checksum {
    private static final int[] crc16_table = new int[]{0, 52225, 55297, 5120, 61441, 15360, 10240, 58369, 40961, 27648, 30720, 46081, 20480, 39937, 34817, 17408};
    private int crc;

    public CRC16() {
        this.reset();
    }

    @Override
    public long getValue() {
        return this.crc;
    }

    @Override
    public void reset() {
        this.crc = 0;
    }

    @Override
    public void update(int b) {
        int tmp = crc16_table[this.crc & 0xF];
        this.crc = this.crc >> 4 & 0xFFF;
        this.crc = this.crc ^ tmp ^ crc16_table[b & 0xF];
        tmp = crc16_table[this.crc & 0xF];
        this.crc = this.crc >> 4 & 0xFFF;
        this.crc = this.crc ^ tmp ^ crc16_table[b >> 4 & 0xF];
    }

    @Override
    public void update(byte[] bytes, int off, int len) {
        while (off < len) {
            this.update(bytes[off]);
            ++off;
        }
    }
}

