/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Fit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateTime
implements Comparable<DateTime> {
    public static final long MIN = 0x10000000L;
    public static final long INVALID = Fit.UINT32_INVALID;
    private static final Map<Long, String> stringMap = new HashMap<Long, String>();
    public static final long OFFSET = 631065600000L;
    private long timestamp;
    private double fractional_timestamp;

    public static String getStringFromValue(Long value) {
        if (stringMap.containsKey(value)) {
            return stringMap.get(value);
        }
        return "";
    }

    public static Long getValueFromString(String value) {
        for (Map.Entry<Long, String> entry : stringMap.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return INVALID;
    }

    public DateTime(long timestamp) {
        this.timestamp = timestamp;
        this.fractional_timestamp = 0.0;
    }

    public DateTime(Date date) {
        this.timestamp = (date.getTime() - 631065600000L) / 1000L;
        this.fractional_timestamp = (double)((date.getTime() - 631065600000L) % 1000L) / 1000.0;
    }

    public DateTime(DateTime timestamp) {
        this(timestamp.getTimestamp(), timestamp.getFractionalTimestamp());
    }

    public DateTime(long timestamp, double fractional_timestamp) {
        this.timestamp = timestamp + (long)Math.floor(fractional_timestamp);
        this.fractional_timestamp = fractional_timestamp - Math.floor(fractional_timestamp);
    }

    public boolean equals(DateTime dateTime) {
        return this.getTimestamp().equals(dateTime.getTimestamp()) && this.getFractionalTimestamp().equals(dateTime.getFractionalTimestamp());
    }

    public void convertSystemTimeToUTC(long offset) {
        if (this.timestamp < 0x10000000L) {
            this.timestamp += offset;
        }
    }

    public Double getFractionalTimestamp() {
        return new Double(this.fractional_timestamp);
    }

    public Long getTimestamp() {
        return new Long(this.timestamp);
    }

    public Date getDate() {
        long fractional_ms = Math.round(this.fractional_timestamp * 1000.0);
        return new Date(this.timestamp * 1000L + fractional_ms + 631065600000L);
    }

    public String toString() {
        return this.getDate().toString();
    }

    public void add(DateTime dateTime) {
        this.timestamp += dateTime.getTimestamp().longValue();
        this.fractional_timestamp += dateTime.getFractionalTimestamp().doubleValue();
        this.timestamp += (long)Math.floor(this.fractional_timestamp);
        this.fractional_timestamp -= (double)((float)Math.floor(this.fractional_timestamp));
    }

    public void add(long timestamp) {
        this.add(new DateTime(timestamp));
    }

    public void add(double fractional_timestamp) {
        this.add(new DateTime(0L, fractional_timestamp));
    }

    @Override
    public int compareTo(DateTime t1) {
        if (this.timestamp == t1.getTimestamp()) {
            return Double.compare(this.fractional_timestamp, t1.getFractionalTimestamp());
        }
        if (this.timestamp > t1.getTimestamp()) {
            return 1;
        }
        return -1;
    }

    public boolean after(DateTime t1) {
        return this.compareTo(t1) > 0;
    }

    public boolean before(DateTime t1) {
        return this.compareTo(t1) < 0;
    }

    static {
        stringMap.put(0x10000000L, "MIN");
    }
}

