/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.DeveloperFieldDescription;
import com.garmin.fit.DeveloperFieldDescriptionListener;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgSource;
import com.garmin.fit.Profile;
import com.garmin.fit.SubField;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class Decode
implements MesgSource {
    private static final long DECODE_DATA_RECORDS_ONLY = Long.MAX_VALUE;
    private static final int FIT_PROTOCOL_VERSION_ONE = 1;
    private static final int FIT_HEADER_SIZE_WITH_CRC = 14;
    private static final int FIT_HEADER_SIZE_NO_CRC = 12;
    private static boolean invalidDataSize = false;
    private boolean hasDevData;
    private static final int BUFFER_SIZE = 512;
    private STATE state;
    private byte fileHdrOffset;
    private byte fileHdrSize;
    private long fileDataSize;
    private long fileBytesLeft;
    private int crc;
    private Mesg mesg;
    private int localMesgIndex;
    private MesgDefinition[] localMesgDefs = new MesgDefinition[16];
    private HashMap<Short, DeveloperDataIdMesg> developerDataIds = new HashMap();
    private HashMap<Short, HashMap<Short, FieldDescriptionMesg>> developerFields = new HashMap();
    private int decoderMesgIndex = 0;
    private int numFields;
    private int fieldIndex;
    private int fieldDataIndex;
    private int fieldBytesLeft;
    private byte[] fieldData = new byte[255];
    private int lastTimeOffset;
    private long timestamp;
    private long systemTimeOffset = 0L;
    private Accumulator accumulator = new Accumulator();
    private boolean pause;
    private InputStream in;
    private boolean instreamIsComplete = true;
    private boolean invalidFileDataSize = false;
    private String headerException;
    private int currentByteOffset = 0;
    private ArrayList<MesgListener> mesgListeners = new ArrayList();
    private ArrayList<MesgDefinitionListener> mesgDefListeners = new ArrayList();
    private ArrayList<DeveloperFieldDescriptionListener> devFieldDescListeners = new ArrayList();
    private int bytesRead;
    private int currentByteIndex;
    private byte[] buffer;

    public Decode() {
        this.nextFile();
        this.bytesRead = 0;
        this.currentByteIndex = 0;
        this.buffer = new byte[512];
        if (Fit.debug) {
            System.out.printf("Fit.Decode: Starting decode...\n", new Object[0]);
        }
    }

    public boolean getInvalidFileDataSize() {
        return this.invalidFileDataSize;
    }

    public void setInvalidFileDataSize(boolean value) {
        this.invalidFileDataSize = value;
    }

    public void nextFile() {
        if (this.instreamIsComplete) {
            this.fileBytesLeft = 3L;
            this.fileHdrOffset = 0;
            this.crc = 0;
            this.state = STATE.FILE_HDR;
            this.lastTimeOffset = 0;
            this.pause = false;
            invalidDataSize = false;
            this.invalidFileDataSize = false;
            this.headerException = null;
        }
    }

    @Override
    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void addListener(DeveloperFieldDescriptionListener listener) {
        if (listener != null && !this.devFieldDescListeners.contains(listener)) {
            this.devFieldDescListeners.add(listener);
        }
    }

    public void setSystemTimeOffset(long systemTimeOffset) {
        this.systemTimeOffset = systemTimeOffset;
    }

    public void skipHeader() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set skipHeader option after Decode started!");
        }
        this.state = STATE.RECORD;
        this.fileBytesLeft = Long.MAX_VALUE;
    }

    public void incompleteStream() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set incompleteStream option after Decode started!");
        }
        this.instreamIsComplete = false;
    }

    public void showInvalidValues() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set showInvalidValues option after Decode started!");
        }
        FieldBase.forceShowInvalids = true;
    }

    public boolean read(InputStream in, MesgListener mesgListener, MesgDefinitionListener mesgDefListener) {
        boolean status = true;
        this.addListener(mesgListener);
        this.addListener(mesgDefListener);
        this.currentByteOffset = 0;
        try {
            while (this.bytesAvailable(in) && status) {
                status = this.read(in);
                this.nextFile();
            }
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
        return status;
    }

    public boolean read(InputStream in, MesgListener mesgListener) {
        this.addListener(mesgListener);
        return this.read(in);
    }

    public boolean read(InputStream in) {
        this.in = in;
        return this.resume();
    }

    public void pause() {
        this.pause = true;
    }

    public boolean resume() {
        this.pause = false;
        RETURN decodeReturn = RETURN.CONTINUE;
        try {
            do {
                if (this.pause) {
                    return false;
                }
                while (this.currentByteIndex < this.bytesRead) {
                    decodeReturn = this.read(this.buffer[this.currentByteIndex]);
                    switch (decodeReturn) {
                        case CONTINUE: {
                            break;
                        }
                        case MESG: {
                            switch (this.mesg.num) {
                                case 207: {
                                    DeveloperDataIdMesg devIdMesg = new DeveloperDataIdMesg(this.mesg);
                                    short index = devIdMesg.getDeveloperDataIndex();
                                    this.developerDataIds.put(index, devIdMesg);
                                    this.developerFields.put(index, new HashMap());
                                    break;
                                }
                                case 206: {
                                    FieldDescriptionMesg fieldDescriptionMesg = new FieldDescriptionMesg(this.mesg);
                                    short index = fieldDescriptionMesg.getDeveloperDataIndex();
                                    if (!this.developerFields.containsKey(index)) break;
                                    this.developerFields.get(index).put(fieldDescriptionMesg.getFieldDefinitionNumber(), fieldDescriptionMesg);
                                    DeveloperFieldDescription description = new DeveloperFieldDescription(this.developerDataIds.get(index), fieldDescriptionMesg);
                                    for (DeveloperFieldDescriptionListener listener : this.devFieldDescListeners) {
                                        listener.onDescription(description);
                                    }
                                    break;
                                }
                            }
                            for (MesgListener mesgListener : this.mesgListeners) {
                                mesgListener.onMesg(this.mesg);
                            }
                            break;
                        }
                        case MESG_DEF: {
                            for (MesgDefinitionListener mesgDefListener : this.mesgDefListeners) {
                                mesgDefListener.onMesgDefinition(this.localMesgDefs[this.localMesgIndex]);
                            }
                            break;
                        }
                        case END_OF_FILE: {
                            ++this.currentByteIndex;
                            ++this.currentByteOffset;
                            return true;
                        }
                        default: {
                            ++this.currentByteOffset;
                            throw new FitRuntimeException("FIT decode error: " + (Object)((Object)decodeReturn) + " at byte: " + this.currentByteOffset);
                        }
                    }
                    ++this.currentByteOffset;
                    ++this.currentByteIndex;
                }
                this.currentByteIndex = 0;
            } while ((this.bytesRead = this.in.read(this.buffer, 0, this.buffer.length)) >= 0);
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
        if (this.instreamIsComplete && this.fileBytesLeft != Long.MAX_VALUE) {
            throw new FitRuntimeException("FIT decode error: Unexpected end of input stream at byte: " + this.currentByteOffset);
        }
        if (!this.instreamIsComplete) {
            return decodeReturn == RETURN.MESG || decodeReturn == RETURN.MESG_DEF;
        }
        if (decodeReturn == RETURN.MESG || decodeReturn == RETURN.MESG_DEF) {
            return true;
        }
        if (!invalidDataSize || !this.invalidFileDataSize) {
            throw new FitRuntimeException("FIT decode error: Unexpected end of input stream at byte: " + this.currentByteOffset);
        }
        return true;
    }

    public boolean isFileFit(InputStream in) {
        try {
            while (true) {
                if (this.currentByteIndex < this.bytesRead) {
                    switch (this.read(this.buffer[this.currentByteIndex])) {
                        case CONTINUE: 
                        case MESG: 
                        case MESG_DEF: {
                            break;
                        }
                        case END_OF_FILE: {
                            return true;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (this.state != STATE.FILE_HDR) {
                        return true;
                    }
                    ++this.currentByteIndex;
                    continue;
                }
                this.currentByteIndex = 0;
                this.bytesRead = in.read(this.buffer, 0, this.buffer.length);
                if (this.bytesRead < 0) break;
            }
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
        catch (FitRuntimeException e) {
            this.bytesRead = 0;
            this.currentByteIndex = 0;
        }
        return false;
    }

    public boolean checkFileIntegrity(InputStream in) {
        boolean status = true;
        try {
            while (true) {
                if (this.currentByteIndex < this.bytesRead) {
                    switch (this.read(this.buffer[this.currentByteIndex])) {
                        case CONTINUE: 
                        case MESG: 
                        case MESG_DEF: {
                            break;
                        }
                        case END_OF_FILE: {
                            this.nextFile();
                            break;
                        }
                        default: {
                            status = false;
                        }
                    }
                    ++this.currentByteIndex;
                    continue;
                }
                this.currentByteIndex = 0;
                this.bytesRead = in.read(this.buffer, 0, this.buffer.length);
                if (this.bytesRead < 0) break;
            }
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
        catch (FitRuntimeException e) {
            status = false;
            if (this.getInvalidFileDataSize()) {
                this.nextFile();
            }
            this.bytesRead = 0;
            this.currentByteIndex = 0;
        }
        return status;
    }

    public RETURN read(byte data) {
        if (Fit.debug) {
            if (this.fileBytesLeft == 2L) {
                System.out.printf("Fit.Decode: Expecting next 2 bytes to be end of file CRC = 0x%04X\n", this.crc);
            }
            System.out.printf("Fit.Decode: 0x%02X - %s\n", data & 0xFF, this.state.toString());
        }
        if (this.fileBytesLeft > 0L && this.fileBytesLeft != Long.MAX_VALUE) {
            this.crc = CRC.get16(this.crc, data);
            --this.fileBytesLeft;
            if (this.fileBytesLeft == 1L && this.state.ordinal() > STATE.FILE_HDR.ordinal()) {
                if (this.state != STATE.RECORD) {
                    throw new FitRuntimeException("FIT decode error: Decoder not in correct state after last data byte in file.  Check message definitions. Error at byte: " + this.currentByteOffset);
                }
                return RETURN.CONTINUE;
            }
            if (this.fileBytesLeft == 0L && this.state.ordinal() > STATE.FILE_HDR.ordinal()) {
                if (this.crc != 0) {
                    throw new FitRuntimeException("FIT decode error: File CRC failed. Error at byte: " + this.currentByteOffset);
                }
                return RETURN.END_OF_FILE;
            }
        }
        switch (this.state) {
            case FILE_HDR: {
                byte by = this.fileHdrOffset;
                this.fileHdrOffset = (byte)(by + 1);
                switch (by) {
                    case 0: {
                        if (data == 0) {
                            ++this.fileBytesLeft;
                            this.fileHdrOffset = 0;
                            this.headerException = null;
                            this.crc = 0;
                            break;
                        }
                        if (data < 12) {
                            this.headerException = "FIT decode error: Header size is invalid. Error at byte: " + this.currentByteOffset;
                            break;
                        }
                        this.fileHdrSize = data;
                        this.fileBytesLeft = this.fileHdrSize + 2;
                        break;
                    }
                    case 1: {
                        if ((data & 0xF0) <= Fit.PROTOCOL_VERSION_MAJOR << 4) break;
                        this.headerException = "FIT decode error: Protocol version " + ((data & 0xF0) >> 4) + "." + (data & 0xF) + " not supported.  Must be " + Fit.PROTOCOL_VERSION_MAJOR + "." + Fit.PROTOCOL_VERSION_MINOR + " or earlier.";
                        break;
                    }
                    case 4: {
                        this.fileDataSize = data & 0xFF;
                        break;
                    }
                    case 5: {
                        this.fileDataSize |= (long)(data & 0xFF) << 8;
                        break;
                    }
                    case 6: {
                        this.fileDataSize |= (long)(data & 0xFF) << 16;
                        break;
                    }
                    case 7: {
                        this.fileDataSize |= (long)(data & 0xFF) << 24;
                        if (this.fileDataSize != 0L || invalidDataSize && this.invalidFileDataSize) break;
                        invalidDataSize = true;
                        this.invalidFileDataSize = true;
                        this.headerException = "FIT decode error: File Size is 0. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 8: {
                        if (data == 46) break;
                        this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 9: {
                        if (data == 70) break;
                        this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 10: {
                        if (data == 73) break;
                        this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 11: {
                        if (data != 84) {
                            this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        }
                        if (this.headerException == null || this.fileHdrSize != 12) break;
                        throw new FitRuntimeException(this.headerException);
                    }
                    case 12: {
                        break;
                    }
                    case 13: {
                        if (this.headerException == null) break;
                        ++this.currentByteIndex;
                        throw new FitRuntimeException(this.headerException);
                    }
                }
                if (this.fileHdrOffset != this.fileHdrSize || this.fileHdrSize == 0) break;
                this.fileBytesLeft = invalidDataSize && this.invalidFileDataSize ? Long.MAX_VALUE : this.fileDataSize + 2L;
                this.state = STATE.RECORD;
                break;
            }
            case RECORD: {
                this.fieldIndex = 0;
                this.fieldBytesLeft = 0;
                if (this.fileBytesLeft > 1L) {
                    if ((data & 0x80) != 0) {
                        int timeOffset = data & 0x1F;
                        this.localMesgIndex = (data & 0x60) >> 5;
                        if (this.localMesgDefs[this.localMesgIndex] == null) {
                            throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ". Error at byte: " + this.currentByteOffset);
                        }
                        Field timestampField = Factory.createField(this.localMesgDefs[this.localMesgIndex].num, 253);
                        this.timestamp += (long)(timeOffset - this.lastTimeOffset & 0x1F);
                        this.lastTimeOffset = timeOffset;
                        timestampField.setValue(this.timestamp);
                        this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                        this.mesg.localNum = this.localMesgIndex;
                        this.mesg.systemTimeOffset = this.systemTimeOffset;
                        this.mesg.setDecoderMessageIndex(this.decoderMesgIndex++);
                        this.mesg.addField(timestampField);
                        if (this.localMesgDefs[this.localMesgIndex].fields.size() != 0) {
                            this.state = STATE.FIELD_DATA;
                            break;
                        }
                        if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                            this.state = STATE.DEV_FIELD_DATA;
                            break;
                        }
                        return RETURN.MESG;
                    }
                    this.localMesgIndex = data & 0xF;
                    if ((data & 0x40) != 0) {
                        this.localMesgDefs[this.localMesgIndex] = new MesgDefinition();
                        this.localMesgDefs[this.localMesgIndex].localNum = this.localMesgIndex;
                        this.hasDevData = false;
                        if ((data & 0x20) != 0) {
                            this.hasDevData = true;
                        }
                        this.state = STATE.RESERVED1;
                        break;
                    }
                    if (this.localMesgDefs[this.localMesgIndex] == null) {
                        throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ". Error at byte: " + this.currentByteOffset);
                    }
                    this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                    this.mesg.localNum = this.localMesgIndex;
                    this.mesg.systemTimeOffset = this.systemTimeOffset;
                    this.mesg.setDecoderMessageIndex(this.decoderMesgIndex++);
                    if (this.localMesgDefs[this.localMesgIndex].fields.size() != 0) {
                        this.state = STATE.FIELD_DATA;
                        break;
                    }
                    if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                        this.state = STATE.DEV_FIELD_DATA;
                        break;
                    }
                    return RETURN.MESG;
                }
                this.state = STATE.FILE_CRC_HIGH;
                break;
            }
            case RESERVED1: {
                this.state = STATE.ARCH;
                break;
            }
            case ARCH: {
                this.localMesgDefs[this.localMesgIndex].arch = data & 0xFF;
                this.state = STATE.MESG_NUM_0;
                break;
            }
            case MESG_NUM_0: {
                this.localMesgDefs[this.localMesgIndex].num = data & 0xFF;
                this.state = STATE.MESG_NUM_1;
                break;
            }
            case MESG_NUM_1: {
                this.localMesgDefs[this.localMesgIndex].num |= (data & 0xFF) << 8;
                if (this.localMesgDefs[this.localMesgIndex].arch == 1) {
                    this.localMesgDefs[this.localMesgIndex].num = this.localMesgDefs[this.localMesgIndex].num >> 8 | (this.localMesgDefs[this.localMesgIndex].num & 0xFF) << 8;
                } else if (this.localMesgDefs[this.localMesgIndex].arch != 0) {
                    throw new FitRuntimeException("FIT decode error: Endian " + this.localMesgDefs[this.localMesgIndex].arch + " not supported. Error at byte: " + this.currentByteOffset);
                }
                this.state = STATE.NUM_FIELDS;
                break;
            }
            case NUM_FIELDS: {
                this.numFields = data & 0xFF;
                if (this.numFields == 0) {
                    if (this.hasDevData) {
                        this.state = STATE.NUM_DEV_FIELDS;
                        break;
                    }
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case FIELD_NUM: {
                this.localMesgDefs[this.localMesgIndex].fields.add(new FieldDefinition());
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).num = data & 0xFF;
                this.state = STATE.FIELD_SIZE;
                break;
            }
            case FIELD_SIZE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).size = data & 0xFF;
                this.state = STATE.FIELD_TYPE;
                break;
            }
            case FIELD_TYPE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).type = data & 0xFF;
                if (++this.fieldIndex >= this.numFields) {
                    if (this.hasDevData) {
                        this.state = STATE.NUM_DEV_FIELDS;
                        break;
                    }
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case NUM_DEV_FIELDS: {
                this.fieldIndex = 0;
                this.numFields = data & 0xFF;
                if (this.numFields == 0) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.DEV_FIELD_NUM;
                break;
            }
            case DEV_FIELD_NUM: {
                this.localMesgDefs[this.localMesgIndex].developerFields.add(new DeveloperFieldDefinition());
                this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex).setNum((short)(data & 0xFF));
                this.state = STATE.DEV_FIELD_SIZE;
                break;
            }
            case DEV_FIELD_SIZE: {
                this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex).setSize(data & 0xFF);
                this.state = STATE.DEV_FIELD_DEV_ID;
                break;
            }
            case DEV_FIELD_DEV_ID: {
                DeveloperFieldDefinition fieldDefinition = this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex);
                short castedData = data;
                if (this.developerFields.containsKey(castedData)) {
                    fieldDefinition.setDeveloperDataIdMesg(this.developerDataIds.get(castedData));
                    if (this.developerFields.get(castedData).containsKey(fieldDefinition.getNum())) {
                        FieldDescriptionMesg fieldDescription = this.developerFields.get(castedData).get(fieldDefinition.getNum());
                        fieldDefinition.setFieldDescription(fieldDescription);
                    }
                }
                if (++this.fieldIndex >= this.numFields) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.DEV_FIELD_NUM;
                break;
            }
            case FIELD_DATA: {
                int i;
                FieldDefinition fieldDef = this.localMesgDefs[this.localMesgIndex].fields.get(this.fieldIndex);
                while (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = fieldDef.size;
                    if (this.fieldBytesLeft != 0) continue;
                    if (this.fieldIndex + 1 >= this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                    fieldDef = this.localMesgDefs[this.localMesgIndex].fields.get(++this.fieldIndex);
                }
                this.fieldData[this.fieldDataIndex++] = data;
                --this.fieldBytesLeft;
                if (this.fieldBytesLeft != 0) break;
                boolean read = true;
                if ((fieldDef.type & 0x1F) < 17) {
                    Field field;
                    int typeSize = Fit.baseTypeSizes[fieldDef.type & 0x1F];
                    int elements = fieldDef.size / typeSize;
                    if ((fieldDef.type & 0x80) != 0 && (this.localMesgDefs[this.localMesgIndex].arch & 1) != 1) {
                        this.FlipFieldDataByteOrder(typeSize, elements);
                    }
                    if ((field = Factory.createField(this.mesg.num, fieldDef.num)) != null) {
                        Long fieldTimestamp;
                        if (field.getName().equals("unknown")) {
                            field = new Field("unknown", fieldDef.num, fieldDef.type, 1.0, 0.0, "", false, Profile.Type.fromBaseType(fieldDef.type));
                        }
                        if (field.type != fieldDef.type) {
                            int profileSize = Fit.baseTypeSizes[field.type & 0x1F];
                            if (typeSize < profileSize) {
                                field.type = fieldDef.type;
                            } else if (typeSize != profileSize) {
                                read = false;
                            }
                        }
                        if (read) {
                            field.read(new ByteArrayInputStream(this.fieldData), fieldDef.size);
                        }
                        if (fieldDef.num == 253 && (fieldTimestamp = field.getLongValue()) != null) {
                            this.timestamp = fieldTimestamp;
                            this.lastTimeOffset = (int)(this.timestamp & 0x1FL);
                        }
                        if (field.getIsAccumulated()) {
                            for (i = 0; i < field.getNumValues(); ++i) {
                                long value = ((Number)field.getRawValue(i)).longValue();
                                for (Field containingField : this.mesg.fields) {
                                    for (FieldComponent component : containingField.components) {
                                        if (component.fieldNum != field.num || !component.accumulate) continue;
                                        value = (long)(((double)value / field.scale - field.offset + component.offset) * component.scale);
                                    }
                                }
                                this.accumulator.set(this.mesg.num, field.getNum(), value);
                            }
                        }
                        if (field.getNumValues() > 0) {
                            this.mesg.addField(field);
                        }
                    }
                }
                ++this.fieldIndex;
                if (this.fieldIndex < this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                for (i = 0; i < this.mesg.fields.size(); ++i) {
                    int activeSubfield = this.mesg.getActiveSubFieldIndex(this.mesg.fields.get(i).getNum());
                    if (activeSubfield == 65535) {
                        if (this.mesg.fields.get((int)i).components.size() <= 0) continue;
                        this.expandComponents(this.mesg.fields.get(i), this.mesg.fields.get((int)i).components);
                        continue;
                    }
                    if (this.mesg.fields.get((int)i).subFields.get((int)activeSubfield).components.size() <= 0) continue;
                    this.expandComponents(this.mesg.fields.get(i), this.mesg.fields.get((int)i).subFields.get((int)activeSubfield).components);
                }
                if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                    this.fieldIndex = 0;
                    this.fieldBytesLeft = 0;
                    this.state = STATE.DEV_FIELD_DATA;
                    break;
                }
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
            case DEV_FIELD_DATA: {
                MesgDefinition localMesgDef = this.localMesgDefs[this.localMesgIndex];
                DeveloperFieldDefinition fieldDef = localMesgDef.developerFields.get(this.fieldIndex);
                while (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = fieldDef.getSize();
                    if (this.fieldBytesLeft != 0) continue;
                    if (this.fieldIndex + 1 >= this.localMesgDefs[this.localMesgIndex].developerFields.size()) break;
                    this.fieldBytesLeft = this.localMesgDefs[this.localMesgIndex].developerFields.get(++this.fieldIndex).getSize();
                }
                this.fieldData[this.fieldDataIndex++] = data;
                --this.fieldBytesLeft;
                if (this.fieldBytesLeft != 0) break;
                DeveloperField field = new DeveloperField(fieldDef);
                if ((fieldDef.getType() & 0x1F) < 17) {
                    int typeSize = Fit.baseTypeSizes[fieldDef.getType() & 0x1F];
                    int elements = fieldDef.getSize() / typeSize;
                    if ((fieldDef.getType() & 0x80) != 0 && (localMesgDef.arch & 1) != 1) {
                        this.FlipFieldDataByteOrder(typeSize, elements);
                    }
                    field.read(new ByteArrayInputStream(this.fieldData), fieldDef.getSize());
                    if (field.getNumValues() > 0) {
                        this.mesg.addDeveloperField(field);
                    }
                }
                ++this.fieldIndex;
                if (this.fieldIndex < localMesgDef.developerFields.size()) break;
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
        }
        return RETURN.CONTINUE;
    }

    private void FlipFieldDataByteOrder(int typeSize, int elements) {
        for (int element = 0; element < elements; ++element) {
            for (int i = 0; i < typeSize / 2; ++i) {
                byte tmp = this.fieldData[element * typeSize + i];
                this.fieldData[element * typeSize + i] = this.fieldData[element * typeSize + typeSize - i - 1];
                this.fieldData[element * typeSize + typeSize - i - 1] = tmp;
            }
        }
    }

    protected void expandComponents(Field containingField, ArrayList<FieldComponent> componentList) {
        int offset = 0;
        for (int i = 0; i < componentList.size(); ++i) {
            FieldComponent component = componentList.get(i);
            if (component.fieldNum != 255) {
                Double value;
                Field componentField = Factory.createField(this.mesg.num, component.fieldNum);
                int subFieldIndex = this.mesg.getActiveSubFieldIndex(component.fieldNum);
                SubField subField = componentField.getSubField(subFieldIndex);
                componentField.setIsExpanded(true);
                Long bitsValue = containingField.getBitsValue(offset, component.bits, componentField.isSignedInteger());
                if (bitsValue == null) break;
                if (component.accumulate) {
                    bitsValue = this.accumulator.accumulate(this.mesg.num, component.fieldNum, bitsValue, component.bits);
                }
                if (componentField.components.size() == 1) {
                    value = ((double)bitsValue.longValue() / component.scale - component.offset + componentField.components.get((int)0).offset) * componentField.components.get((int)0).scale;
                    if (this.mesg.hasField(componentField.num)) {
                        this.mesg.getField(componentField.num).addRawValue(value);
                    } else {
                        componentField.addRawValue(value);
                        this.mesg.addField(componentField);
                    }
                } else if (componentField.components.size() > 1) {
                    for (int bitsAdded = 0; bitsAdded < component.bits; bitsAdded += Fit.baseTypeSizes[componentField.type & 0x1F]) {
                        long mask = (1L << Fit.baseTypeSizes[componentField.type & 0x1F]) - 1L;
                        if (this.mesg.hasField(componentField.num)) {
                            this.mesg.getField(componentField.num).addValue(bitsValue & mask);
                        } else {
                            componentField.addValue(bitsValue & mask);
                            this.mesg.addField(componentField);
                        }
                        bitsValue = bitsValue >>> Fit.baseTypeSizes[componentField.type & 0x1F];
                    }
                } else {
                    value = subField == null ? Double.valueOf(((double)bitsValue.longValue() / component.scale - component.offset + componentField.offset) * componentField.scale) : Double.valueOf(((double)bitsValue.longValue() / component.scale - component.offset + subField.offset) * subField.scale);
                    if (this.mesg.hasField(componentField.num)) {
                        this.mesg.getField(componentField.num).addRawValue(value);
                    } else {
                        componentField.addRawValue(value);
                        this.mesg.addField(componentField);
                    }
                }
            }
            offset += component.bits;
        }
    }

    public Mesg getMesg() {
        return this.mesg;
    }

    public boolean bytesAvailable(InputStream input) throws IOException {
        boolean bytesAvailable = false;
        if (this.currentByteIndex > 0 && this.currentByteIndex < this.bytesRead) {
            bytesAvailable = true;
        } else if (input.available() > 0) {
            bytesAvailable = true;
        }
        return bytesAvailable;
    }

    private class Accumulator {
        ArrayList<AccumulatedField> accumulatedFields = new ArrayList();

        Accumulator() {
        }

        public void set(int mesgNum, int destFieldNum, long value) {
            int i;
            AccumulatedField accumField = null;
            for (i = 0; i < this.accumulatedFields.size(); ++i) {
                accumField = this.accumulatedFields.get(i);
                if (accumField.mesgNum == mesgNum && accumField.destFieldNum == destFieldNum) break;
            }
            if (i == this.accumulatedFields.size()) {
                accumField = new AccumulatedField(mesgNum, destFieldNum);
                this.accumulatedFields.add(accumField);
            }
            accumField.set(value);
        }

        public long accumulate(int mesgNum, int destFieldNum, long value, int bits) {
            int i;
            AccumulatedField accumField = null;
            for (i = 0; i < this.accumulatedFields.size(); ++i) {
                accumField = this.accumulatedFields.get(i);
                if (accumField.mesgNum == mesgNum && accumField.destFieldNum == destFieldNum) break;
            }
            if (i == this.accumulatedFields.size()) {
                accumField = new AccumulatedField(mesgNum, destFieldNum);
                this.accumulatedFields.add(accumField);
            }
            return accumField.accumulate(value, bits);
        }
    }

    private class AccumulatedField {
        int mesgNum;
        int destFieldNum;
        long lastValue;
        long accumulatedValue;

        AccumulatedField(int mesgNum, int destFieldNum) {
            this.mesgNum = mesgNum;
            this.destFieldNum = destFieldNum;
            this.lastValue = 0L;
            this.accumulatedValue = 0L;
        }

        public long accumulate(long value, int bits) {
            long mask = (1L << bits) - 1L;
            this.accumulatedValue += value - this.lastValue & mask;
            this.lastValue = value;
            return this.accumulatedValue;
        }

        public long set(long value) {
            this.accumulatedValue = value;
            this.lastValue = value;
            return this.accumulatedValue;
        }
    }

    private static enum STATE {
        FILE_HDR,
        RECORD,
        RESERVED1,
        ARCH,
        MESG_NUM_0,
        MESG_NUM_1,
        NUM_FIELDS,
        FIELD_NUM,
        FIELD_SIZE,
        FIELD_TYPE,
        NUM_DEV_FIELDS,
        DEV_FIELD_NUM,
        DEV_FIELD_SIZE,
        DEV_FIELD_DEV_ID,
        FIELD_DATA,
        DEV_FIELD_DATA,
        FILE_CRC_HIGH;

    }

    public static enum RETURN {
        CONTINUE,
        MESG,
        MESG_DEF,
        END_OF_FILE;

    }
}

