/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import java.io.IOException;
import java.io.OutputStream;

public class DeveloperFieldDefinition
extends FieldDefinitionBase {
    private FieldDescriptionMesg fieldDescriptionMesg;
    private DeveloperDataIdMesg developerDataIdMesg;
    private int size;
    private int type;
    private short num;

    public DeveloperFieldDefinition() {
        this.fieldDescriptionMesg = null;
        this.type = 2;
    }

    public DeveloperFieldDefinition(FieldDescriptionMesg mesg, DeveloperDataIdMesg developerDataIdMesg) {
        this.setFieldDescription(mesg);
        this.developerDataIdMesg = developerDataIdMesg;
    }

    public DeveloperFieldDefinition(DeveloperField field) {
        this(field.getFieldDefinition());
        this.size = field.getSize();
    }

    public DeveloperFieldDefinition(DeveloperFieldDefinition other) {
        this.setFieldDescription(other.fieldDescriptionMesg);
        this.developerDataIdMesg = other.developerDataIdMesg;
        this.size = other.getSize();
    }

    public long getAppVersion() {
        Long val = null;
        if (this.isDefined()) {
            val = this.developerDataIdMesg.getApplicationVersion();
        }
        if (null == val) {
            return Fit.UINT32_INVALID;
        }
        return val;
    }

    public Byte[] getAppId() {
        if (this.isDefined()) {
            return this.developerDataIdMesg.getApplicationId();
        }
        return null;
    }

    public short getDeveloperDataIndex() {
        Short val = null;
        if (this.isDefined()) {
            val = this.fieldDescriptionMesg.getDeveloperDataIndex();
        }
        if (null == val) {
            return Fit.UINT8_INVALID;
        }
        return val;
    }

    public boolean isDefined() {
        return this.fieldDescriptionMesg != null && this.developerDataIdMesg != null;
    }

    public String getFieldName() {
        if (this.isDefined()) {
            return this.fieldDescriptionMesg.getFieldName(0);
        }
        return null;
    }

    public short getScale() {
        if (this.isDefined() && this.fieldDescriptionMesg.getScale() != null && !this.fieldDescriptionMesg.getScale().equals(Fit.UINT8_INVALID)) {
            return this.fieldDescriptionMesg.getScale();
        }
        return 1;
    }

    public short getOffset() {
        if (this.isDefined() && this.fieldDescriptionMesg.getOffset() != null && !this.fieldDescriptionMesg.getOffset().equals(Fit.SINT8_INVALID)) {
            return this.fieldDescriptionMesg.getOffset().byteValue();
        }
        return 0;
    }

    public String getUnits() {
        if (this.isDefined()) {
            return this.fieldDescriptionMesg.getUnits(0);
        }
        return null;
    }

    public DeveloperField getDefaultField() {
        return new DeveloperField(this);
    }

    protected void write(OutputStream out) {
        try {
            out.write(this.fieldDescriptionMesg.getFieldDefinitionNumber().shortValue());
            out.write(this.size);
            out.write(this.fieldDescriptionMesg.getDeveloperDataIndex().shortValue());
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
    }

    public short getNum() {
        return this.num;
    }

    public void setNum(short num) {
        this.num = num;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    public int getType() {
        return this.type;
    }

    public short getNativeOverride() {
        Short nativeNum;
        if (this.isDefined() && null != (nativeNum = this.fieldDescriptionMesg.getNativeFieldNum())) {
            return nativeNum;
        }
        return Fit.UINT8_INVALID;
    }

    void setFieldDescription(FieldDescriptionMesg description) {
        this.fieldDescriptionMesg = description;
        this.num = this.fieldDescriptionMesg.getFieldDefinitionNumber();
        this.type = this.fieldDescriptionMesg.getFitBaseTypeId().shortValue();
    }

    void setDeveloperDataIdMesg(DeveloperDataIdMesg developerDataIdMesg) {
        this.developerDataIdMesg = developerDataIdMesg;
    }
}

