/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.FieldDescriptionMesg;
import java.nio.ByteBuffer;
import java.util.UUID;

public class DeveloperFieldDescription {
    private final FieldDescriptionMesg fieldDescription;
    private final DeveloperDataIdMesg developerId;

    DeveloperFieldDescription(DeveloperDataIdMesg developerId, FieldDescriptionMesg fieldDescription) {
        this.developerId = developerId;
        this.fieldDescription = fieldDescription;
    }

    public long getApplicationVersion() {
        Long applicationVer = this.developerId.getApplicationVersion();
        if (applicationVer == null) {
            return 65535L;
        }
        return applicationVer;
    }

    public UUID getApplicationId() {
        Byte[] appId = this.developerId.getApplicationId();
        if (appId == null || appId.length != 16) {
            return null;
        }
        byte[] primitiveId = new byte[appId.length];
        for (int i = 0; i < appId.length; i = (int)((byte)(i + 1))) {
            primitiveId[i] = appId[i] != null ? appId[i] : (byte)-1;
        }
        ByteBuffer bb = ByteBuffer.wrap(primitiveId);
        long high = bb.getLong();
        long low = bb.getLong();
        return new UUID(high, low);
    }

    public short getFieldDefinitionNumber() {
        Short num = this.fieldDescription.getFieldDefinitionNumber();
        if (num == null) {
            return 255;
        }
        return num;
    }
}

