/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.DiveAlert;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FitnessEquipmentState;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.Profile;
import com.garmin.fit.RadarThreatLevelType;
import com.garmin.fit.RiderPositionType;
import com.garmin.fit.SubField;
import com.garmin.fit.TimerTrigger;

public class EventMesg
extends Mesg
implements MesgWithEvent {
    public static final int TimestampFieldNum = 253;
    public static final int EventFieldNum = 0;
    public static final int EventTypeFieldNum = 1;
    public static final int Data16FieldNum = 2;
    public static final int DataFieldNum = 3;
    public static final int EventGroupFieldNum = 4;
    public static final int ScoreFieldNum = 7;
    public static final int OpponentScoreFieldNum = 8;
    public static final int FrontGearNumFieldNum = 9;
    public static final int FrontGearFieldNum = 10;
    public static final int RearGearNumFieldNum = 11;
    public static final int RearGearFieldNum = 12;
    public static final int DeviceIndexFieldNum = 13;
    public static final int ActivityTypeFieldNum = 14;
    public static final int StartTimestampFieldNum = 15;
    public static final int RadarThreatLevelMaxFieldNum = 21;
    public static final int RadarThreatCountFieldNum = 22;
    public static final int RadarThreatAvgApproachSpeedFieldNum = 23;
    public static final int RadarThreatMaxApproachSpeedFieldNum = 24;
    protected static final Mesg eventMesg;

    public EventMesg() {
        super(Factory.createMesg(21));
    }

    public EventMesg(Mesg mesg) {
        super(mesg);
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    @Override
    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    @Override
    public Event getEvent() {
        Short value = this.getFieldShortValue(0, 0, 65535);
        if (value == null) {
            return null;
        }
        return Event.getByValue(value);
    }

    @Override
    public void setEvent(Event event) {
        this.setFieldValue(0, 0, (Object)event.value, 65535);
    }

    @Override
    public EventType getEventType() {
        Short value = this.getFieldShortValue(1, 0, 65535);
        if (value == null) {
            return null;
        }
        return EventType.getByValue(value);
    }

    @Override
    public void setEventType(EventType eventType) {
        this.setFieldValue(1, 0, (Object)eventType.value, 65535);
    }

    public Integer getData16() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public void setData16(Integer data16) {
        this.setFieldValue(2, 0, (Object)data16, 65535);
    }

    public Long getData() {
        return this.getFieldLongValue(3, 0, 65535);
    }

    public void setData(Long data) {
        this.setFieldValue(3, 0, (Object)data, 65535);
    }

    public TimerTrigger getTimerTrigger() {
        Short value = this.getFieldShortValue(3, 0, 0);
        if (value == null) {
            return null;
        }
        return TimerTrigger.getByValue(value);
    }

    public void setTimerTrigger(TimerTrigger timerTrigger) {
        this.setFieldValue(3, 0, (Object)timerTrigger.value, 0);
    }

    public Integer getCoursePointIndex() {
        return this.getFieldIntegerValue(3, 0, 1);
    }

    public void setCoursePointIndex(Integer coursePointIndex) {
        this.setFieldValue(3, 0, (Object)coursePointIndex, 1);
    }

    public Float getBatteryLevel() {
        return this.getFieldFloatValue(3, 0, 2);
    }

    public void setBatteryLevel(Float batteryLevel) {
        this.setFieldValue(3, 0, (Object)batteryLevel, 2);
    }

    public Float getVirtualPartnerSpeed() {
        return this.getFieldFloatValue(3, 0, 3);
    }

    public void setVirtualPartnerSpeed(Float virtualPartnerSpeed) {
        this.setFieldValue(3, 0, (Object)virtualPartnerSpeed, 3);
    }

    public Short getHrHighAlert() {
        return this.getFieldShortValue(3, 0, 4);
    }

    public void setHrHighAlert(Short hrHighAlert) {
        this.setFieldValue(3, 0, (Object)hrHighAlert, 4);
    }

    public Short getHrLowAlert() {
        return this.getFieldShortValue(3, 0, 5);
    }

    public void setHrLowAlert(Short hrLowAlert) {
        this.setFieldValue(3, 0, (Object)hrLowAlert, 5);
    }

    public Float getSpeedHighAlert() {
        return this.getFieldFloatValue(3, 0, 6);
    }

    public void setSpeedHighAlert(Float speedHighAlert) {
        this.setFieldValue(3, 0, (Object)speedHighAlert, 6);
    }

    public Float getSpeedLowAlert() {
        return this.getFieldFloatValue(3, 0, 7);
    }

    public void setSpeedLowAlert(Float speedLowAlert) {
        this.setFieldValue(3, 0, (Object)speedLowAlert, 7);
    }

    public Integer getCadHighAlert() {
        return this.getFieldIntegerValue(3, 0, 8);
    }

    public void setCadHighAlert(Integer cadHighAlert) {
        this.setFieldValue(3, 0, (Object)cadHighAlert, 8);
    }

    public Integer getCadLowAlert() {
        return this.getFieldIntegerValue(3, 0, 9);
    }

    public void setCadLowAlert(Integer cadLowAlert) {
        this.setFieldValue(3, 0, (Object)cadLowAlert, 9);
    }

    public Integer getPowerHighAlert() {
        return this.getFieldIntegerValue(3, 0, 10);
    }

    public void setPowerHighAlert(Integer powerHighAlert) {
        this.setFieldValue(3, 0, (Object)powerHighAlert, 10);
    }

    public Integer getPowerLowAlert() {
        return this.getFieldIntegerValue(3, 0, 11);
    }

    public void setPowerLowAlert(Integer powerLowAlert) {
        this.setFieldValue(3, 0, (Object)powerLowAlert, 11);
    }

    public Float getTimeDurationAlert() {
        return this.getFieldFloatValue(3, 0, 12);
    }

    public void setTimeDurationAlert(Float timeDurationAlert) {
        this.setFieldValue(3, 0, (Object)timeDurationAlert, 12);
    }

    public Float getDistanceDurationAlert() {
        return this.getFieldFloatValue(3, 0, 13);
    }

    public void setDistanceDurationAlert(Float distanceDurationAlert) {
        this.setFieldValue(3, 0, (Object)distanceDurationAlert, 13);
    }

    public Long getCalorieDurationAlert() {
        return this.getFieldLongValue(3, 0, 14);
    }

    public void setCalorieDurationAlert(Long calorieDurationAlert) {
        this.setFieldValue(3, 0, (Object)calorieDurationAlert, 14);
    }

    public FitnessEquipmentState getFitnessEquipmentState() {
        Short value = this.getFieldShortValue(3, 0, 15);
        if (value == null) {
            return null;
        }
        return FitnessEquipmentState.getByValue(value);
    }

    public void setFitnessEquipmentState(FitnessEquipmentState fitnessEquipmentState) {
        this.setFieldValue(3, 0, (Object)fitnessEquipmentState.value, 15);
    }

    public Long getSportPoint() {
        return this.getFieldLongValue(3, 0, 16);
    }

    public void setSportPoint(Long sportPoint) {
        this.setFieldValue(3, 0, (Object)sportPoint, 16);
    }

    public Long getGearChangeData() {
        return this.getFieldLongValue(3, 0, 17);
    }

    public void setGearChangeData(Long gearChangeData) {
        this.setFieldValue(3, 0, (Object)gearChangeData, 17);
    }

    public RiderPositionType getRiderPosition() {
        Short value = this.getFieldShortValue(3, 0, 18);
        if (value == null) {
            return null;
        }
        return RiderPositionType.getByValue(value);
    }

    public void setRiderPosition(RiderPositionType riderPosition) {
        this.setFieldValue(3, 0, (Object)riderPosition.value, 18);
    }

    public Integer getCommTimeout() {
        return this.getFieldIntegerValue(3, 0, 19);
    }

    public void setCommTimeout(Integer commTimeout) {
        this.setFieldValue(3, 0, (Object)commTimeout, 19);
    }

    public DiveAlert getDiveAlert() {
        Short value = this.getFieldShortValue(3, 0, 20);
        if (value == null) {
            return null;
        }
        return DiveAlert.getByValue(value);
    }

    public void setDiveAlert(DiveAlert diveAlert) {
        this.setFieldValue(3, 0, (Object)diveAlert.value, 20);
    }

    public Integer getAutoActivityDetectDuration() {
        return this.getFieldIntegerValue(3, 0, 21);
    }

    public void setAutoActivityDetectDuration(Integer autoActivityDetectDuration) {
        this.setFieldValue(3, 0, (Object)autoActivityDetectDuration, 21);
    }

    public Long getRadarThreatAlert() {
        return this.getFieldLongValue(3, 0, 22);
    }

    public void setRadarThreatAlert(Long radarThreatAlert) {
        this.setFieldValue(3, 0, (Object)radarThreatAlert, 22);
    }

    @Override
    public Short getEventGroup() {
        return this.getFieldShortValue(4, 0, 65535);
    }

    @Override
    public void setEventGroup(Short eventGroup) {
        this.setFieldValue(4, 0, (Object)eventGroup, 65535);
    }

    public Integer getScore() {
        return this.getFieldIntegerValue(7, 0, 65535);
    }

    public void setScore(Integer score) {
        this.setFieldValue(7, 0, (Object)score, 65535);
    }

    public Integer getOpponentScore() {
        return this.getFieldIntegerValue(8, 0, 65535);
    }

    public void setOpponentScore(Integer opponentScore) {
        this.setFieldValue(8, 0, (Object)opponentScore, 65535);
    }

    public Short getFrontGearNum() {
        return this.getFieldShortValue(9, 0, 65535);
    }

    public void setFrontGearNum(Short frontGearNum) {
        this.setFieldValue(9, 0, (Object)frontGearNum, 65535);
    }

    public Short getFrontGear() {
        return this.getFieldShortValue(10, 0, 65535);
    }

    public void setFrontGear(Short frontGear) {
        this.setFieldValue(10, 0, (Object)frontGear, 65535);
    }

    public Short getRearGearNum() {
        return this.getFieldShortValue(11, 0, 65535);
    }

    public void setRearGearNum(Short rearGearNum) {
        this.setFieldValue(11, 0, (Object)rearGearNum, 65535);
    }

    public Short getRearGear() {
        return this.getFieldShortValue(12, 0, 65535);
    }

    public void setRearGear(Short rearGear) {
        this.setFieldValue(12, 0, (Object)rearGear, 65535);
    }

    public Short getDeviceIndex() {
        return this.getFieldShortValue(13, 0, 65535);
    }

    public void setDeviceIndex(Short deviceIndex) {
        this.setFieldValue(13, 0, (Object)deviceIndex, 65535);
    }

    public ActivityType getActivityType() {
        Short value = this.getFieldShortValue(14, 0, 65535);
        if (value == null) {
            return null;
        }
        return ActivityType.getByValue(value);
    }

    public void setActivityType(ActivityType activityType) {
        this.setFieldValue(14, 0, (Object)activityType.value, 65535);
    }

    public DateTime getStartTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(15, 0, 65535));
    }

    public void setStartTimestamp(DateTime startTimestamp) {
        this.setFieldValue(15, 0, (Object)startTimestamp.getTimestamp(), 65535);
    }

    public DateTime getAutoActivityDetectStartTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(15, 0, 0));
    }

    public void setAutoActivityDetectStartTimestamp(DateTime autoActivityDetectStartTimestamp) {
        this.setFieldValue(15, 0, (Object)autoActivityDetectStartTimestamp.getTimestamp(), 0);
    }

    public RadarThreatLevelType getRadarThreatLevelMax() {
        Short value = this.getFieldShortValue(21, 0, 65535);
        if (value == null) {
            return null;
        }
        return RadarThreatLevelType.getByValue(value);
    }

    public void setRadarThreatLevelMax(RadarThreatLevelType radarThreatLevelMax) {
        this.setFieldValue(21, 0, (Object)radarThreatLevelMax.value, 65535);
    }

    public Short getRadarThreatCount() {
        return this.getFieldShortValue(22, 0, 65535);
    }

    public void setRadarThreatCount(Short radarThreatCount) {
        this.setFieldValue(22, 0, (Object)radarThreatCount, 65535);
    }

    public Float getRadarThreatAvgApproachSpeed() {
        return this.getFieldFloatValue(23, 0, 65535);
    }

    public void setRadarThreatAvgApproachSpeed(Float radarThreatAvgApproachSpeed) {
        this.setFieldValue(23, 0, (Object)radarThreatAvgApproachSpeed, 65535);
    }

    public Float getRadarThreatMaxApproachSpeed() {
        return this.getFieldFloatValue(24, 0, 65535);
    }

    public void setRadarThreatMaxApproachSpeed(Float radarThreatMaxApproachSpeed) {
        this.setFieldValue(24, 0, (Object)radarThreatMaxApproachSpeed, 65535);
    }

    static {
        int field_index = 0;
        int subfield_index = 0;
        eventMesg = new Mesg("event", 21);
        eventMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        ++field_index;
        eventMesg.addField(new Field("event", 0, 0, 1.0, 0.0, "", false, Profile.Type.EVENT));
        ++field_index;
        eventMesg.addField(new Field("event_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.EVENT_TYPE));
        eventMesg.addField(new Field("data16", 2, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        EventMesg.eventMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(3, false, 16, 1.0, 0.0));
        eventMesg.addField(new Field("data", 3, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        subfield_index = 0;
        EventMesg.eventMesg.fields.get((int)(++field_index)).subFields.add(new SubField("timer_trigger", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(0, 0L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("course_point_index", 132, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 10L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("battery_level", 132, 1000.0, 0.0, "V"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 11L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("virtual_partner_speed", 132, 1000.0, 0.0, "m/s"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 12L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("hr_high_alert", 2, 1.0, 0.0, "bpm"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 13L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("hr_low_alert", 2, 1.0, 0.0, "bpm"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 14L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("speed_high_alert", 134, 1000.0, 0.0, "m/s"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 15L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("speed_low_alert", 134, 1000.0, 0.0, "m/s"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 16L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("cad_high_alert", 132, 1.0, 0.0, "rpm"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 17L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("cad_low_alert", 132, 1.0, 0.0, "rpm"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 18L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("power_high_alert", 132, 1.0, 0.0, "watts"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 19L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("power_low_alert", 132, 1.0, 0.0, "watts"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 20L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("time_duration_alert", 134, 1000.0, 0.0, "s"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 23L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("distance_duration_alert", 134, 100.0, 0.0, "m"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 24L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("calorie_duration_alert", 134, 1.0, 0.0, "calories"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 25L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("fitness_equipment_state", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 27L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("sport_point", 134, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 33L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(7, false, 16, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(8, false, 16, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("gear_change_data", 134, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 42L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(0, 43L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(11, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(12, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(9, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(10, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("rider_position", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 44L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("comm_timeout", 132, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 47L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("dive_alert", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 56L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("auto_activity_detect_duration", 132, 1.0, 0.0, "min"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 54L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.add(new SubField("radar_threat_alert", 134, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 75L);
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(21, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(22, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(23, false, 8, 10.0, 0.0));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addComponent(new FieldComponent(24, false, 8, 10.0, 0.0));
        ++subfield_index;
        ++field_index;
        eventMesg.addField(new Field("event_group", 4, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++field_index;
        eventMesg.addField(new Field("score", 7, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        eventMesg.addField(new Field("opponent_score", 8, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        eventMesg.addField(new Field("front_gear_num", 9, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++field_index;
        eventMesg.addField(new Field("front_gear", 10, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++field_index;
        eventMesg.addField(new Field("rear_gear_num", 11, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++field_index;
        eventMesg.addField(new Field("rear_gear", 12, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++field_index;
        eventMesg.addField(new Field("device_index", 13, 2, 1.0, 0.0, "", false, Profile.Type.DEVICE_INDEX));
        ++field_index;
        eventMesg.addField(new Field("activity_type", 14, 0, 1.0, 0.0, "", false, Profile.Type.ACTIVITY_TYPE));
        eventMesg.addField(new Field("start_timestamp", 15, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        subfield_index = 0;
        EventMesg.eventMesg.fields.get((int)(++field_index)).subFields.add(new SubField("auto_activity_detect_start_timestamp", 134, 1.0, 0.0, "s"));
        EventMesg.eventMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(0, 54L);
        ++subfield_index;
        ++field_index;
        eventMesg.addField(new Field("radar_threat_level_max", 21, 0, 1.0, 0.0, "", false, Profile.Type.RADAR_THREAT_LEVEL_TYPE));
        ++field_index;
        eventMesg.addField(new Field("radar_threat_count", 22, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++field_index;
        eventMesg.addField(new Field("radar_threat_avg_approach_speed", 23, 2, 10.0, 0.0, "m/s", false, Profile.Type.UINT8));
        ++field_index;
        eventMesg.addField(new Field("radar_threat_max_approach_speed", 24, 2, 10.0, 0.0, "m/s", false, Profile.Type.UINT8));
        ++field_index;
    }
}

