/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Profile;
import com.garmin.fit.SubField;
import java.util.ArrayList;

public class Field
extends FieldBase {
    protected String name;
    protected int num;
    protected int type;
    protected double scale;
    protected double offset;
    protected String units;
    protected boolean isAccumulated;
    protected ArrayList<FieldComponent> components;
    protected ArrayList<SubField> subFields;
    private Profile.Type profileType;
    private boolean isExpandedField;

    public Field(Field field) {
        super(field);
        if (field == null) {
            this.name = "unknown";
            this.num = 255;
            this.type = 0;
            this.profileType = Profile.Type.ENUM;
            this.scale = 1.0;
            this.offset = 0.0;
            this.units = "";
            this.isAccumulated = false;
            this.values = new ArrayList();
            this.components = new ArrayList();
            this.subFields = new ArrayList();
            this.isExpandedField = false;
            return;
        }
        this.name = field.name;
        this.num = field.num;
        this.type = field.type;
        this.profileType = field.profileType;
        this.scale = field.scale;
        this.offset = field.offset;
        this.units = field.units;
        this.isAccumulated = field.isAccumulated;
        this.components = field.components;
        this.subFields = field.subFields;
        this.isExpandedField = field.isExpandedField;
    }

    protected Field(String name, int num, int type, double scale, double offset, String units, boolean accumulated, Profile.Type profileType) {
        this.name = name;
        this.num = num;
        this.type = type;
        this.profileType = profileType;
        this.scale = scale;
        this.offset = offset;
        this.units = units;
        this.isAccumulated = accumulated;
        this.components = new ArrayList();
        this.subFields = new ArrayList();
        this.isExpandedField = false;
    }

    public int getNum() {
        return this.num;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public Profile.Type getProfileType() {
        return this.profileType;
    }

    @Override
    protected double getOffset() {
        return this.offset;
    }

    @Override
    protected double getScale() {
        return this.scale;
    }

    @Override
    protected String getFieldName() {
        return this.name;
    }

    public boolean getIsAccumulated() {
        return this.isAccumulated;
    }

    protected void setIsExpanded(boolean newValue) {
        this.isExpandedField = newValue;
    }

    protected boolean getIsExpanded() {
        return this.isExpandedField;
    }

    @Override
    protected SubField getSubField(String subFieldName) {
        for (int i = 0; i < this.subFields.size(); ++i) {
            if (!this.subFields.get((int)i).name.equals(subFieldName)) continue;
            return this.subFields.get(i);
        }
        return null;
    }

    @Override
    protected SubField getSubField(int subFieldIndex) {
        if (subFieldIndex >= 0 && subFieldIndex < this.subFields.size()) {
            return this.subFields.get(subFieldIndex);
        }
        return null;
    }
}

