/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.SubField;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class FieldBase {
    protected ArrayList<Object> values = new ArrayList();
    static boolean forceShowInvalids = false;

    protected FieldBase() {
    }

    public FieldBase(FieldBase other) {
        if (other != null) {
            for (Object value : other.values) {
                this.values.add(value);
            }
        }
    }

    public String getName() {
        return this.getNameInternal(null);
    }

    private String getNameInternal(SubField subField) {
        if (subField == null) {
            return this.getFieldName();
        }
        return subField.name;
    }

    public String getName(int subFieldIndex) {
        return this.getNameInternal(this.getSubField(subFieldIndex));
    }

    public String getName(String subFieldName) {
        return this.getNameInternal(this.getSubField(subFieldName));
    }

    public abstract String getUnits();

    public abstract int getType();

    protected abstract double getOffset();

    protected abstract double getScale();

    protected abstract String getFieldName();

    protected abstract SubField getSubField(String var1);

    protected abstract SubField getSubField(int var1);

    public int getType(int subFieldIndex) {
        return this.getTypeInternal(this.getSubField(subFieldIndex));
    }

    public int getType(String subFieldName) {
        return this.getTypeInternal(this.getSubField(subFieldName));
    }

    private int getTypeInternal(SubField subField) {
        if (subField == null) {
            return this.getType();
        }
        return subField.type;
    }

    public String getUnits(int subFieldIndex) {
        return this.getUnitsInternal(this.getSubField(subFieldIndex));
    }

    public String getUnits(String subFieldName) {
        return this.getUnitsInternal(this.getSubField(subFieldName));
    }

    private String getUnitsInternal(SubField subField) {
        if (subField == null) {
            return this.getUnits();
        }
        return subField.units;
    }

    int getSize() {
        int size = 0;
        switch (this.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: {
                size = this.getNumValues() * Fit.baseTypeSizes[this.getType() & 0x1F];
                break;
            }
            case 7: {
                for (Object value : this.values) {
                    try {
                        size += value.toString().getBytes("UTF-8").length + 1;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                break;
            }
        }
        return size;
    }

    public void addRawValue(Object rawValue) {
        if (rawValue == null) {
            this.values.add(null);
        } else if (rawValue instanceof Double) {
            switch (this.getType()) {
                case 0: 
                case 2: 
                case 10: 
                case 13: 
                case 131: {
                    this.values.add((short)Math.round(((Number)rawValue).doubleValue()));
                    break;
                }
                case 1: {
                    this.values.add((byte)Math.round(((Number)rawValue).doubleValue()));
                    break;
                }
                case 132: 
                case 133: 
                case 139: {
                    this.values.add((int)Math.round(((Number)rawValue).doubleValue()));
                    break;
                }
                case 134: 
                case 140: {
                    this.values.add(Math.round(((Number)rawValue).doubleValue()));
                    break;
                }
                case 136: {
                    this.values.add(rawValue);
                    break;
                }
                case 137: {
                    this.values.add(rawValue);
                    break;
                }
                case 7: {
                    this.values.add(rawValue.toString());
                    break;
                }
            }
        } else if (rawValue instanceof String && rawValue.equals("")) {
            switch (this.getType()) {
                case 0: {
                    this.values.add(Fit.ENUM_INVALID);
                    break;
                }
                case 1: {
                    this.values.add(Fit.SINT8_INVALID);
                    break;
                }
                case 2: {
                    this.values.add(Fit.UINT8_INVALID);
                    break;
                }
                case 10: {
                    this.values.add(Fit.UINT8Z_INVALID);
                    break;
                }
                case 131: {
                    this.values.add(Fit.SINT16_INVALID);
                    break;
                }
                case 132: {
                    this.values.add(Fit.UINT16_INVALID);
                    break;
                }
                case 139: {
                    this.values.add(Fit.UINT16Z_INVALID);
                    break;
                }
                case 133: {
                    this.values.add(Fit.SINT32_INVALID);
                    break;
                }
                case 134: {
                    this.values.add(Fit.UINT32_INVALID);
                    break;
                }
                case 140: {
                    this.values.add(Fit.UINT32Z_INVALID);
                    break;
                }
                case 7: {
                    this.values.add(rawValue);
                    break;
                }
                case 136: {
                    this.values.add(Fit.FLOAT32_INVALID);
                    break;
                }
                case 137: {
                    this.values.add(Fit.FLOAT64_INVALID);
                    break;
                }
                case 13: {
                    this.values.add(Fit.BYTE_INVALID);
                    break;
                }
            }
        } else {
            this.values.add(rawValue);
        }
    }

    public int getNumValues() {
        return this.values.size();
    }

    protected boolean isSignedInteger() {
        return this.isSignedIntegerInternal(null);
    }

    protected boolean isSignedInteger(int subFieldIndex) {
        return this.isSignedIntegerInternal(this.getSubField(subFieldIndex));
    }

    protected boolean isSignedInteger(String subFieldName) {
        return this.isSignedIntegerInternal(this.getSubField(subFieldName));
    }

    public boolean isSignedIntegerInternal(SubField subField) {
        int type = subField == null ? this.getType() : subField.getType();
        switch (type) {
            case 1: 
            case 131: 
            case 133: 
            case 142: {
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.isValid(0);
    }

    public boolean isValid(int index) {
        int type = this.getType(65534);
        if (index >= this.values.size()) {
            return false;
        }
        Object value = this.values.get(index);
        return !(value instanceof Number) || !Fit.baseTypeInvalidMap.get(type).equals(value);
    }

    public Long getBitsValue(int offset, int bits, boolean signed) {
        long signBit;
        long value = 0L;
        int bitsInValue = 0;
        int index = 0;
        while (bitsInValue < bits) {
            Object objData;
            if ((objData = this.getRawValueInternal(index++, null)) == null) {
                return null;
            }
            if (!(objData instanceof Number)) {
                return null;
            }
            Long data = ((Number)objData).longValue();
            data = data >> offset;
            int bitsInData = Fit.baseTypeSizes[this.getType() & 0x1F] * 8 - offset;
            offset -= Fit.baseTypeSizes[this.getType() & 0x1F] * 8;
            if (bitsInData <= 0) continue;
            offset = 0;
            if (bitsInData > bits - bitsInValue) {
                bitsInData = bits - bitsInValue;
            }
            long mask = (1L << bitsInData) - 1L;
            value |= (data & mask) << bitsInValue;
            bitsInValue += bitsInData;
        }
        if (signed && (value & (signBit = 1L << bits - 1)) != 0L) {
            value = -signBit + (value & signBit - 1L);
        }
        return value;
    }

    public Object getRawValue() {
        return this.getRawValueInternal(0, null);
    }

    public Object getRawValue(int fieldArrayIndex) {
        return this.getRawValueInternal(fieldArrayIndex, null);
    }

    public Object getRawValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getRawValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Object getRawValue(int fieldArrayIndex, String subFieldName) {
        return this.getRawValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Object getRawValueInternal(int fieldArrayIndex, SubField subField) {
        if (fieldArrayIndex >= this.values.size()) {
            return null;
        }
        Object value = this.values.get(fieldArrayIndex);
        return value;
    }

    public Object getValue() {
        return this.getValueInternal(0, null);
    }

    public Object getValue(int fieldArrayIndex) {
        return this.getValueInternal(fieldArrayIndex, null);
    }

    public Object getValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Object getValue(int fieldArrayIndex, String subFieldName) {
        return this.getValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Object getValueInternal(int fieldArrayIndex, SubField subField) {
        double offset;
        double scale;
        if (fieldArrayIndex >= this.values.size()) {
            return null;
        }
        if (subField == null) {
            scale = this.getScale();
            offset = this.getOffset();
        } else {
            scale = subField.scale;
            offset = subField.offset;
        }
        int type = this.getTypeInternal(subField);
        Object value = this.values.get(fieldArrayIndex);
        if (value instanceof Number) {
            if (Fit.baseTypeInvalidMap.get(type).equals(value)) {
                return Fit.baseTypeInvalidMap.get(type);
            }
            if (scale != 1.0 || offset != 0.0) {
                return ((Number)value).doubleValue() / scale - offset;
            }
        }
        return value;
    }

    public void setValue(Object value) {
        this.setValueInternal(0, value, null);
    }

    public void setValue(int fieldArrayIndex, Object value) {
        this.setValueInternal(fieldArrayIndex, value, null);
    }

    public void setValue(Object value, int subFieldIndex) {
        this.setValueInternal(0, value, this.getSubField(subFieldIndex));
    }

    public void setValue(Object value, String subFieldName) {
        this.setValueInternal(0, value, this.getSubField(subFieldName));
    }

    public void setValue(int fieldArrayIndex, Object value, int subFieldIndex) {
        SubField subField = null;
        if (subFieldIndex != 65535 && (subField = this.getSubField(subFieldIndex)) == null) {
            throw new FitRuntimeException("com.garmin.fit.Field.setValue(): " + subFieldIndex + " is not a valid subfield index of " + this.getName() + ".");
        }
        this.setValueInternal(fieldArrayIndex, value, subField);
    }

    public void setValue(int fieldArrayIndex, Object value, String subFieldName) {
        this.setValueInternal(fieldArrayIndex, value, this.getSubField(subFieldName));
    }

    private Object rangeCorrect(Integer type, Object value) {
        if (Fit.baseTypeMinMap.get(type) == null || Fit.baseTypeMaxMap.get(type) == null) {
            return value;
        }
        try {
            BigDecimal min = new BigDecimal(Fit.baseTypeMinMap.get(type).toString());
            BigDecimal max = new BigDecimal(Fit.baseTypeMaxMap.get(type).toString());
            BigDecimal val = new BigDecimal(value.toString());
            if (val.compareTo(min) < 0 || val.compareTo(max) > 0) {
                return Fit.baseTypeInvalidMap.get(type);
            }
            return value;
        }
        catch (NumberFormatException e) {
            return Fit.baseTypeInvalidMap.get(type);
        }
    }

    protected void setValueInternal(int fieldArrayIndex, Object value, SubField subField) {
        double offset;
        double scale;
        while (fieldArrayIndex >= this.getNumValues()) {
            this.addValue(new Object());
        }
        if (subField == null) {
            scale = this.getScale();
            offset = this.getOffset();
        } else {
            scale = subField.scale;
            offset = subField.offset;
        }
        if (value == null) {
            this.values.set(fieldArrayIndex, null);
        } else if (value instanceof Number && (scale != 1.0 || offset != 0.0)) {
            double rawValue = (((Number)value).doubleValue() + offset) * scale;
            switch (this.getType()) {
                case 0: 
                case 2: 
                case 10: 
                case 131: {
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), Math.round(rawValue)));
                    break;
                }
                case 1: {
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), Math.round(rawValue)));
                    break;
                }
                case 132: 
                case 133: 
                case 139: {
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), Math.round(rawValue)));
                    break;
                }
                case 134: 
                case 140: 
                case 142: {
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), Math.round(rawValue)));
                    break;
                }
                case 136: {
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), rawValue));
                    break;
                }
                case 137: {
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), rawValue));
                    break;
                }
                case 7: {
                    this.values.set(fieldArrayIndex, Double.valueOf(rawValue).toString());
                    break;
                }
                case 143: 
                case 144: {
                    Long val = Math.round(rawValue);
                    int size = Fit.baseTypeSizes[this.getType() & 0x1F];
                    byte[] bytes = new byte[size];
                    for (int i = 0; i < size; ++i) {
                        bytes[i] = (byte)(val >>> 8 * i);
                    }
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), new BigInteger(1, bytes)));
                    break;
                }
                case 13: {
                    this.values.set(fieldArrayIndex, Math.round(rawValue));
                    break;
                }
            }
        } else {
            this.SetValueUnscaled(fieldArrayIndex, value);
        }
    }

    private void SetValueUnscaled(int fieldArrayIndex, Object value) {
        if (value instanceof String && value.equals("")) {
            switch (this.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 10: 
                case 13: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 136: 
                case 137: 
                case 139: 
                case 140: 
                case 142: 
                case 143: 
                case 144: {
                    this.values.set(fieldArrayIndex, Fit.baseTypeInvalidMap.get(this.getType()));
                    break;
                }
                case 7: {
                    this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), value));
                    break;
                }
            }
        } else if (value instanceof String) {
            int byteCount = ((String)value).getBytes(StandardCharsets.UTF_8).length;
            if (byteCount > 254) {
                throw new FitRuntimeException(String.format("Invalid string size. Byte count can not be greater than %d bytes.", 254));
            }
            this.values.set(fieldArrayIndex, value);
        } else {
            this.values.set(fieldArrayIndex, this.rangeCorrect(this.getType(), value));
        }
    }

    public void setRawValue(int fieldArrayIndex, Object rawValue) {
        block13: {
            block14: {
                block12: {
                    while (fieldArrayIndex >= this.getNumValues()) {
                        this.addValue(new Object());
                    }
                    if (rawValue != null) break block12;
                    this.values.set(fieldArrayIndex, null);
                    break block13;
                }
                if (!(rawValue instanceof Double)) break block14;
                switch (this.getType()) {
                    case 0: 
                    case 2: 
                    case 10: 
                    case 13: 
                    case 131: {
                        this.values.set(fieldArrayIndex, (short)Math.round(((Number)rawValue).doubleValue()));
                        break;
                    }
                    case 1: {
                        this.values.set(fieldArrayIndex, (byte)Math.round(((Number)rawValue).doubleValue()));
                        break;
                    }
                    case 132: 
                    case 133: 
                    case 139: {
                        this.values.set(fieldArrayIndex, (int)Math.round(((Number)rawValue).doubleValue()));
                        break;
                    }
                    case 134: 
                    case 140: 
                    case 142: {
                        this.values.set(fieldArrayIndex, Math.round(((Number)rawValue).doubleValue()));
                        break;
                    }
                    case 136: {
                        this.values.set(fieldArrayIndex, rawValue);
                        break;
                    }
                    case 137: {
                        this.values.set(fieldArrayIndex, rawValue);
                        break;
                    }
                    case 7: {
                        this.values.set(fieldArrayIndex, rawValue.toString());
                        break;
                    }
                    case 143: 
                    case 144: {
                        Long val = Math.round(((Number)rawValue).doubleValue());
                        int size = Fit.baseTypeSizes[this.getType() & 0x1F];
                        byte[] bytes = new byte[size];
                        for (int i = 0; i < size; ++i) {
                            bytes[i] = (byte)(val >>> 8 * i);
                        }
                    }
                }
                break block13;
            }
            this.SetValueUnscaled(fieldArrayIndex, rawValue);
        }
    }

    public void addValue(Object value) {
        if (value instanceof Number && this.getType() == 7) {
            String string = this.getStringValueInternal(0, null);
            Number number = (Number)value;
            if (string == null) {
                string = "";
            }
            string = string + String.valueOf((char)number.intValue());
            this.setValueInternal(0, string, null);
            return;
        }
        this.values.add(value);
    }

    public Byte[] getByteValues() {
        return this.getByteValues((SubField)null);
    }

    public Byte[] getByteValues(int subfieldIndex) {
        return this.getByteValues(this.getSubField(subfieldIndex));
    }

    public Byte[] getByteValues(String subfieldName) {
        return this.getByteValues(this.getSubField(subfieldName));
    }

    protected Byte[] getByteValues(SubField subfield) {
        Byte[] rv = new Byte[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getByteValueInternal(i, subfield);
        }
        return rv;
    }

    public Byte getByteValue() {
        return this.getByteValueInternal(0, null);
    }

    public Byte getByteValue(int fieldArrayIndex) {
        return this.getByteValueInternal(fieldArrayIndex, null);
    }

    public Byte getByteValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getByteValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Byte getByteValue(int fieldArrayIndex, String subFieldName) {
        return this.getByteValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Byte getByteValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        if (value == null) {
            return null;
        }
        return ((Number)value).byteValue();
    }

    public Short[] getShortValues() {
        return this.getShortValues((SubField)null);
    }

    public Short[] getShortValues(int subfieldIndex) {
        return this.getShortValues(this.getSubField(subfieldIndex));
    }

    public Short[] getShortValues(String subfieldName) {
        return this.getShortValues(this.getSubField(subfieldName));
    }

    protected Short[] getShortValues(SubField subfield) {
        Short[] rv = new Short[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getShortValueInternal(i, subfield);
        }
        return rv;
    }

    public Short getShortValue() {
        return this.getShortValueInternal(0, null);
    }

    public Short getShortValue(int fieldArrayIndex) {
        return this.getShortValueInternal(fieldArrayIndex, null);
    }

    public Short getShortValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getShortValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Short getShortValue(int fieldArrayIndex, String subFieldName) {
        return this.getShortValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Short getShortValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        if (value == null) {
            return null;
        }
        return ((Number)value).shortValue();
    }

    public Integer[] getIntegerValues() {
        return this.getIntegerValues((SubField)null);
    }

    public Integer[] getIntegerValues(int subfieldIndex) {
        return this.getIntegerValues(this.getSubField(subfieldIndex));
    }

    public Integer[] getIntegerValues(String subfieldName) {
        return this.getIntegerValues(this.getSubField(subfieldName));
    }

    protected Integer[] getIntegerValues(SubField subfield) {
        Integer[] rv = new Integer[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getIntegerValueInternal(i, subfield);
        }
        return rv;
    }

    public Integer getIntegerValue() {
        return this.getIntegerValueInternal(0, null);
    }

    public Integer getIntegerValue(int fieldArrayIndex) {
        return this.getIntegerValueInternal(fieldArrayIndex, null);
    }

    public Integer getIntegerValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getIntegerValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Integer getIntegerValue(int fieldArrayIndex, String subFieldName) {
        return this.getIntegerValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Integer getIntegerValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        if (value == null) {
            return null;
        }
        return ((Number)value).intValue();
    }

    public Long[] getLongValues() {
        return this.getLongValues((SubField)null);
    }

    public Long[] getLongValues(int subfieldIndex) {
        return this.getLongValues(this.getSubField(subfieldIndex));
    }

    public Long[] getLongValues(String subfieldName) {
        return this.getLongValues(this.getSubField(subfieldName));
    }

    protected Long[] getLongValues(SubField subfield) {
        Long[] rv = new Long[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getLongValueInternal(i, subfield);
        }
        return rv;
    }

    public Long getLongValue() {
        return this.getLongValueInternal(0, null);
    }

    public Long getLongValue(int fieldArrayIndex) {
        return this.getLongValueInternal(fieldArrayIndex, null);
    }

    public Long getLongValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getLongValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Long getLongValue(int fieldArrayIndex, String subFieldName) {
        return this.getLongValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Long getLongValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        if (value == null) {
            return null;
        }
        return ((Number)value).longValue();
    }

    public Float[] getFloatValues() {
        return this.getFloatValues((SubField)null);
    }

    public Float[] getFloatValues(int subfieldIndex) {
        return this.getFloatValues(this.getSubField(subfieldIndex));
    }

    public Float[] getFloatValues(String subfieldName) {
        return this.getFloatValues(this.getSubField(subfieldName));
    }

    protected Float[] getFloatValues(SubField subfield) {
        Float[] rv = new Float[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getFloatValueInternal(i, subfield);
        }
        return rv;
    }

    public Float getFloatValue() {
        return this.getFloatValueInternal(0, null);
    }

    public Float getFloatValue(int fieldArrayIndex) {
        return this.getFloatValueInternal(fieldArrayIndex, null);
    }

    public Float getFloatValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getFloatValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Float getFloatValue(int fieldArrayIndex, String subFieldName) {
        return this.getFloatValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Float getFloatValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        if (value == null) {
            return null;
        }
        return new Float(((Number)value).doubleValue());
    }

    public Double[] getDoubleValues() {
        return this.getDoubleValues((SubField)null);
    }

    public Double[] getDoubleValues(int subfieldIndex) {
        return this.getDoubleValues(this.getSubField(subfieldIndex));
    }

    public Double[] getDoubleValues(String subfieldName) {
        return this.getDoubleValues(this.getSubField(subfieldName));
    }

    protected Double[] getDoubleValues(SubField subfield) {
        Double[] rv = new Double[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getDoubleValueInternal(i, subfield);
        }
        return rv;
    }

    public Double getDoubleValue() {
        return this.getDoubleValueInternal(0, null);
    }

    public Double getDoubleValue(int fieldArrayIndex) {
        return this.getDoubleValueInternal(fieldArrayIndex, null);
    }

    public Double getDoubleValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getDoubleValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public Double getDoubleValue(int fieldArrayIndex, String subFieldName) {
        return this.getDoubleValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected Double getDoubleValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        if (value == null) {
            return null;
        }
        return new Double(((Number)value).doubleValue());
    }

    public BigInteger[] getBigIntegerValues() {
        return this.getBigIntegerValues((SubField)null);
    }

    public BigInteger[] getBigIntegerValues(int subfieldIndex) {
        return this.getBigIntegerValues(this.getSubField(subfieldIndex));
    }

    public BigInteger[] getBigIntegerValues(String subfieldName) {
        return this.getBigIntegerValues(this.getSubField(subfieldName));
    }

    protected BigInteger[] getBigIntegerValues(SubField subfield) {
        BigInteger[] rv = new BigInteger[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getBigIntegerValueInternal(i, subfield);
        }
        return rv;
    }

    public BigInteger getBigIntegerValue() {
        return this.getBigIntegerValueInternal(0, null);
    }

    public BigInteger getBigIntegerValue(int fieldArrayIndex) {
        return this.getBigIntegerValueInternal(fieldArrayIndex, null);
    }

    public BigInteger getBigIntegerValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getBigIntegerValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public BigInteger getBigIntegerValue(int fieldArrayIndex, String subFieldName) {
        return this.getBigIntegerValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected BigInteger getBigIntegerValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        if (value == null) {
            return null;
        }
        return (BigInteger)value;
    }

    public String[] getStringValues() {
        return this.getStringValues((SubField)null);
    }

    public String[] getStringValues(int subfieldIndex) {
        return this.getStringValues(this.getSubField(subfieldIndex));
    }

    public String[] getStringValues(String subfieldName) {
        return this.getStringValues(this.getSubField(subfieldName));
    }

    protected String[] getStringValues(SubField subfield) {
        String[] rv = new String[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            rv[i] = this.getStringValueInternal(i, subfield);
        }
        return rv;
    }

    public String getStringValue() {
        return this.getStringValueInternal(0, null);
    }

    public String getStringValue(int fieldArrayIndex) {
        return this.getStringValueInternal(fieldArrayIndex, null);
    }

    public String getStringValue(int fieldArrayIndex, int subFieldIndex) {
        return this.getStringValueInternal(fieldArrayIndex, this.getSubField(subFieldIndex));
    }

    public String getStringValue(int fieldArrayIndex, String subFieldName) {
        return this.getStringValueInternal(fieldArrayIndex, this.getSubField(subFieldName));
    }

    protected String getStringValueInternal(int fieldArrayIndex, SubField subField) {
        Object value = this.getValueInternal(fieldArrayIndex, subField);
        int type = this.getTypeInternal(subField);
        if (value == null) {
            return null;
        }
        if (!forceShowInvalids && Fit.baseTypeInvalidMap.get(type).equals(value)) {
            return null;
        }
        return value.toString();
    }

    boolean read(InputStream in, int size) {
        block21: {
            try {
                DataInputStream data = new DataInputStream(in);
                if (this.getType() == 7) {
                    try {
                        byte[] bytes = new byte[size];
                        in.read(bytes, 0, size);
                        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                        CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder();
                        utf8Decoder.onMalformedInput(CodingErrorAction.IGNORE);
                        utf8Decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                        CharBuffer decoded = utf8Decoder.decode(byteBuffer);
                        String[] strings = decoded.toString().split("\u0000");
                        Arrays.stream(strings).forEach(string -> this.values.add(string));
                        break block21;
                    }
                    catch (IOException e) {
                        return true;
                    }
                }
                boolean invalid = true;
                int type = this.getType();
                int baseTypeSize = Fit.baseTypeSizes[type & 0x1F];
                Object invalidValue = Fit.baseTypeInvalidMap.get(type);
                for (int bytesLeft = size; bytesLeft > 0; bytesLeft -= Fit.baseTypeSizes[this.getType() & 0x1F]) {
                    Number value = null;
                    switch (type) {
                        case 0: 
                        case 2: 
                        case 10: {
                            value = (short)(data.readByte() & 0xFF);
                            break;
                        }
                        case 1: {
                            value = data.readByte();
                            break;
                        }
                        case 131: {
                            value = data.readShort();
                            break;
                        }
                        case 132: 
                        case 139: {
                            value = data.readByte() & 0xFF;
                            value = (Integer)value << 8;
                            value = (Integer)value | data.readByte() & 0xFF;
                            break;
                        }
                        case 133: {
                            value = data.readInt();
                            break;
                        }
                        case 134: 
                        case 140: 
                        case 142: {
                            value = (long)(data.readByte() & 0xFF);
                            for (int i = 1; i < baseTypeSize; ++i) {
                                value = (Long)value << 8;
                                value = (Long)value | (long)(data.readByte() & 0xFF);
                            }
                            break;
                        }
                        case 136: {
                            value = Float.valueOf(data.readFloat());
                            break;
                        }
                        case 137: {
                            value = data.readDouble();
                            break;
                        }
                        case 13: {
                            value = (short)(data.readByte() & 0xFF);
                            break;
                        }
                        case 143: 
                        case 144: {
                            byte[] bytes = new byte[baseTypeSize];
                            data.read(bytes, 0, baseTypeSize);
                            value = new BigInteger(1, bytes);
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (value != null) {
                        this.values.add(value);
                    }
                    if (value.equals(invalidValue)) continue;
                    invalid = false;
                }
                if (invalid && !forceShowInvalids) {
                    this.values.clear();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    protected void write(OutputStream out, FieldDefinitionBase fieldDef) {
        this.write(out);
        for (int bytesLeft = fieldDef.getSize() - this.getSize(); bytesLeft > 0; bytesLeft -= Fit.baseTypeSizes[this.getType() & 0x1F]) {
            this.writeValue(out, null);
        }
    }

    protected void write(OutputStream out) {
        for (Object value : this.values) {
            this.writeValue(out, value);
        }
    }

    private void writeValue(OutputStream out, Object value) {
        try {
            DataOutputStream data = new DataOutputStream(out);
            if (value == null) {
                switch (this.getType()) {
                    case 0: {
                        data.writeByte(Fit.ENUM_INVALID.shortValue());
                        break;
                    }
                    case 2: {
                        data.writeByte(Fit.UINT8_INVALID.shortValue());
                        break;
                    }
                    case 10: {
                        data.writeByte(Fit.UINT8Z_INVALID.shortValue());
                        break;
                    }
                    case 1: {
                        data.writeByte(Fit.SINT8_INVALID.byteValue());
                        break;
                    }
                    case 13: {
                        data.writeByte(Fit.BYTE_INVALID.shortValue());
                        break;
                    }
                    case 131: {
                        data.writeShort(Fit.SINT16_INVALID.shortValue());
                        break;
                    }
                    case 132: {
                        data.writeShort(Fit.UINT16_INVALID);
                        break;
                    }
                    case 139: {
                        data.writeShort(Fit.UINT16Z_INVALID);
                        break;
                    }
                    case 133: {
                        data.writeInt(Fit.SINT32_INVALID);
                        break;
                    }
                    case 134: {
                        data.writeInt((int)Fit.UINT32_INVALID.longValue());
                        break;
                    }
                    case 140: {
                        data.writeInt((int)Fit.UINT32Z_INVALID.longValue());
                        break;
                    }
                    case 142: {
                        data.writeLong(Fit.SINT64_INVALID);
                        break;
                    }
                    case 143: {
                        data.writeLong(Fit.UINT64_INVALID.longValue());
                        break;
                    }
                    case 144: {
                        data.writeLong(Fit.UINT64Z_INVALID.longValue());
                        break;
                    }
                    case 7: {
                        data.writeByte(0);
                        break;
                    }
                    case 136: {
                        data.writeFloat(Fit.FLOAT32_INVALID.floatValue());
                        break;
                    }
                    case 137: {
                        data.writeDouble(Fit.FLOAT64_INVALID);
                        break;
                    }
                }
            } else {
                switch (this.getType()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 10: 
                    case 13: {
                        if (value instanceof String) {
                            System.err.printf("Field.write(): Field %s value should not be string value %s\n", this.getFieldName(), value);
                        }
                        data.writeByte((int)Math.round(((Number)value).doubleValue()));
                        break;
                    }
                    case 131: 
                    case 132: 
                    case 139: {
                        data.writeShort((int)Math.round(((Number)value).doubleValue()));
                        break;
                    }
                    case 133: 
                    case 134: 
                    case 140: {
                        data.writeInt((int)Math.round(((Number)value).doubleValue()));
                        break;
                    }
                    case 7: {
                        OutputStreamWriter stringWriter = new OutputStreamWriter(out, "UTF-8");
                        stringWriter.write(value.toString());
                        stringWriter.flush();
                        out.write(0);
                        break;
                    }
                    case 136: {
                        data.writeFloat(((Number)value).floatValue());
                        break;
                    }
                    case 137: {
                        data.writeDouble(((Number)value).doubleValue());
                        break;
                    }
                    case 142: 
                    case 143: 
                    case 144: {
                        data.writeLong(((Number)value).longValue());
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

