/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC16;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.ProtocolValidator;
import com.garmin.fit.ProtocolValidatorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.CheckedOutputStream;

public class FileEncoder
implements MesgListener,
MesgDefinitionListener {
    private File file;
    private CheckedOutputStream out;
    private CRC16 crc16;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];
    private Fit.ProtocolVersion version;
    private ProtocolValidator validator;

    public FileEncoder() {
    }

    @Deprecated
    public FileEncoder(File file) {
        this(file, Fit.ProtocolVersion.V1_0);
    }

    public FileEncoder(File file, Fit.ProtocolVersion version) {
        this.version = version;
        this.validator = ProtocolValidatorFactory.getProtocolValidator(version);
        this.open(file);
    }

    public void open(File file) {
        file.delete();
        this.crc16 = new CRC16();
        this.file = file;
        this.writeFileHeader();
        try {
            this.out = new CheckedOutputStream(new FileOutputStream(this.file, true), this.crc16);
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
    }

    private void writeFileHeader() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        try {
            CRC16 crc = new CRC16();
            RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
            long dataSize = this.file.length() - 14L;
            long crcValue = 0L;
            if (dataSize < 0L) {
                dataSize = 0L;
            }
            byte[] header = new byte[]{14, (byte)this.version.getVersion(), -107, 82, (byte)(dataSize & 0xFFL), (byte)(dataSize >> 8 & 0xFFL), (byte)(dataSize >> 16 & 0xFFL), (byte)(dataSize >> 24 & 0xFFL), 46, 70, 73, 84};
            raf.write(header);
            crc.update(header, 0, header.length);
            crcValue = crc.getValue();
            raf.write((byte)(crcValue & 0xFFL));
            raf.write((byte)(crcValue >> 8 & 0xFFL));
            raf.close();
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void write(MesgDefinition mesgDefinition) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        if (!this.validator.validateMesgDefn(mesgDefinition)) {
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        mesgDefinition.write(this.out);
        this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
    }

    public void write(Mesg mesg) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        if (!this.validator.validateMesg(mesg)) {
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports(mesg)) {
            this.write(new MesgDefinition(mesg));
        }
        mesg.write(this.out, this.lastMesgDefinition[mesg.localNum]);
    }

    public void write(List<? extends Mesg> mesgs) {
        for (Mesg mesg : mesgs) {
            this.write(mesg);
        }
    }

    public void close() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        try {
            this.writeFileHeader();
            long crc = this.out.getChecksum().getValue();
            this.out.write((int)(crc & 0xFFL));
            this.out.write((int)(crc >> 8 & 0xFFL));
            this.out.close();
            this.file = null;
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
    }
}

