/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Decode;
import com.garmin.fit.File;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.Mesg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class FileUtil {
    public static Collection<byte[]> split(InputStream input) {
        ArrayList<byte[]> files = new ArrayList<byte[]>();
        try {
            int pos;
            int fileSize;
            byte[] data = new byte[input.available()];
            input.read(data);
            for (pos = 0; pos < data.length; pos += fileSize) {
                byte fileHdrSize = data[pos];
                int fileDataSize = data[pos + 4] & 0xFF;
                fileDataSize |= (data[pos + 5] & 0xFF) << 8;
                fileDataSize |= (data[pos + 6] & 0xFF) << 16;
                if (data[pos + 8] != 46 || data[pos + 9] != 70 || data[pos + 10] != 73 || data[pos + 11] != 84 || pos + (fileSize = fileHdrSize + (fileDataSize |= (data[pos + 7] & 0xFF) << 24) + 2) > data.length) break;
                files.add(Arrays.copyOfRange(data, pos, pos + fileSize));
            }
            if (pos < data.length) {
                files.add(Arrays.copyOfRange(data, pos, data.length));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files;
    }

    public static Collection<byte[]> prepend(Collection<byte[]> files, File fromFileType, File toFileType) {
        ArrayList<byte[]> fromFiles = new ArrayList<byte[]>();
        ArrayList<byte[]> toFiles = new ArrayList<byte[]>();
        ArrayList<byte[]> returnFiles = new ArrayList<byte[]>();
        block4: for (byte[] file : files) {
            Decode decode = new Decode();
            Decode.RETURN decodeReturn = Decode.RETURN.CONTINUE;
            boolean decodeComplete = false;
            ByteArrayInputStream fileStream = new ByteArrayInputStream(file);
            block5: while (!decodeComplete) {
                int datum = fileStream.read();
                if (datum < 0) {
                    System.out.println("end of stream");
                    continue block4;
                }
                decodeReturn = decode.read((byte)datum);
                switch (decodeReturn) {
                    case MESG: {
                        Mesg mesg = decode.getMesg();
                        if (!mesg.name.equals("file_id")) continue block5;
                        FileIdMesg fileIdMesg = new FileIdMesg(mesg);
                        if (fileIdMesg.getType().equals((Object)fromFileType)) {
                            fromFiles.add(file);
                        }
                        if (fileIdMesg.getType().equals((Object)toFileType)) {
                            toFiles.add(file);
                        }
                        decodeComplete = true;
                        continue block5;
                    }
                    case END_OF_FILE: {
                        decodeComplete = true;
                        continue block5;
                    }
                }
            }
        }
        for (byte[] file : files) {
            if (toFiles.contains(file)) {
                int newFileLength = file.length;
                int newFilePos = 0;
                for (byte[] fromFile : fromFiles) {
                    newFileLength += fromFile.length;
                }
                byte[] newFile = new byte[newFileLength];
                for (byte[] fromFile : fromFiles) {
                    System.arraycopy(fromFile, 0, newFile, newFilePos, fromFile.length);
                    newFilePos += fromFile.length;
                }
                System.arraycopy(file, 0, newFile, newFilePos, file.length);
                returnFiles.add(newFile);
                continue;
            }
            returnFiles.add(file);
        }
        return returnFiles;
    }
}

