/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.BufferedMesgBroadcaster;
import com.garmin.fit.Decode;
import com.garmin.fit.FitListener;
import com.garmin.fit.FitMessages;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.MesgBroadcastPlugin;
import java.io.InputStream;

public class FitDecoder {
    public FitMessages decode(InputStream inputStream) {
        Decode decode = new Decode();
        FitListener fitListener = new FitListener();
        try {
            decode.read(inputStream, fitListener, null);
        }
        catch (FitRuntimeException fre) {
            if (decode.getInvalidFileDataSize()) {
                decode.nextFile();
                decode.read(inputStream, fitListener, null);
            }
            throw fre;
        }
        return fitListener.getFitMessages();
    }

    public FitMessages decode(InputStream inputStream, MesgBroadcastPlugin plugin) {
        Decode decode = new Decode();
        FitListener fitListener = new FitListener();
        BufferedMesgBroadcaster mesgBroadcaster = new BufferedMesgBroadcaster(decode);
        mesgBroadcaster.registerMesgBroadcastPlugin(plugin);
        mesgBroadcaster.addListener(fitListener);
        try {
            mesgBroadcaster.run(inputStream);
            mesgBroadcaster.broadcast();
        }
        catch (FitRuntimeException fre) {
            if (decode.getInvalidFileDataSize()) {
                decode.nextFile();
                mesgBroadcaster.run(inputStream);
                mesgBroadcaster.broadcast();
            }
            throw fre;
        }
        return fitListener.getFitMessages();
    }
}

