/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Intensity;
import com.garmin.fit.LapTrigger;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.Profile;
import com.garmin.fit.Sport;
import com.garmin.fit.SubField;
import com.garmin.fit.SubSport;
import com.garmin.fit.SwimStroke;

public class LapMesg
extends Mesg
implements MesgWithEvent {
    public static final int MessageIndexFieldNum = 254;
    public static final int TimestampFieldNum = 253;
    public static final int EventFieldNum = 0;
    public static final int EventTypeFieldNum = 1;
    public static final int StartTimeFieldNum = 2;
    public static final int StartPositionLatFieldNum = 3;
    public static final int StartPositionLongFieldNum = 4;
    public static final int EndPositionLatFieldNum = 5;
    public static final int EndPositionLongFieldNum = 6;
    public static final int TotalElapsedTimeFieldNum = 7;
    public static final int TotalTimerTimeFieldNum = 8;
    public static final int TotalDistanceFieldNum = 9;
    public static final int TotalCyclesFieldNum = 10;
    public static final int TotalCaloriesFieldNum = 11;
    public static final int TotalFatCaloriesFieldNum = 12;
    public static final int AvgSpeedFieldNum = 13;
    public static final int MaxSpeedFieldNum = 14;
    public static final int AvgHeartRateFieldNum = 15;
    public static final int MaxHeartRateFieldNum = 16;
    public static final int AvgCadenceFieldNum = 17;
    public static final int MaxCadenceFieldNum = 18;
    public static final int AvgPowerFieldNum = 19;
    public static final int MaxPowerFieldNum = 20;
    public static final int TotalAscentFieldNum = 21;
    public static final int TotalDescentFieldNum = 22;
    public static final int IntensityFieldNum = 23;
    public static final int LapTriggerFieldNum = 24;
    public static final int SportFieldNum = 25;
    public static final int EventGroupFieldNum = 26;
    public static final int NumLengthsFieldNum = 32;
    public static final int NormalizedPowerFieldNum = 33;
    public static final int LeftRightBalanceFieldNum = 34;
    public static final int FirstLengthIndexFieldNum = 35;
    public static final int AvgStrokeDistanceFieldNum = 37;
    public static final int SwimStrokeFieldNum = 38;
    public static final int SubSportFieldNum = 39;
    public static final int NumActiveLengthsFieldNum = 40;
    public static final int TotalWorkFieldNum = 41;
    public static final int AvgAltitudeFieldNum = 42;
    public static final int MaxAltitudeFieldNum = 43;
    public static final int GpsAccuracyFieldNum = 44;
    public static final int AvgGradeFieldNum = 45;
    public static final int AvgPosGradeFieldNum = 46;
    public static final int AvgNegGradeFieldNum = 47;
    public static final int MaxPosGradeFieldNum = 48;
    public static final int MaxNegGradeFieldNum = 49;
    public static final int AvgTemperatureFieldNum = 50;
    public static final int MaxTemperatureFieldNum = 51;
    public static final int TotalMovingTimeFieldNum = 52;
    public static final int AvgPosVerticalSpeedFieldNum = 53;
    public static final int AvgNegVerticalSpeedFieldNum = 54;
    public static final int MaxPosVerticalSpeedFieldNum = 55;
    public static final int MaxNegVerticalSpeedFieldNum = 56;
    public static final int TimeInHrZoneFieldNum = 57;
    public static final int TimeInSpeedZoneFieldNum = 58;
    public static final int TimeInCadenceZoneFieldNum = 59;
    public static final int TimeInPowerZoneFieldNum = 60;
    public static final int RepetitionNumFieldNum = 61;
    public static final int MinAltitudeFieldNum = 62;
    public static final int MinHeartRateFieldNum = 63;
    public static final int WktStepIndexFieldNum = 71;
    public static final int OpponentScoreFieldNum = 74;
    public static final int StrokeCountFieldNum = 75;
    public static final int ZoneCountFieldNum = 76;
    public static final int AvgVerticalOscillationFieldNum = 77;
    public static final int AvgStanceTimePercentFieldNum = 78;
    public static final int AvgStanceTimeFieldNum = 79;
    public static final int AvgFractionalCadenceFieldNum = 80;
    public static final int MaxFractionalCadenceFieldNum = 81;
    public static final int TotalFractionalCyclesFieldNum = 82;
    public static final int PlayerScoreFieldNum = 83;
    public static final int AvgTotalHemoglobinConcFieldNum = 84;
    public static final int MinTotalHemoglobinConcFieldNum = 85;
    public static final int MaxTotalHemoglobinConcFieldNum = 86;
    public static final int AvgSaturatedHemoglobinPercentFieldNum = 87;
    public static final int MinSaturatedHemoglobinPercentFieldNum = 88;
    public static final int MaxSaturatedHemoglobinPercentFieldNum = 89;
    public static final int AvgLeftTorqueEffectivenessFieldNum = 91;
    public static final int AvgRightTorqueEffectivenessFieldNum = 92;
    public static final int AvgLeftPedalSmoothnessFieldNum = 93;
    public static final int AvgRightPedalSmoothnessFieldNum = 94;
    public static final int AvgCombinedPedalSmoothnessFieldNum = 95;
    public static final int TimeStandingFieldNum = 98;
    public static final int StandCountFieldNum = 99;
    public static final int AvgLeftPcoFieldNum = 100;
    public static final int AvgRightPcoFieldNum = 101;
    public static final int AvgLeftPowerPhaseFieldNum = 102;
    public static final int AvgLeftPowerPhasePeakFieldNum = 103;
    public static final int AvgRightPowerPhaseFieldNum = 104;
    public static final int AvgRightPowerPhasePeakFieldNum = 105;
    public static final int AvgPowerPositionFieldNum = 106;
    public static final int MaxPowerPositionFieldNum = 107;
    public static final int AvgCadencePositionFieldNum = 108;
    public static final int MaxCadencePositionFieldNum = 109;
    public static final int EnhancedAvgSpeedFieldNum = 110;
    public static final int EnhancedMaxSpeedFieldNum = 111;
    public static final int EnhancedAvgAltitudeFieldNum = 112;
    public static final int EnhancedMinAltitudeFieldNum = 113;
    public static final int EnhancedMaxAltitudeFieldNum = 114;
    public static final int AvgLevMotorPowerFieldNum = 115;
    public static final int MaxLevMotorPowerFieldNum = 116;
    public static final int LevBatteryConsumptionFieldNum = 117;
    public static final int AvgVerticalRatioFieldNum = 118;
    public static final int AvgStanceTimeBalanceFieldNum = 119;
    public static final int AvgStepLengthFieldNum = 120;
    public static final int AvgVamFieldNum = 121;
    public static final int AvgDepthFieldNum = 122;
    public static final int MaxDepthFieldNum = 123;
    public static final int MinTemperatureFieldNum = 124;
    public static final int EnhancedAvgRespirationRateFieldNum = 136;
    public static final int EnhancedMaxRespirationRateFieldNum = 137;
    public static final int AvgRespirationRateFieldNum = 147;
    public static final int MaxRespirationRateFieldNum = 148;
    public static final int TotalGritFieldNum = 149;
    public static final int TotalFlowFieldNum = 150;
    public static final int JumpCountFieldNum = 151;
    public static final int AvgGritFieldNum = 153;
    public static final int AvgFlowFieldNum = 154;
    public static final int TotalFractionalAscentFieldNum = 156;
    public static final int TotalFractionalDescentFieldNum = 157;
    public static final int AvgCoreTemperatureFieldNum = 158;
    public static final int MinCoreTemperatureFieldNum = 159;
    public static final int MaxCoreTemperatureFieldNum = 160;
    protected static final Mesg lapMesg;

    public LapMesg() {
        super(Factory.createMesg(19));
    }

    public LapMesg(Mesg mesg) {
        super(mesg);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public void setMessageIndex(Integer messageIndex) {
        this.setFieldValue(254, 0, (Object)messageIndex, 65535);
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    @Override
    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    @Override
    public Event getEvent() {
        Short value = this.getFieldShortValue(0, 0, 65535);
        if (value == null) {
            return null;
        }
        return Event.getByValue(value);
    }

    @Override
    public void setEvent(Event event) {
        this.setFieldValue(0, 0, (Object)event.value, 65535);
    }

    @Override
    public EventType getEventType() {
        Short value = this.getFieldShortValue(1, 0, 65535);
        if (value == null) {
            return null;
        }
        return EventType.getByValue(value);
    }

    @Override
    public void setEventType(EventType eventType) {
        this.setFieldValue(1, 0, (Object)eventType.value, 65535);
    }

    public DateTime getStartTime() {
        return this.timestampToDateTime(this.getFieldLongValue(2, 0, 65535));
    }

    public void setStartTime(DateTime startTime) {
        this.setFieldValue(2, 0, (Object)startTime.getTimestamp(), 65535);
    }

    public Integer getStartPositionLat() {
        return this.getFieldIntegerValue(3, 0, 65535);
    }

    public void setStartPositionLat(Integer startPositionLat) {
        this.setFieldValue(3, 0, (Object)startPositionLat, 65535);
    }

    public Integer getStartPositionLong() {
        return this.getFieldIntegerValue(4, 0, 65535);
    }

    public void setStartPositionLong(Integer startPositionLong) {
        this.setFieldValue(4, 0, (Object)startPositionLong, 65535);
    }

    public Integer getEndPositionLat() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public void setEndPositionLat(Integer endPositionLat) {
        this.setFieldValue(5, 0, (Object)endPositionLat, 65535);
    }

    public Integer getEndPositionLong() {
        return this.getFieldIntegerValue(6, 0, 65535);
    }

    public void setEndPositionLong(Integer endPositionLong) {
        this.setFieldValue(6, 0, (Object)endPositionLong, 65535);
    }

    public Float getTotalElapsedTime() {
        return this.getFieldFloatValue(7, 0, 65535);
    }

    public void setTotalElapsedTime(Float totalElapsedTime) {
        this.setFieldValue(7, 0, (Object)totalElapsedTime, 65535);
    }

    public Float getTotalTimerTime() {
        return this.getFieldFloatValue(8, 0, 65535);
    }

    public void setTotalTimerTime(Float totalTimerTime) {
        this.setFieldValue(8, 0, (Object)totalTimerTime, 65535);
    }

    public Float getTotalDistance() {
        return this.getFieldFloatValue(9, 0, 65535);
    }

    public void setTotalDistance(Float totalDistance) {
        this.setFieldValue(9, 0, (Object)totalDistance, 65535);
    }

    public Long getTotalCycles() {
        return this.getFieldLongValue(10, 0, 65535);
    }

    public void setTotalCycles(Long totalCycles) {
        this.setFieldValue(10, 0, (Object)totalCycles, 65535);
    }

    public Long getTotalStrides() {
        return this.getFieldLongValue(10, 0, 0);
    }

    public void setTotalStrides(Long totalStrides) {
        this.setFieldValue(10, 0, (Object)totalStrides, 0);
    }

    public Long getTotalStrokes() {
        return this.getFieldLongValue(10, 0, 1);
    }

    public void setTotalStrokes(Long totalStrokes) {
        this.setFieldValue(10, 0, (Object)totalStrokes, 1);
    }

    public Integer getTotalCalories() {
        return this.getFieldIntegerValue(11, 0, 65535);
    }

    public void setTotalCalories(Integer totalCalories) {
        this.setFieldValue(11, 0, (Object)totalCalories, 65535);
    }

    public Integer getTotalFatCalories() {
        return this.getFieldIntegerValue(12, 0, 65535);
    }

    public void setTotalFatCalories(Integer totalFatCalories) {
        this.setFieldValue(12, 0, (Object)totalFatCalories, 65535);
    }

    public Float getAvgSpeed() {
        return this.getFieldFloatValue(13, 0, 65535);
    }

    public void setAvgSpeed(Float avgSpeed) {
        this.setFieldValue(13, 0, (Object)avgSpeed, 65535);
    }

    public Float getMaxSpeed() {
        return this.getFieldFloatValue(14, 0, 65535);
    }

    public void setMaxSpeed(Float maxSpeed) {
        this.setFieldValue(14, 0, (Object)maxSpeed, 65535);
    }

    public Short getAvgHeartRate() {
        return this.getFieldShortValue(15, 0, 65535);
    }

    public void setAvgHeartRate(Short avgHeartRate) {
        this.setFieldValue(15, 0, (Object)avgHeartRate, 65535);
    }

    public Short getMaxHeartRate() {
        return this.getFieldShortValue(16, 0, 65535);
    }

    public void setMaxHeartRate(Short maxHeartRate) {
        this.setFieldValue(16, 0, (Object)maxHeartRate, 65535);
    }

    public Short getAvgCadence() {
        return this.getFieldShortValue(17, 0, 65535);
    }

    public void setAvgCadence(Short avgCadence) {
        this.setFieldValue(17, 0, (Object)avgCadence, 65535);
    }

    public Short getAvgRunningCadence() {
        return this.getFieldShortValue(17, 0, 0);
    }

    public void setAvgRunningCadence(Short avgRunningCadence) {
        this.setFieldValue(17, 0, (Object)avgRunningCadence, 0);
    }

    public Short getMaxCadence() {
        return this.getFieldShortValue(18, 0, 65535);
    }

    public void setMaxCadence(Short maxCadence) {
        this.setFieldValue(18, 0, (Object)maxCadence, 65535);
    }

    public Short getMaxRunningCadence() {
        return this.getFieldShortValue(18, 0, 0);
    }

    public void setMaxRunningCadence(Short maxRunningCadence) {
        this.setFieldValue(18, 0, (Object)maxRunningCadence, 0);
    }

    public Integer getAvgPower() {
        return this.getFieldIntegerValue(19, 0, 65535);
    }

    public void setAvgPower(Integer avgPower) {
        this.setFieldValue(19, 0, (Object)avgPower, 65535);
    }

    public Integer getMaxPower() {
        return this.getFieldIntegerValue(20, 0, 65535);
    }

    public void setMaxPower(Integer maxPower) {
        this.setFieldValue(20, 0, (Object)maxPower, 65535);
    }

    public Integer getTotalAscent() {
        return this.getFieldIntegerValue(21, 0, 65535);
    }

    public void setTotalAscent(Integer totalAscent) {
        this.setFieldValue(21, 0, (Object)totalAscent, 65535);
    }

    public Integer getTotalDescent() {
        return this.getFieldIntegerValue(22, 0, 65535);
    }

    public void setTotalDescent(Integer totalDescent) {
        this.setFieldValue(22, 0, (Object)totalDescent, 65535);
    }

    public Intensity getIntensity() {
        Short value = this.getFieldShortValue(23, 0, 65535);
        if (value == null) {
            return null;
        }
        return Intensity.getByValue(value);
    }

    public void setIntensity(Intensity intensity) {
        this.setFieldValue(23, 0, (Object)intensity.value, 65535);
    }

    public LapTrigger getLapTrigger() {
        Short value = this.getFieldShortValue(24, 0, 65535);
        if (value == null) {
            return null;
        }
        return LapTrigger.getByValue(value);
    }

    public void setLapTrigger(LapTrigger lapTrigger) {
        this.setFieldValue(24, 0, (Object)lapTrigger.value, 65535);
    }

    public Sport getSport() {
        Short value = this.getFieldShortValue(25, 0, 65535);
        if (value == null) {
            return null;
        }
        return Sport.getByValue(value);
    }

    public void setSport(Sport sport) {
        this.setFieldValue(25, 0, (Object)sport.value, 65535);
    }

    @Override
    public Short getEventGroup() {
        return this.getFieldShortValue(26, 0, 65535);
    }

    @Override
    public void setEventGroup(Short eventGroup) {
        this.setFieldValue(26, 0, (Object)eventGroup, 65535);
    }

    public Integer getNumLengths() {
        return this.getFieldIntegerValue(32, 0, 65535);
    }

    public void setNumLengths(Integer numLengths) {
        this.setFieldValue(32, 0, (Object)numLengths, 65535);
    }

    public Integer getNormalizedPower() {
        return this.getFieldIntegerValue(33, 0, 65535);
    }

    public void setNormalizedPower(Integer normalizedPower) {
        this.setFieldValue(33, 0, (Object)normalizedPower, 65535);
    }

    public Integer getLeftRightBalance() {
        return this.getFieldIntegerValue(34, 0, 65535);
    }

    public void setLeftRightBalance(Integer leftRightBalance) {
        this.setFieldValue(34, 0, (Object)leftRightBalance, 65535);
    }

    public Integer getFirstLengthIndex() {
        return this.getFieldIntegerValue(35, 0, 65535);
    }

    public void setFirstLengthIndex(Integer firstLengthIndex) {
        this.setFieldValue(35, 0, (Object)firstLengthIndex, 65535);
    }

    public Float getAvgStrokeDistance() {
        return this.getFieldFloatValue(37, 0, 65535);
    }

    public void setAvgStrokeDistance(Float avgStrokeDistance) {
        this.setFieldValue(37, 0, (Object)avgStrokeDistance, 65535);
    }

    public SwimStroke getSwimStroke() {
        Short value = this.getFieldShortValue(38, 0, 65535);
        if (value == null) {
            return null;
        }
        return SwimStroke.getByValue(value);
    }

    public void setSwimStroke(SwimStroke swimStroke) {
        this.setFieldValue(38, 0, (Object)swimStroke.value, 65535);
    }

    public SubSport getSubSport() {
        Short value = this.getFieldShortValue(39, 0, 65535);
        if (value == null) {
            return null;
        }
        return SubSport.getByValue(value);
    }

    public void setSubSport(SubSport subSport) {
        this.setFieldValue(39, 0, (Object)subSport.value, 65535);
    }

    public Integer getNumActiveLengths() {
        return this.getFieldIntegerValue(40, 0, 65535);
    }

    public void setNumActiveLengths(Integer numActiveLengths) {
        this.setFieldValue(40, 0, (Object)numActiveLengths, 65535);
    }

    public Long getTotalWork() {
        return this.getFieldLongValue(41, 0, 65535);
    }

    public void setTotalWork(Long totalWork) {
        this.setFieldValue(41, 0, (Object)totalWork, 65535);
    }

    public Float getAvgAltitude() {
        return this.getFieldFloatValue(42, 0, 65535);
    }

    public void setAvgAltitude(Float avgAltitude) {
        this.setFieldValue(42, 0, (Object)avgAltitude, 65535);
    }

    public Float getMaxAltitude() {
        return this.getFieldFloatValue(43, 0, 65535);
    }

    public void setMaxAltitude(Float maxAltitude) {
        this.setFieldValue(43, 0, (Object)maxAltitude, 65535);
    }

    public Short getGpsAccuracy() {
        return this.getFieldShortValue(44, 0, 65535);
    }

    public void setGpsAccuracy(Short gpsAccuracy) {
        this.setFieldValue(44, 0, (Object)gpsAccuracy, 65535);
    }

    public Float getAvgGrade() {
        return this.getFieldFloatValue(45, 0, 65535);
    }

    public void setAvgGrade(Float avgGrade) {
        this.setFieldValue(45, 0, (Object)avgGrade, 65535);
    }

    public Float getAvgPosGrade() {
        return this.getFieldFloatValue(46, 0, 65535);
    }

    public void setAvgPosGrade(Float avgPosGrade) {
        this.setFieldValue(46, 0, (Object)avgPosGrade, 65535);
    }

    public Float getAvgNegGrade() {
        return this.getFieldFloatValue(47, 0, 65535);
    }

    public void setAvgNegGrade(Float avgNegGrade) {
        this.setFieldValue(47, 0, (Object)avgNegGrade, 65535);
    }

    public Float getMaxPosGrade() {
        return this.getFieldFloatValue(48, 0, 65535);
    }

    public void setMaxPosGrade(Float maxPosGrade) {
        this.setFieldValue(48, 0, (Object)maxPosGrade, 65535);
    }

    public Float getMaxNegGrade() {
        return this.getFieldFloatValue(49, 0, 65535);
    }

    public void setMaxNegGrade(Float maxNegGrade) {
        this.setFieldValue(49, 0, (Object)maxNegGrade, 65535);
    }

    public Byte getAvgTemperature() {
        return this.getFieldByteValue(50, 0, 65535);
    }

    public void setAvgTemperature(Byte avgTemperature) {
        this.setFieldValue(50, 0, (Object)avgTemperature, 65535);
    }

    public Byte getMaxTemperature() {
        return this.getFieldByteValue(51, 0, 65535);
    }

    public void setMaxTemperature(Byte maxTemperature) {
        this.setFieldValue(51, 0, (Object)maxTemperature, 65535);
    }

    public Float getTotalMovingTime() {
        return this.getFieldFloatValue(52, 0, 65535);
    }

    public void setTotalMovingTime(Float totalMovingTime) {
        this.setFieldValue(52, 0, (Object)totalMovingTime, 65535);
    }

    public Float getAvgPosVerticalSpeed() {
        return this.getFieldFloatValue(53, 0, 65535);
    }

    public void setAvgPosVerticalSpeed(Float avgPosVerticalSpeed) {
        this.setFieldValue(53, 0, (Object)avgPosVerticalSpeed, 65535);
    }

    public Float getAvgNegVerticalSpeed() {
        return this.getFieldFloatValue(54, 0, 65535);
    }

    public void setAvgNegVerticalSpeed(Float avgNegVerticalSpeed) {
        this.setFieldValue(54, 0, (Object)avgNegVerticalSpeed, 65535);
    }

    public Float getMaxPosVerticalSpeed() {
        return this.getFieldFloatValue(55, 0, 65535);
    }

    public void setMaxPosVerticalSpeed(Float maxPosVerticalSpeed) {
        this.setFieldValue(55, 0, (Object)maxPosVerticalSpeed, 65535);
    }

    public Float getMaxNegVerticalSpeed() {
        return this.getFieldFloatValue(56, 0, 65535);
    }

    public void setMaxNegVerticalSpeed(Float maxNegVerticalSpeed) {
        this.setFieldValue(56, 0, (Object)maxNegVerticalSpeed, 65535);
    }

    public Float[] getTimeInHrZone() {
        return this.getFieldFloatValues(57, 65535);
    }

    public int getNumTimeInHrZone() {
        return this.getNumFieldValues(57, 65535);
    }

    public Float getTimeInHrZone(int index) {
        return this.getFieldFloatValue(57, index, 65535);
    }

    public void setTimeInHrZone(int index, Float timeInHrZone) {
        this.setFieldValue(57, index, (Object)timeInHrZone, 65535);
    }

    public Float[] getTimeInSpeedZone() {
        return this.getFieldFloatValues(58, 65535);
    }

    public int getNumTimeInSpeedZone() {
        return this.getNumFieldValues(58, 65535);
    }

    public Float getTimeInSpeedZone(int index) {
        return this.getFieldFloatValue(58, index, 65535);
    }

    public void setTimeInSpeedZone(int index, Float timeInSpeedZone) {
        this.setFieldValue(58, index, (Object)timeInSpeedZone, 65535);
    }

    public Float[] getTimeInCadenceZone() {
        return this.getFieldFloatValues(59, 65535);
    }

    public int getNumTimeInCadenceZone() {
        return this.getNumFieldValues(59, 65535);
    }

    public Float getTimeInCadenceZone(int index) {
        return this.getFieldFloatValue(59, index, 65535);
    }

    public void setTimeInCadenceZone(int index, Float timeInCadenceZone) {
        this.setFieldValue(59, index, (Object)timeInCadenceZone, 65535);
    }

    public Float[] getTimeInPowerZone() {
        return this.getFieldFloatValues(60, 65535);
    }

    public int getNumTimeInPowerZone() {
        return this.getNumFieldValues(60, 65535);
    }

    public Float getTimeInPowerZone(int index) {
        return this.getFieldFloatValue(60, index, 65535);
    }

    public void setTimeInPowerZone(int index, Float timeInPowerZone) {
        this.setFieldValue(60, index, (Object)timeInPowerZone, 65535);
    }

    public Integer getRepetitionNum() {
        return this.getFieldIntegerValue(61, 0, 65535);
    }

    public void setRepetitionNum(Integer repetitionNum) {
        this.setFieldValue(61, 0, (Object)repetitionNum, 65535);
    }

    public Float getMinAltitude() {
        return this.getFieldFloatValue(62, 0, 65535);
    }

    public void setMinAltitude(Float minAltitude) {
        this.setFieldValue(62, 0, (Object)minAltitude, 65535);
    }

    public Short getMinHeartRate() {
        return this.getFieldShortValue(63, 0, 65535);
    }

    public void setMinHeartRate(Short minHeartRate) {
        this.setFieldValue(63, 0, (Object)minHeartRate, 65535);
    }

    public Integer getWktStepIndex() {
        return this.getFieldIntegerValue(71, 0, 65535);
    }

    public void setWktStepIndex(Integer wktStepIndex) {
        this.setFieldValue(71, 0, (Object)wktStepIndex, 65535);
    }

    public Integer getOpponentScore() {
        return this.getFieldIntegerValue(74, 0, 65535);
    }

    public void setOpponentScore(Integer opponentScore) {
        this.setFieldValue(74, 0, (Object)opponentScore, 65535);
    }

    public Integer[] getStrokeCount() {
        return this.getFieldIntegerValues(75, 65535);
    }

    public int getNumStrokeCount() {
        return this.getNumFieldValues(75, 65535);
    }

    public Integer getStrokeCount(int index) {
        return this.getFieldIntegerValue(75, index, 65535);
    }

    public void setStrokeCount(int index, Integer strokeCount) {
        this.setFieldValue(75, index, (Object)strokeCount, 65535);
    }

    public Integer[] getZoneCount() {
        return this.getFieldIntegerValues(76, 65535);
    }

    public int getNumZoneCount() {
        return this.getNumFieldValues(76, 65535);
    }

    public Integer getZoneCount(int index) {
        return this.getFieldIntegerValue(76, index, 65535);
    }

    public void setZoneCount(int index, Integer zoneCount) {
        this.setFieldValue(76, index, (Object)zoneCount, 65535);
    }

    public Float getAvgVerticalOscillation() {
        return this.getFieldFloatValue(77, 0, 65535);
    }

    public void setAvgVerticalOscillation(Float avgVerticalOscillation) {
        this.setFieldValue(77, 0, (Object)avgVerticalOscillation, 65535);
    }

    public Float getAvgStanceTimePercent() {
        return this.getFieldFloatValue(78, 0, 65535);
    }

    public void setAvgStanceTimePercent(Float avgStanceTimePercent) {
        this.setFieldValue(78, 0, (Object)avgStanceTimePercent, 65535);
    }

    public Float getAvgStanceTime() {
        return this.getFieldFloatValue(79, 0, 65535);
    }

    public void setAvgStanceTime(Float avgStanceTime) {
        this.setFieldValue(79, 0, (Object)avgStanceTime, 65535);
    }

    public Float getAvgFractionalCadence() {
        return this.getFieldFloatValue(80, 0, 65535);
    }

    public void setAvgFractionalCadence(Float avgFractionalCadence) {
        this.setFieldValue(80, 0, (Object)avgFractionalCadence, 65535);
    }

    public Float getMaxFractionalCadence() {
        return this.getFieldFloatValue(81, 0, 65535);
    }

    public void setMaxFractionalCadence(Float maxFractionalCadence) {
        this.setFieldValue(81, 0, (Object)maxFractionalCadence, 65535);
    }

    public Float getTotalFractionalCycles() {
        return this.getFieldFloatValue(82, 0, 65535);
    }

    public void setTotalFractionalCycles(Float totalFractionalCycles) {
        this.setFieldValue(82, 0, (Object)totalFractionalCycles, 65535);
    }

    public Integer getPlayerScore() {
        return this.getFieldIntegerValue(83, 0, 65535);
    }

    public void setPlayerScore(Integer playerScore) {
        this.setFieldValue(83, 0, (Object)playerScore, 65535);
    }

    public Float[] getAvgTotalHemoglobinConc() {
        return this.getFieldFloatValues(84, 65535);
    }

    public int getNumAvgTotalHemoglobinConc() {
        return this.getNumFieldValues(84, 65535);
    }

    public Float getAvgTotalHemoglobinConc(int index) {
        return this.getFieldFloatValue(84, index, 65535);
    }

    public void setAvgTotalHemoglobinConc(int index, Float avgTotalHemoglobinConc) {
        this.setFieldValue(84, index, (Object)avgTotalHemoglobinConc, 65535);
    }

    public Float[] getMinTotalHemoglobinConc() {
        return this.getFieldFloatValues(85, 65535);
    }

    public int getNumMinTotalHemoglobinConc() {
        return this.getNumFieldValues(85, 65535);
    }

    public Float getMinTotalHemoglobinConc(int index) {
        return this.getFieldFloatValue(85, index, 65535);
    }

    public void setMinTotalHemoglobinConc(int index, Float minTotalHemoglobinConc) {
        this.setFieldValue(85, index, (Object)minTotalHemoglobinConc, 65535);
    }

    public Float[] getMaxTotalHemoglobinConc() {
        return this.getFieldFloatValues(86, 65535);
    }

    public int getNumMaxTotalHemoglobinConc() {
        return this.getNumFieldValues(86, 65535);
    }

    public Float getMaxTotalHemoglobinConc(int index) {
        return this.getFieldFloatValue(86, index, 65535);
    }

    public void setMaxTotalHemoglobinConc(int index, Float maxTotalHemoglobinConc) {
        this.setFieldValue(86, index, (Object)maxTotalHemoglobinConc, 65535);
    }

    public Float[] getAvgSaturatedHemoglobinPercent() {
        return this.getFieldFloatValues(87, 65535);
    }

    public int getNumAvgSaturatedHemoglobinPercent() {
        return this.getNumFieldValues(87, 65535);
    }

    public Float getAvgSaturatedHemoglobinPercent(int index) {
        return this.getFieldFloatValue(87, index, 65535);
    }

    public void setAvgSaturatedHemoglobinPercent(int index, Float avgSaturatedHemoglobinPercent) {
        this.setFieldValue(87, index, (Object)avgSaturatedHemoglobinPercent, 65535);
    }

    public Float[] getMinSaturatedHemoglobinPercent() {
        return this.getFieldFloatValues(88, 65535);
    }

    public int getNumMinSaturatedHemoglobinPercent() {
        return this.getNumFieldValues(88, 65535);
    }

    public Float getMinSaturatedHemoglobinPercent(int index) {
        return this.getFieldFloatValue(88, index, 65535);
    }

    public void setMinSaturatedHemoglobinPercent(int index, Float minSaturatedHemoglobinPercent) {
        this.setFieldValue(88, index, (Object)minSaturatedHemoglobinPercent, 65535);
    }

    public Float[] getMaxSaturatedHemoglobinPercent() {
        return this.getFieldFloatValues(89, 65535);
    }

    public int getNumMaxSaturatedHemoglobinPercent() {
        return this.getNumFieldValues(89, 65535);
    }

    public Float getMaxSaturatedHemoglobinPercent(int index) {
        return this.getFieldFloatValue(89, index, 65535);
    }

    public void setMaxSaturatedHemoglobinPercent(int index, Float maxSaturatedHemoglobinPercent) {
        this.setFieldValue(89, index, (Object)maxSaturatedHemoglobinPercent, 65535);
    }

    public Float getAvgLeftTorqueEffectiveness() {
        return this.getFieldFloatValue(91, 0, 65535);
    }

    public void setAvgLeftTorqueEffectiveness(Float avgLeftTorqueEffectiveness) {
        this.setFieldValue(91, 0, (Object)avgLeftTorqueEffectiveness, 65535);
    }

    public Float getAvgRightTorqueEffectiveness() {
        return this.getFieldFloatValue(92, 0, 65535);
    }

    public void setAvgRightTorqueEffectiveness(Float avgRightTorqueEffectiveness) {
        this.setFieldValue(92, 0, (Object)avgRightTorqueEffectiveness, 65535);
    }

    public Float getAvgLeftPedalSmoothness() {
        return this.getFieldFloatValue(93, 0, 65535);
    }

    public void setAvgLeftPedalSmoothness(Float avgLeftPedalSmoothness) {
        this.setFieldValue(93, 0, (Object)avgLeftPedalSmoothness, 65535);
    }

    public Float getAvgRightPedalSmoothness() {
        return this.getFieldFloatValue(94, 0, 65535);
    }

    public void setAvgRightPedalSmoothness(Float avgRightPedalSmoothness) {
        this.setFieldValue(94, 0, (Object)avgRightPedalSmoothness, 65535);
    }

    public Float getAvgCombinedPedalSmoothness() {
        return this.getFieldFloatValue(95, 0, 65535);
    }

    public void setAvgCombinedPedalSmoothness(Float avgCombinedPedalSmoothness) {
        this.setFieldValue(95, 0, (Object)avgCombinedPedalSmoothness, 65535);
    }

    public Float getTimeStanding() {
        return this.getFieldFloatValue(98, 0, 65535);
    }

    public void setTimeStanding(Float timeStanding) {
        this.setFieldValue(98, 0, (Object)timeStanding, 65535);
    }

    public Integer getStandCount() {
        return this.getFieldIntegerValue(99, 0, 65535);
    }

    public void setStandCount(Integer standCount) {
        this.setFieldValue(99, 0, (Object)standCount, 65535);
    }

    public Byte getAvgLeftPco() {
        return this.getFieldByteValue(100, 0, 65535);
    }

    public void setAvgLeftPco(Byte avgLeftPco) {
        this.setFieldValue(100, 0, (Object)avgLeftPco, 65535);
    }

    public Byte getAvgRightPco() {
        return this.getFieldByteValue(101, 0, 65535);
    }

    public void setAvgRightPco(Byte avgRightPco) {
        this.setFieldValue(101, 0, (Object)avgRightPco, 65535);
    }

    public Float[] getAvgLeftPowerPhase() {
        return this.getFieldFloatValues(102, 65535);
    }

    public int getNumAvgLeftPowerPhase() {
        return this.getNumFieldValues(102, 65535);
    }

    public Float getAvgLeftPowerPhase(int index) {
        return this.getFieldFloatValue(102, index, 65535);
    }

    public void setAvgLeftPowerPhase(int index, Float avgLeftPowerPhase) {
        this.setFieldValue(102, index, (Object)avgLeftPowerPhase, 65535);
    }

    public Float[] getAvgLeftPowerPhasePeak() {
        return this.getFieldFloatValues(103, 65535);
    }

    public int getNumAvgLeftPowerPhasePeak() {
        return this.getNumFieldValues(103, 65535);
    }

    public Float getAvgLeftPowerPhasePeak(int index) {
        return this.getFieldFloatValue(103, index, 65535);
    }

    public void setAvgLeftPowerPhasePeak(int index, Float avgLeftPowerPhasePeak) {
        this.setFieldValue(103, index, (Object)avgLeftPowerPhasePeak, 65535);
    }

    public Float[] getAvgRightPowerPhase() {
        return this.getFieldFloatValues(104, 65535);
    }

    public int getNumAvgRightPowerPhase() {
        return this.getNumFieldValues(104, 65535);
    }

    public Float getAvgRightPowerPhase(int index) {
        return this.getFieldFloatValue(104, index, 65535);
    }

    public void setAvgRightPowerPhase(int index, Float avgRightPowerPhase) {
        this.setFieldValue(104, index, (Object)avgRightPowerPhase, 65535);
    }

    public Float[] getAvgRightPowerPhasePeak() {
        return this.getFieldFloatValues(105, 65535);
    }

    public int getNumAvgRightPowerPhasePeak() {
        return this.getNumFieldValues(105, 65535);
    }

    public Float getAvgRightPowerPhasePeak(int index) {
        return this.getFieldFloatValue(105, index, 65535);
    }

    public void setAvgRightPowerPhasePeak(int index, Float avgRightPowerPhasePeak) {
        this.setFieldValue(105, index, (Object)avgRightPowerPhasePeak, 65535);
    }

    public Integer[] getAvgPowerPosition() {
        return this.getFieldIntegerValues(106, 65535);
    }

    public int getNumAvgPowerPosition() {
        return this.getNumFieldValues(106, 65535);
    }

    public Integer getAvgPowerPosition(int index) {
        return this.getFieldIntegerValue(106, index, 65535);
    }

    public void setAvgPowerPosition(int index, Integer avgPowerPosition) {
        this.setFieldValue(106, index, (Object)avgPowerPosition, 65535);
    }

    public Integer[] getMaxPowerPosition() {
        return this.getFieldIntegerValues(107, 65535);
    }

    public int getNumMaxPowerPosition() {
        return this.getNumFieldValues(107, 65535);
    }

    public Integer getMaxPowerPosition(int index) {
        return this.getFieldIntegerValue(107, index, 65535);
    }

    public void setMaxPowerPosition(int index, Integer maxPowerPosition) {
        this.setFieldValue(107, index, (Object)maxPowerPosition, 65535);
    }

    public Short[] getAvgCadencePosition() {
        return this.getFieldShortValues(108, 65535);
    }

    public int getNumAvgCadencePosition() {
        return this.getNumFieldValues(108, 65535);
    }

    public Short getAvgCadencePosition(int index) {
        return this.getFieldShortValue(108, index, 65535);
    }

    public void setAvgCadencePosition(int index, Short avgCadencePosition) {
        this.setFieldValue(108, index, (Object)avgCadencePosition, 65535);
    }

    public Short[] getMaxCadencePosition() {
        return this.getFieldShortValues(109, 65535);
    }

    public int getNumMaxCadencePosition() {
        return this.getNumFieldValues(109, 65535);
    }

    public Short getMaxCadencePosition(int index) {
        return this.getFieldShortValue(109, index, 65535);
    }

    public void setMaxCadencePosition(int index, Short maxCadencePosition) {
        this.setFieldValue(109, index, (Object)maxCadencePosition, 65535);
    }

    public Float getEnhancedAvgSpeed() {
        return this.getFieldFloatValue(110, 0, 65535);
    }

    public void setEnhancedAvgSpeed(Float enhancedAvgSpeed) {
        this.setFieldValue(110, 0, (Object)enhancedAvgSpeed, 65535);
    }

    public Float getEnhancedMaxSpeed() {
        return this.getFieldFloatValue(111, 0, 65535);
    }

    public void setEnhancedMaxSpeed(Float enhancedMaxSpeed) {
        this.setFieldValue(111, 0, (Object)enhancedMaxSpeed, 65535);
    }

    public Float getEnhancedAvgAltitude() {
        return this.getFieldFloatValue(112, 0, 65535);
    }

    public void setEnhancedAvgAltitude(Float enhancedAvgAltitude) {
        this.setFieldValue(112, 0, (Object)enhancedAvgAltitude, 65535);
    }

    public Float getEnhancedMinAltitude() {
        return this.getFieldFloatValue(113, 0, 65535);
    }

    public void setEnhancedMinAltitude(Float enhancedMinAltitude) {
        this.setFieldValue(113, 0, (Object)enhancedMinAltitude, 65535);
    }

    public Float getEnhancedMaxAltitude() {
        return this.getFieldFloatValue(114, 0, 65535);
    }

    public void setEnhancedMaxAltitude(Float enhancedMaxAltitude) {
        this.setFieldValue(114, 0, (Object)enhancedMaxAltitude, 65535);
    }

    public Integer getAvgLevMotorPower() {
        return this.getFieldIntegerValue(115, 0, 65535);
    }

    public void setAvgLevMotorPower(Integer avgLevMotorPower) {
        this.setFieldValue(115, 0, (Object)avgLevMotorPower, 65535);
    }

    public Integer getMaxLevMotorPower() {
        return this.getFieldIntegerValue(116, 0, 65535);
    }

    public void setMaxLevMotorPower(Integer maxLevMotorPower) {
        this.setFieldValue(116, 0, (Object)maxLevMotorPower, 65535);
    }

    public Float getLevBatteryConsumption() {
        return this.getFieldFloatValue(117, 0, 65535);
    }

    public void setLevBatteryConsumption(Float levBatteryConsumption) {
        this.setFieldValue(117, 0, (Object)levBatteryConsumption, 65535);
    }

    public Float getAvgVerticalRatio() {
        return this.getFieldFloatValue(118, 0, 65535);
    }

    public void setAvgVerticalRatio(Float avgVerticalRatio) {
        this.setFieldValue(118, 0, (Object)avgVerticalRatio, 65535);
    }

    public Float getAvgStanceTimeBalance() {
        return this.getFieldFloatValue(119, 0, 65535);
    }

    public void setAvgStanceTimeBalance(Float avgStanceTimeBalance) {
        this.setFieldValue(119, 0, (Object)avgStanceTimeBalance, 65535);
    }

    public Float getAvgStepLength() {
        return this.getFieldFloatValue(120, 0, 65535);
    }

    public void setAvgStepLength(Float avgStepLength) {
        this.setFieldValue(120, 0, (Object)avgStepLength, 65535);
    }

    public Float getAvgVam() {
        return this.getFieldFloatValue(121, 0, 65535);
    }

    public void setAvgVam(Float avgVam) {
        this.setFieldValue(121, 0, (Object)avgVam, 65535);
    }

    public Float getAvgDepth() {
        return this.getFieldFloatValue(122, 0, 65535);
    }

    public void setAvgDepth(Float avgDepth) {
        this.setFieldValue(122, 0, (Object)avgDepth, 65535);
    }

    public Float getMaxDepth() {
        return this.getFieldFloatValue(123, 0, 65535);
    }

    public void setMaxDepth(Float maxDepth) {
        this.setFieldValue(123, 0, (Object)maxDepth, 65535);
    }

    public Byte getMinTemperature() {
        return this.getFieldByteValue(124, 0, 65535);
    }

    public void setMinTemperature(Byte minTemperature) {
        this.setFieldValue(124, 0, (Object)minTemperature, 65535);
    }

    public Float getEnhancedAvgRespirationRate() {
        return this.getFieldFloatValue(136, 0, 65535);
    }

    public void setEnhancedAvgRespirationRate(Float enhancedAvgRespirationRate) {
        this.setFieldValue(136, 0, (Object)enhancedAvgRespirationRate, 65535);
    }

    public Float getEnhancedMaxRespirationRate() {
        return this.getFieldFloatValue(137, 0, 65535);
    }

    public void setEnhancedMaxRespirationRate(Float enhancedMaxRespirationRate) {
        this.setFieldValue(137, 0, (Object)enhancedMaxRespirationRate, 65535);
    }

    public Short getAvgRespirationRate() {
        return this.getFieldShortValue(147, 0, 65535);
    }

    public void setAvgRespirationRate(Short avgRespirationRate) {
        this.setFieldValue(147, 0, (Object)avgRespirationRate, 65535);
    }

    public Short getMaxRespirationRate() {
        return this.getFieldShortValue(148, 0, 65535);
    }

    public void setMaxRespirationRate(Short maxRespirationRate) {
        this.setFieldValue(148, 0, (Object)maxRespirationRate, 65535);
    }

    public Float getTotalGrit() {
        return this.getFieldFloatValue(149, 0, 65535);
    }

    public void setTotalGrit(Float totalGrit) {
        this.setFieldValue(149, 0, (Object)totalGrit, 65535);
    }

    public Float getTotalFlow() {
        return this.getFieldFloatValue(150, 0, 65535);
    }

    public void setTotalFlow(Float totalFlow) {
        this.setFieldValue(150, 0, (Object)totalFlow, 65535);
    }

    public Integer getJumpCount() {
        return this.getFieldIntegerValue(151, 0, 65535);
    }

    public void setJumpCount(Integer jumpCount) {
        this.setFieldValue(151, 0, (Object)jumpCount, 65535);
    }

    public Float getAvgGrit() {
        return this.getFieldFloatValue(153, 0, 65535);
    }

    public void setAvgGrit(Float avgGrit) {
        this.setFieldValue(153, 0, (Object)avgGrit, 65535);
    }

    public Float getAvgFlow() {
        return this.getFieldFloatValue(154, 0, 65535);
    }

    public void setAvgFlow(Float avgFlow) {
        this.setFieldValue(154, 0, (Object)avgFlow, 65535);
    }

    public Float getTotalFractionalAscent() {
        return this.getFieldFloatValue(156, 0, 65535);
    }

    public void setTotalFractionalAscent(Float totalFractionalAscent) {
        this.setFieldValue(156, 0, (Object)totalFractionalAscent, 65535);
    }

    public Float getTotalFractionalDescent() {
        return this.getFieldFloatValue(157, 0, 65535);
    }

    public void setTotalFractionalDescent(Float totalFractionalDescent) {
        this.setFieldValue(157, 0, (Object)totalFractionalDescent, 65535);
    }

    public Float getAvgCoreTemperature() {
        return this.getFieldFloatValue(158, 0, 65535);
    }

    public void setAvgCoreTemperature(Float avgCoreTemperature) {
        this.setFieldValue(158, 0, (Object)avgCoreTemperature, 65535);
    }

    public Float getMinCoreTemperature() {
        return this.getFieldFloatValue(159, 0, 65535);
    }

    public void setMinCoreTemperature(Float minCoreTemperature) {
        this.setFieldValue(159, 0, (Object)minCoreTemperature, 65535);
    }

    public Float getMaxCoreTemperature() {
        return this.getFieldFloatValue(160, 0, 65535);
    }

    public void setMaxCoreTemperature(Float maxCoreTemperature) {
        this.setFieldValue(160, 0, (Object)maxCoreTemperature, 65535);
    }

    static {
        int field_index = 0;
        int subfield_index = 0;
        lapMesg = new Mesg("lap", 19);
        lapMesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        ++field_index;
        lapMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        ++field_index;
        lapMesg.addField(new Field("event", 0, 0, 1.0, 0.0, "", false, Profile.Type.EVENT));
        ++field_index;
        lapMesg.addField(new Field("event_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.EVENT_TYPE));
        ++field_index;
        lapMesg.addField(new Field("start_time", 2, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        ++field_index;
        lapMesg.addField(new Field("start_position_lat", 3, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        ++field_index;
        lapMesg.addField(new Field("start_position_long", 4, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        ++field_index;
        lapMesg.addField(new Field("end_position_lat", 5, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        ++field_index;
        lapMesg.addField(new Field("end_position_long", 6, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        ++field_index;
        lapMesg.addField(new Field("total_elapsed_time", 7, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("total_timer_time", 8, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("total_distance", 9, 134, 100.0, 0.0, "m", false, Profile.Type.UINT32));
        lapMesg.addField(new Field("total_cycles", 10, 134, 1.0, 0.0, "cycles", false, Profile.Type.UINT32));
        subfield_index = 0;
        LapMesg.lapMesg.fields.get((int)(++field_index)).subFields.add(new SubField("total_strides", 134, 1.0, 0.0, "strides"));
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(25, 1L);
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(25, 11L);
        LapMesg.lapMesg.fields.get((int)field_index).subFields.add(new SubField("total_strokes", 134, 1.0, 0.0, "strokes"));
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(25, 2L);
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(25, 5L);
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(25, 15L);
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(25, 37L);
        ++subfield_index;
        ++field_index;
        lapMesg.addField(new Field("total_calories", 11, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("total_fat_calories", 12, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        lapMesg.addField(new Field("avg_speed", 13, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        LapMesg.lapMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(110, false, 16, 1000.0, 0.0));
        lapMesg.addField(new Field("max_speed", 14, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        LapMesg.lapMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(111, false, 16, 1000.0, 0.0));
        ++field_index;
        lapMesg.addField(new Field("avg_heart_rate", 15, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("max_heart_rate", 16, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        lapMesg.addField(new Field("avg_cadence", 17, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        subfield_index = 0;
        LapMesg.lapMesg.fields.get((int)(++field_index)).subFields.add(new SubField("avg_running_cadence", 2, 1.0, 0.0, "strides/min"));
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(25, 1L);
        ++subfield_index;
        lapMesg.addField(new Field("max_cadence", 18, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        subfield_index = 0;
        LapMesg.lapMesg.fields.get((int)(++field_index)).subFields.add(new SubField("max_running_cadence", 2, 1.0, 0.0, "strides/min"));
        LapMesg.lapMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(25, 1L);
        ++subfield_index;
        ++field_index;
        lapMesg.addField(new Field("avg_power", 19, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("max_power", 20, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("total_ascent", 21, 132, 1.0, 0.0, "m", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("total_descent", 22, 132, 1.0, 0.0, "m", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("intensity", 23, 0, 1.0, 0.0, "", false, Profile.Type.INTENSITY));
        ++field_index;
        lapMesg.addField(new Field("lap_trigger", 24, 0, 1.0, 0.0, "", false, Profile.Type.LAP_TRIGGER));
        ++field_index;
        lapMesg.addField(new Field("sport", 25, 0, 1.0, 0.0, "", false, Profile.Type.SPORT));
        ++field_index;
        lapMesg.addField(new Field("event_group", 26, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("num_lengths", 32, 132, 1.0, 0.0, "lengths", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("normalized_power", 33, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("left_right_balance", 34, 132, 1.0, 0.0, "", false, Profile.Type.LEFT_RIGHT_BALANCE_100));
        ++field_index;
        lapMesg.addField(new Field("first_length_index", 35, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_stroke_distance", 37, 132, 100.0, 0.0, "m", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("swim_stroke", 38, 0, 1.0, 0.0, "", false, Profile.Type.SWIM_STROKE));
        ++field_index;
        lapMesg.addField(new Field("sub_sport", 39, 0, 1.0, 0.0, "", false, Profile.Type.SUB_SPORT));
        ++field_index;
        lapMesg.addField(new Field("num_active_lengths", 40, 132, 1.0, 0.0, "lengths", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("total_work", 41, 134, 1.0, 0.0, "J", false, Profile.Type.UINT32));
        lapMesg.addField(new Field("avg_altitude", 42, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        LapMesg.lapMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(112, false, 16, 5.0, 500.0));
        lapMesg.addField(new Field("max_altitude", 43, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        LapMesg.lapMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(114, false, 16, 5.0, 500.0));
        ++field_index;
        lapMesg.addField(new Field("gps_accuracy", 44, 2, 1.0, 0.0, "m", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_grade", 45, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_pos_grade", 46, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_neg_grade", 47, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("max_pos_grade", 48, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("max_neg_grade", 49, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_temperature", 50, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        ++field_index;
        lapMesg.addField(new Field("max_temperature", 51, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        ++field_index;
        lapMesg.addField(new Field("total_moving_time", 52, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("avg_pos_vertical_speed", 53, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_neg_vertical_speed", 54, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("max_pos_vertical_speed", 55, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("max_neg_vertical_speed", 56, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        ++field_index;
        lapMesg.addField(new Field("time_in_hr_zone", 57, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("time_in_speed_zone", 58, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("time_in_cadence_zone", 59, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("time_in_power_zone", 60, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("repetition_num", 61, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        lapMesg.addField(new Field("min_altitude", 62, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        LapMesg.lapMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(113, false, 16, 5.0, 500.0));
        ++field_index;
        lapMesg.addField(new Field("min_heart_rate", 63, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("wkt_step_index", 71, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        ++field_index;
        lapMesg.addField(new Field("opponent_score", 74, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("stroke_count", 75, 132, 1.0, 0.0, "counts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("zone_count", 76, 132, 1.0, 0.0, "counts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_vertical_oscillation", 77, 132, 10.0, 0.0, "mm", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_stance_time_percent", 78, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_stance_time", 79, 132, 10.0, 0.0, "ms", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_fractional_cadence", 80, 2, 128.0, 0.0, "rpm", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("max_fractional_cadence", 81, 2, 128.0, 0.0, "rpm", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("total_fractional_cycles", 82, 2, 128.0, 0.0, "cycles", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("player_score", 83, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_total_hemoglobin_conc", 84, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("min_total_hemoglobin_conc", 85, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("max_total_hemoglobin_conc", 86, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_saturated_hemoglobin_percent", 87, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("min_saturated_hemoglobin_percent", 88, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("max_saturated_hemoglobin_percent", 89, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_left_torque_effectiveness", 91, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_right_torque_effectiveness", 92, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_left_pedal_smoothness", 93, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_right_pedal_smoothness", 94, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_combined_pedal_smoothness", 95, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("time_standing", 98, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("stand_count", 99, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_left_pco", 100, 1, 1.0, 0.0, "mm", false, Profile.Type.SINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_right_pco", 101, 1, 1.0, 0.0, "mm", false, Profile.Type.SINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_left_power_phase", 102, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_left_power_phase_peak", 103, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_right_power_phase", 104, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_right_power_phase_peak", 105, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_power_position", 106, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("max_power_position", 107, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_cadence_position", 108, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("max_cadence_position", 109, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("enhanced_avg_speed", 110, 134, 1000.0, 0.0, "m/s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("enhanced_max_speed", 111, 134, 1000.0, 0.0, "m/s", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("enhanced_avg_altitude", 112, 134, 5.0, 500.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("enhanced_min_altitude", 113, 134, 5.0, 500.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("enhanced_max_altitude", 114, 134, 5.0, 500.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("avg_lev_motor_power", 115, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("max_lev_motor_power", 116, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("lev_battery_consumption", 117, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_vertical_ratio", 118, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_stance_time_balance", 119, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_step_length", 120, 132, 10.0, 0.0, "mm", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_vam", 121, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_depth", 122, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("max_depth", 123, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        lapMesg.addField(new Field("min_temperature", 124, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        ++field_index;
        lapMesg.addField(new Field("enhanced_avg_respiration_rate", 136, 132, 100.0, 0.0, "Breaths/min", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("enhanced_max_respiration_rate", 137, 132, 100.0, 0.0, "Breaths/min", false, Profile.Type.UINT16));
        lapMesg.addField(new Field("avg_respiration_rate", 147, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        LapMesg.lapMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(136, false, 8, 1.0, 0.0));
        lapMesg.addField(new Field("max_respiration_rate", 148, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        LapMesg.lapMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(137, false, 8, 1.0, 0.0));
        ++field_index;
        lapMesg.addField(new Field("total_grit", 149, 136, 1.0, 0.0, "kGrit", false, Profile.Type.FLOAT32));
        ++field_index;
        lapMesg.addField(new Field("total_flow", 150, 136, 1.0, 0.0, "Flow", false, Profile.Type.FLOAT32));
        ++field_index;
        lapMesg.addField(new Field("jump_count", 151, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("avg_grit", 153, 136, 1.0, 0.0, "kGrit", false, Profile.Type.FLOAT32));
        ++field_index;
        lapMesg.addField(new Field("avg_flow", 154, 136, 1.0, 0.0, "Flow", false, Profile.Type.FLOAT32));
        ++field_index;
        lapMesg.addField(new Field("total_fractional_ascent", 156, 2, 100.0, 0.0, "m", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("total_fractional_descent", 157, 2, 100.0, 0.0, "m", false, Profile.Type.UINT8));
        ++field_index;
        lapMesg.addField(new Field("avg_core_temperature", 158, 132, 100.0, 0.0, "C", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("min_core_temperature", 159, 132, 100.0, 0.0, "C", false, Profile.Type.UINT16));
        ++field_index;
        lapMesg.addField(new Field("max_core_temperature", 160, 132, 100.0, 0.0, "C", false, Profile.Type.UINT16));
        ++field_index;
    }
}

