/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.LengthType;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.Profile;
import com.garmin.fit.SwimStroke;

public class LengthMesg
extends Mesg
implements MesgWithEvent {
    public static final int MessageIndexFieldNum = 254;
    public static final int TimestampFieldNum = 253;
    public static final int EventFieldNum = 0;
    public static final int EventTypeFieldNum = 1;
    public static final int StartTimeFieldNum = 2;
    public static final int TotalElapsedTimeFieldNum = 3;
    public static final int TotalTimerTimeFieldNum = 4;
    public static final int TotalStrokesFieldNum = 5;
    public static final int AvgSpeedFieldNum = 6;
    public static final int SwimStrokeFieldNum = 7;
    public static final int AvgSwimmingCadenceFieldNum = 9;
    public static final int EventGroupFieldNum = 10;
    public static final int TotalCaloriesFieldNum = 11;
    public static final int LengthTypeFieldNum = 12;
    public static final int PlayerScoreFieldNum = 18;
    public static final int OpponentScoreFieldNum = 19;
    public static final int StrokeCountFieldNum = 20;
    public static final int ZoneCountFieldNum = 21;
    public static final int EnhancedAvgRespirationRateFieldNum = 22;
    public static final int EnhancedMaxRespirationRateFieldNum = 23;
    public static final int AvgRespirationRateFieldNum = 24;
    public static final int MaxRespirationRateFieldNum = 25;
    protected static final Mesg lengthMesg;

    public LengthMesg() {
        super(Factory.createMesg(101));
    }

    public LengthMesg(Mesg mesg) {
        super(mesg);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public void setMessageIndex(Integer messageIndex) {
        this.setFieldValue(254, 0, (Object)messageIndex, 65535);
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    @Override
    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    @Override
    public Event getEvent() {
        Short value = this.getFieldShortValue(0, 0, 65535);
        if (value == null) {
            return null;
        }
        return Event.getByValue(value);
    }

    @Override
    public void setEvent(Event event) {
        this.setFieldValue(0, 0, (Object)event.value, 65535);
    }

    @Override
    public EventType getEventType() {
        Short value = this.getFieldShortValue(1, 0, 65535);
        if (value == null) {
            return null;
        }
        return EventType.getByValue(value);
    }

    @Override
    public void setEventType(EventType eventType) {
        this.setFieldValue(1, 0, (Object)eventType.value, 65535);
    }

    public DateTime getStartTime() {
        return this.timestampToDateTime(this.getFieldLongValue(2, 0, 65535));
    }

    public void setStartTime(DateTime startTime) {
        this.setFieldValue(2, 0, (Object)startTime.getTimestamp(), 65535);
    }

    public Float getTotalElapsedTime() {
        return this.getFieldFloatValue(3, 0, 65535);
    }

    public void setTotalElapsedTime(Float totalElapsedTime) {
        this.setFieldValue(3, 0, (Object)totalElapsedTime, 65535);
    }

    public Float getTotalTimerTime() {
        return this.getFieldFloatValue(4, 0, 65535);
    }

    public void setTotalTimerTime(Float totalTimerTime) {
        this.setFieldValue(4, 0, (Object)totalTimerTime, 65535);
    }

    public Integer getTotalStrokes() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public void setTotalStrokes(Integer totalStrokes) {
        this.setFieldValue(5, 0, (Object)totalStrokes, 65535);
    }

    public Float getAvgSpeed() {
        return this.getFieldFloatValue(6, 0, 65535);
    }

    public void setAvgSpeed(Float avgSpeed) {
        this.setFieldValue(6, 0, (Object)avgSpeed, 65535);
    }

    public SwimStroke getSwimStroke() {
        Short value = this.getFieldShortValue(7, 0, 65535);
        if (value == null) {
            return null;
        }
        return SwimStroke.getByValue(value);
    }

    public void setSwimStroke(SwimStroke swimStroke) {
        this.setFieldValue(7, 0, (Object)swimStroke.value, 65535);
    }

    public Short getAvgSwimmingCadence() {
        return this.getFieldShortValue(9, 0, 65535);
    }

    public void setAvgSwimmingCadence(Short avgSwimmingCadence) {
        this.setFieldValue(9, 0, (Object)avgSwimmingCadence, 65535);
    }

    @Override
    public Short getEventGroup() {
        return this.getFieldShortValue(10, 0, 65535);
    }

    @Override
    public void setEventGroup(Short eventGroup) {
        this.setFieldValue(10, 0, (Object)eventGroup, 65535);
    }

    public Integer getTotalCalories() {
        return this.getFieldIntegerValue(11, 0, 65535);
    }

    public void setTotalCalories(Integer totalCalories) {
        this.setFieldValue(11, 0, (Object)totalCalories, 65535);
    }

    public LengthType getLengthType() {
        Short value = this.getFieldShortValue(12, 0, 65535);
        if (value == null) {
            return null;
        }
        return LengthType.getByValue(value);
    }

    public void setLengthType(LengthType lengthType) {
        this.setFieldValue(12, 0, (Object)lengthType.value, 65535);
    }

    public Integer getPlayerScore() {
        return this.getFieldIntegerValue(18, 0, 65535);
    }

    public void setPlayerScore(Integer playerScore) {
        this.setFieldValue(18, 0, (Object)playerScore, 65535);
    }

    public Integer getOpponentScore() {
        return this.getFieldIntegerValue(19, 0, 65535);
    }

    public void setOpponentScore(Integer opponentScore) {
        this.setFieldValue(19, 0, (Object)opponentScore, 65535);
    }

    public Integer[] getStrokeCount() {
        return this.getFieldIntegerValues(20, 65535);
    }

    public int getNumStrokeCount() {
        return this.getNumFieldValues(20, 65535);
    }

    public Integer getStrokeCount(int index) {
        return this.getFieldIntegerValue(20, index, 65535);
    }

    public void setStrokeCount(int index, Integer strokeCount) {
        this.setFieldValue(20, index, (Object)strokeCount, 65535);
    }

    public Integer[] getZoneCount() {
        return this.getFieldIntegerValues(21, 65535);
    }

    public int getNumZoneCount() {
        return this.getNumFieldValues(21, 65535);
    }

    public Integer getZoneCount(int index) {
        return this.getFieldIntegerValue(21, index, 65535);
    }

    public void setZoneCount(int index, Integer zoneCount) {
        this.setFieldValue(21, index, (Object)zoneCount, 65535);
    }

    public Float getEnhancedAvgRespirationRate() {
        return this.getFieldFloatValue(22, 0, 65535);
    }

    public void setEnhancedAvgRespirationRate(Float enhancedAvgRespirationRate) {
        this.setFieldValue(22, 0, (Object)enhancedAvgRespirationRate, 65535);
    }

    public Float getEnhancedMaxRespirationRate() {
        return this.getFieldFloatValue(23, 0, 65535);
    }

    public void setEnhancedMaxRespirationRate(Float enhancedMaxRespirationRate) {
        this.setFieldValue(23, 0, (Object)enhancedMaxRespirationRate, 65535);
    }

    public Short getAvgRespirationRate() {
        return this.getFieldShortValue(24, 0, 65535);
    }

    public void setAvgRespirationRate(Short avgRespirationRate) {
        this.setFieldValue(24, 0, (Object)avgRespirationRate, 65535);
    }

    public Short getMaxRespirationRate() {
        return this.getFieldShortValue(25, 0, 65535);
    }

    public void setMaxRespirationRate(Short maxRespirationRate) {
        this.setFieldValue(25, 0, (Object)maxRespirationRate, 65535);
    }

    static {
        int field_index = 0;
        lengthMesg = new Mesg("length", 101);
        lengthMesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        ++field_index;
        lengthMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        ++field_index;
        lengthMesg.addField(new Field("event", 0, 0, 1.0, 0.0, "", false, Profile.Type.EVENT));
        ++field_index;
        lengthMesg.addField(new Field("event_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.EVENT_TYPE));
        ++field_index;
        lengthMesg.addField(new Field("start_time", 2, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        ++field_index;
        lengthMesg.addField(new Field("total_elapsed_time", 3, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lengthMesg.addField(new Field("total_timer_time", 4, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        lengthMesg.addField(new Field("total_strokes", 5, 132, 1.0, 0.0, "strokes", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("avg_speed", 6, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("swim_stroke", 7, 0, 1.0, 0.0, "swim_stroke", false, Profile.Type.SWIM_STROKE));
        ++field_index;
        lengthMesg.addField(new Field("avg_swimming_cadence", 9, 2, 1.0, 0.0, "strokes/min", false, Profile.Type.UINT8));
        ++field_index;
        lengthMesg.addField(new Field("event_group", 10, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++field_index;
        lengthMesg.addField(new Field("total_calories", 11, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("length_type", 12, 0, 1.0, 0.0, "", false, Profile.Type.LENGTH_TYPE));
        ++field_index;
        lengthMesg.addField(new Field("player_score", 18, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("opponent_score", 19, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("stroke_count", 20, 132, 1.0, 0.0, "counts", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("zone_count", 21, 132, 1.0, 0.0, "counts", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("enhanced_avg_respiration_rate", 22, 132, 100.0, 0.0, "Breaths/min", false, Profile.Type.UINT16));
        ++field_index;
        lengthMesg.addField(new Field("enhanced_max_respiration_rate", 23, 132, 100.0, 0.0, "Breaths/min", false, Profile.Type.UINT16));
        lengthMesg.addField(new Field("avg_respiration_rate", 24, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        LengthMesg.lengthMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(22, false, 8, 1.0, 0.0));
        lengthMesg.addField(new Field("max_respiration_rate", 25, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        LengthMesg.lengthMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(23, false, 8, 1.0, 0.0));
        ++field_index;
    }
}

