/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Fit;
import java.util.HashMap;
import java.util.Map;

public class LocalDeviceType {
    public static final short GPS = 0;
    public static final short GLONASS = 1;
    public static final short GPS_GLONASS = 2;
    public static final short ACCELEROMETER = 3;
    public static final short BAROMETER = 4;
    public static final short TEMPERATURE = 5;
    public static final short WHR = 10;
    public static final short SENSOR_HUB = 12;
    public static final short INVALID = Fit.UINT8_INVALID;
    private static final Map<Short, String> stringMap = new HashMap<Short, String>();

    public static String getStringFromValue(Short value) {
        if (stringMap.containsKey(value)) {
            return stringMap.get(value);
        }
        return "";
    }

    public static Short getValueFromString(String value) {
        for (Map.Entry<Short, String> entry : stringMap.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return INVALID;
    }

    static {
        stringMap.put((short)0, "GPS");
        stringMap.put((short)1, "GLONASS");
        stringMap.put((short)2, "GPS_GLONASS");
        stringMap.put((short)3, "ACCELEROMETER");
        stringMap.put((short)4, "BAROMETER");
        stringMap.put((short)5, "TEMPERATURE");
        stringMap.put((short)10, "WHR");
        stringMap.put((short)12, "SENSOR_HUB");
    }
}

