/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Bool;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.MaxMetCategory;
import com.garmin.fit.MaxMetHeartRateSource;
import com.garmin.fit.MaxMetSpeedSource;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.Sport;
import com.garmin.fit.SubSport;

public class MaxMetDataMesg
extends Mesg {
    public static final int UpdateTimeFieldNum = 0;
    public static final int Vo2MaxFieldNum = 2;
    public static final int SportFieldNum = 5;
    public static final int SubSportFieldNum = 6;
    public static final int MaxMetCategoryFieldNum = 8;
    public static final int CalibratedDataFieldNum = 9;
    public static final int HrSourceFieldNum = 12;
    public static final int SpeedSourceFieldNum = 13;
    protected static final Mesg maxMetDataMesg = new Mesg("max_met_data", 229);

    public MaxMetDataMesg() {
        super(Factory.createMesg(229));
    }

    public MaxMetDataMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getUpdateTime() {
        return this.timestampToDateTime(this.getFieldLongValue(0, 0, 65535));
    }

    public void setUpdateTime(DateTime updateTime) {
        this.setFieldValue(0, 0, (Object)updateTime.getTimestamp(), 65535);
    }

    public Float getVo2Max() {
        return this.getFieldFloatValue(2, 0, 65535);
    }

    public void setVo2Max(Float vo2Max) {
        this.setFieldValue(2, 0, (Object)vo2Max, 65535);
    }

    public Sport getSport() {
        Short value = this.getFieldShortValue(5, 0, 65535);
        if (value == null) {
            return null;
        }
        return Sport.getByValue(value);
    }

    public void setSport(Sport sport) {
        this.setFieldValue(5, 0, (Object)sport.value, 65535);
    }

    public SubSport getSubSport() {
        Short value = this.getFieldShortValue(6, 0, 65535);
        if (value == null) {
            return null;
        }
        return SubSport.getByValue(value);
    }

    public void setSubSport(SubSport subSport) {
        this.setFieldValue(6, 0, (Object)subSport.value, 65535);
    }

    public MaxMetCategory getMaxMetCategory() {
        Short value = this.getFieldShortValue(8, 0, 65535);
        if (value == null) {
            return null;
        }
        return MaxMetCategory.getByValue(value);
    }

    public void setMaxMetCategory(MaxMetCategory maxMetCategory) {
        this.setFieldValue(8, 0, (Object)maxMetCategory.value, 65535);
    }

    public Bool getCalibratedData() {
        Short value = this.getFieldShortValue(9, 0, 65535);
        if (value == null) {
            return null;
        }
        return Bool.getByValue(value);
    }

    public void setCalibratedData(Bool calibratedData) {
        this.setFieldValue(9, 0, (Object)calibratedData.value, 65535);
    }

    public MaxMetHeartRateSource getHrSource() {
        Short value = this.getFieldShortValue(12, 0, 65535);
        if (value == null) {
            return null;
        }
        return MaxMetHeartRateSource.getByValue(value);
    }

    public void setHrSource(MaxMetHeartRateSource hrSource) {
        this.setFieldValue(12, 0, (Object)hrSource.value, 65535);
    }

    public MaxMetSpeedSource getSpeedSource() {
        Short value = this.getFieldShortValue(13, 0, 65535);
        if (value == null) {
            return null;
        }
        return MaxMetSpeedSource.getByValue(value);
    }

    public void setSpeedSource(MaxMetSpeedSource speedSource) {
        this.setFieldValue(13, 0, (Object)speedSource.value, 65535);
    }

    static {
        maxMetDataMesg.addField(new Field("update_time", 0, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        maxMetDataMesg.addField(new Field("vo2_max", 2, 132, 10.0, 0.0, "mL/kg/min", false, Profile.Type.UINT16));
        maxMetDataMesg.addField(new Field("sport", 5, 0, 1.0, 0.0, "", false, Profile.Type.SPORT));
        maxMetDataMesg.addField(new Field("sub_sport", 6, 0, 1.0, 0.0, "", false, Profile.Type.SUB_SPORT));
        maxMetDataMesg.addField(new Field("max_met_category", 8, 0, 1.0, 0.0, "", false, Profile.Type.MAX_MET_CATEGORY));
        maxMetDataMesg.addField(new Field("calibrated_data", 9, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        maxMetDataMesg.addField(new Field("hr_source", 12, 0, 1.0, 0.0, "", false, Profile.Type.MAX_MET_HEART_RATE_SOURCE));
        maxMetDataMesg.addField(new Field("speed_source", 13, 0, 1.0, 0.0, "", false, Profile.Type.MAX_MET_SPEED_SOURCE));
    }
}

