/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgNum;
import com.garmin.fit.SubField;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class Mesg {
    protected String name;
    protected int num;
    protected int localNum;
    protected ArrayList<Field> fields;
    protected ArrayList<DeveloperField> developerFields;
    protected long systemTimeOffset;
    private int decoderMesgIndex;

    public Mesg(Mesg mesg) {
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
        if (mesg == null) {
            this.name = "unknown";
            this.num = MesgNum.INVALID;
            this.systemTimeOffset = 0L;
            return;
        }
        this.name = mesg.name;
        this.num = mesg.num;
        this.localNum = mesg.localNum;
        this.systemTimeOffset = mesg.systemTimeOffset;
        this.decoderMesgIndex = mesg.decoderMesgIndex;
        for (Field field : mesg.fields) {
            if (field.getNumValues() <= 0) continue;
            this.fields.add(new Field(field));
        }
        for (DeveloperField developerField : mesg.developerFields) {
            if (developerField.getNumValues() <= 0) continue;
            this.developerFields.add(new DeveloperField(developerField));
        }
    }

    protected Mesg(String name, int num) {
        this.name = name;
        this.num = num;
        this.localNum = 0;
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
        this.systemTimeOffset = 0L;
    }

    public void removeExpandedFields() {
        ArrayList<Field> fieldsToRemove = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (!field.getIsExpanded()) continue;
            fieldsToRemove.add(field);
        }
        this.fields.removeAll(fieldsToRemove);
    }

    public void write(OutputStream out) {
        this.write(out, null);
    }

    public void write(OutputStream out, MesgDefinition mesgDef) {
        FieldBase field;
        try {
            int headerByte = this.localNum & 0xF;
            new DataOutputStream(out).writeByte(headerByte);
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
        if (mesgDef == null) {
            mesgDef = new MesgDefinition(this);
        }
        for (FieldDefinition fieldDefinition : mesgDef.fields) {
            field = this.getField(fieldDefinition.num);
            if (field == null) {
                field = Factory.createField(this.num, fieldDefinition.num);
            }
            field.write(out, fieldDefinition);
        }
        for (DeveloperFieldDefinition developerFieldDefinition : mesgDef.developerFields) {
            field = this.getDeveloperField(developerFieldDefinition.getDeveloperDataIndex(), developerFieldDefinition.getNum());
            if (field == null) {
                field = developerFieldDefinition.getDefaultField();
            }
            field.write(out, developerFieldDefinition);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getNum() {
        return this.num;
    }

    public boolean hasField(int num) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != num) continue;
            return true;
        }
        return false;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void addDeveloperField(DeveloperField field) {
        for (int i = 0; i < this.developerFields.size(); ++i) {
            DeveloperField fieldToCompare = this.developerFields.get(i);
            if (fieldToCompare.getNum() != field.getNum() || fieldToCompare.getDeveloperDataIndex() != field.getDeveloperDataIndex()) continue;
            this.developerFields.set(i, field);
            return;
        }
        this.developerFields.add(field);
    }

    public void setField(Field field) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != field.num) continue;
            this.fields.set(i, field);
            return;
        }
        this.fields.add(field);
    }

    public int getNumFields() {
        return this.fields.size();
    }

    private DeveloperField getDeveloperField(short developerIndex, int num) {
        for (DeveloperField field : this.developerFields) {
            if (field.getDeveloperDataIndex() != developerIndex || field.getNum() != num) continue;
            return field;
        }
        return null;
    }

    public Field getField(int num) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != num) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public Field getField(String name) {
        return this.getField(name, true);
    }

    public Field getField(String name, boolean checkMesgSupportForSubFields) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).name.equals(name)) {
                return this.fields.get(i);
            }
            for (int j = 0; j < this.fields.get((int)i).subFields.size(); ++j) {
                if (!this.fields.get((int)i).subFields.get((int)j).name.equals(name) || checkMesgSupportForSubFields && !this.fields.get((int)i).subFields.get(j).canMesgSupport(this)) continue;
                return this.fields.get(i);
            }
        }
        return null;
    }

    public int getActiveSubFieldIndex(int num) {
        Field testField = Factory.createField(this.num, num);
        if (testField == null) {
            return 65535;
        }
        for (int i = 0; i < testField.subFields.size(); ++i) {
            if (!testField.subFields.get(i).canMesgSupport(this)) continue;
            return i;
        }
        return 65535;
    }

    public String getActiveSubFieldName(int num) {
        Field testField = Factory.createField(this.num, num);
        if (testField == null) {
            return Fit.SUBFIELD_NAME_MAIN_FIELD;
        }
        for (int i = 0; i < testField.subFields.size(); ++i) {
            if (!testField.subFields.get(i).canMesgSupport(this)) continue;
            return testField.subFields.get(i).getName();
        }
        return Fit.SUBFIELD_NAME_MAIN_FIELD;
    }

    public int getNumFieldValues(int num) {
        return this.getNumFieldValues(num, 65534);
    }

    public int getNumFieldValues(int num, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return 0;
        }
        if (subFieldIndex == 65534) {
            return field.getNumValues();
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getNumValues();
        }
        return 0;
    }

    public int getNumFieldValues(int num, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return 0;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getNumValues();
        }
        return 0;
    }

    public int getNumFieldValues(String name) {
        Field field = this.getField(name, false);
        if (field == null) {
            return 0;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getNumValues();
        }
        return 0;
    }

    public Object getFieldValue(int num) {
        return this.getFieldValue(num, 0, 65534);
    }

    public Object getFieldValue(int num, int fieldArrayIndex) {
        return this.getFieldValue(num, fieldArrayIndex, 65534);
    }

    public Object getFieldValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public Object getFieldValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public Object getFieldValue(String name) {
        return this.getFieldValue(name, 0);
    }

    public Object getFieldValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getValue(fieldArrayIndex, name);
        }
        return null;
    }

    public boolean getIsFieldAccumulated(int num) {
        Field field = this.getField(num);
        if (field != null) {
            return field.getIsAccumulated();
        }
        return false;
    }

    public void setFieldValue(int num, Object value) {
        this.setFieldValue(num, 0, value, 65535);
    }

    public void setFieldValue(int num, int fieldArrayIndex, Object value) {
        this.setFieldValue(num, fieldArrayIndex, value, 65535);
    }

    public void setFieldValue(int num, int fieldArrayIndex, Object value, int subFieldIndex) {
        Field field;
        if (subFieldIndex == 65534) {
            subFieldIndex = this.getActiveSubFieldIndex(num);
        }
        if ((field = this.getField(num)) == null) {
            field = Factory.createField(this.num, num);
            this.addField(field);
        }
        field.setValue(fieldArrayIndex, value, subFieldIndex);
    }

    public void setFieldValue(int num, int fieldArrayIndex, Object value, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            field = Factory.createField(this.num, num);
            this.addField(field);
        }
        field.setValue(fieldArrayIndex, value, subFieldName);
    }

    public void setFieldValue(String name, Object value) {
        this.setFieldValue(name, 0, value);
    }

    public void setFieldValue(String name, int fieldArrayIndex, Object value) {
        Field field = this.getField(name, false);
        if (field == null) {
            field = Factory.createField(this.num, name);
            this.addField(field);
        }
        field.setValue(fieldArrayIndex, value, name);
    }

    public Long getFieldBitsValue(int num, int offset, int bits, boolean signed) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        return field.getBitsValue(offset, bits, signed);
    }

    public Long getFieldBitsValue(String name, int offset, int bits, boolean signed) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getBitsValue(offset, bits, signed);
        }
        return null;
    }

    public Byte[] getFieldByteValues(int num) {
        return this.getFieldByteValues(num, 65534);
    }

    public Byte[] getFieldByteValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValues(subfieldIndex);
        }
        return null;
    }

    public Byte[] getFieldByteValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValues(subfieldName);
        }
        return null;
    }

    public Byte getFieldByteValue(int num) {
        return this.getFieldByteValue(num, 0, 65534);
    }

    public Byte getFieldByteValue(int num, int fieldArrayIndex) {
        return this.getFieldByteValue(num, fieldArrayIndex, 65534);
    }

    public Byte getFieldByteValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getByteValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public Byte getFieldByteValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public Byte getFieldByteValue(String name) {
        return this.getFieldByteValue(name, 0);
    }

    public Byte getFieldByteValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValue(fieldArrayIndex, name);
        }
        return null;
    }

    public Short[] getFieldShortValues(int num) {
        return this.getFieldShortValues(num, 65534);
    }

    public Short[] getFieldShortValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValues(subfieldIndex);
        }
        return null;
    }

    public Short[] getFieldShortValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValues(subfieldName);
        }
        return null;
    }

    public Short getFieldShortValue(int num) {
        return this.getFieldShortValue(num, 0, 65534);
    }

    public Short getFieldShortValue(int num, int fieldArrayIndex) {
        return this.getFieldShortValue(num, fieldArrayIndex, 65534);
    }

    public Short getFieldShortValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getShortValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public Short getFieldShortValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public Short getFieldShortValue(String name) {
        return this.getFieldShortValue(name, 0);
    }

    public Short getFieldShortValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValue(fieldArrayIndex, name);
        }
        return null;
    }

    public Integer[] getFieldIntegerValues(int num) {
        return this.getFieldIntegerValues(num, 65534);
    }

    public Integer[] getFieldIntegerValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValues(subfieldIndex);
        }
        return null;
    }

    public Integer[] getFieldIntegerValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValues(subfieldName);
        }
        return null;
    }

    public Integer getFieldIntegerValue(int num) {
        return this.getFieldIntegerValue(num, 0, 65534);
    }

    public Integer getFieldIntegerValue(int num, int fieldArrayIndex) {
        return this.getFieldIntegerValue(num, fieldArrayIndex, 65534);
    }

    public Integer getFieldIntegerValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getIntegerValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public Integer getFieldIntegerValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public Integer getFieldIntegerValue(String name) {
        return this.getFieldIntegerValue(name, 0);
    }

    public Integer getFieldIntegerValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValue(fieldArrayIndex, name);
        }
        return null;
    }

    public Long[] getFieldLongValues(int num) {
        return this.getFieldLongValues(num, 65534);
    }

    public Long[] getFieldLongValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValues(subfieldIndex);
        }
        return null;
    }

    public Long[] getFieldLongValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValues(subfieldName);
        }
        return null;
    }

    public Long getFieldLongValue(int num) {
        return this.getFieldLongValue(num, 0, 65534);
    }

    public Long getFieldLongValue(int num, int fieldArrayIndex) {
        return this.getFieldLongValue(num, fieldArrayIndex, 65534);
    }

    public Long getFieldLongValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getLongValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public Long getFieldLongValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public Long getFieldLongValue(String name) {
        return this.getFieldLongValue(name, 0);
    }

    public Long getFieldLongValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValue(fieldArrayIndex, name);
        }
        return null;
    }

    public Float[] getFieldFloatValues(int num) {
        return this.getFieldFloatValues(num, 65534);
    }

    public Float[] getFieldFloatValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValues(subfieldIndex);
        }
        return null;
    }

    public Float[] getFieldFloatValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValues(subfieldName);
        }
        return null;
    }

    public Float getFieldFloatValue(int num) {
        return this.getFieldFloatValue(num, 0, 65534);
    }

    public Float getFieldFloatValue(int num, int fieldArrayIndex) {
        return this.getFieldFloatValue(num, fieldArrayIndex, 65534);
    }

    public Float getFieldFloatValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getFloatValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public Float getFieldFloatValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public Float getFieldFloatValue(String name) {
        return this.getFieldFloatValue(name, 0);
    }

    public Float getFieldFloatValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValue(fieldArrayIndex, name);
        }
        return null;
    }

    public Double[] getFieldDoubleValues(int num) {
        return this.getFieldDoubleValues(num, 65534);
    }

    public Double[] getFieldDoubleValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValues(subfieldIndex);
        }
        return null;
    }

    public Double[] getFieldDoubleValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValues(subfieldName);
        }
        return null;
    }

    public Double getFieldDoubleValue(int num) {
        return this.getFieldDoubleValue(num, 0, 65534);
    }

    public Double getFieldDoubleValue(int num, int fieldArrayIndex) {
        return this.getFieldDoubleValue(num, fieldArrayIndex, 65534);
    }

    public Double getFieldDoubleValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getDoubleValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public Double getFieldDoubleValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public Double getFieldDoubleValue(String name) {
        return this.getFieldDoubleValue(name, 0);
    }

    public Double getFieldDoubleValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValue(fieldArrayIndex, name);
        }
        return null;
    }

    public String[] getFieldStringValues(int num) {
        return this.getFieldStringValues(num, 65534);
    }

    public String[] getFieldStringValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValues(subfieldIndex);
        }
        return null;
    }

    public String[] getFieldStringValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValues(subfieldName);
        }
        return null;
    }

    public String getFieldStringValue(int num) {
        return this.getFieldStringValue(num, 0, 65534);
    }

    public String getFieldStringValue(int num, int fieldArrayIndex) {
        return this.getFieldStringValue(num, fieldArrayIndex, 65534);
    }

    public String getFieldStringValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getStringValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public String getFieldStringValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public String getFieldStringValue(String name) {
        return this.getFieldStringValue(name, 0);
    }

    public String getFieldStringValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValue(fieldArrayIndex, name);
        }
        return null;
    }

    public BigInteger[] getFieldBigIntegerValues(int num) {
        return this.getFieldBigIntegerValues(num, 65534);
    }

    public BigInteger[] getFieldBigIntegerValues(int num, int subfieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getBigIntegerValues(subfieldIndex);
        }
        return null;
    }

    public BigInteger[] getFieldBigIntegerValues(int num, String subfieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subfieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getBigIntegerValues(subfieldName);
        }
        return null;
    }

    public BigInteger getFieldBigIntegerValue(int num) {
        return this.getFieldBigIntegerValue(num, 0, 65534);
    }

    public BigInteger getFieldBigIntegerValue(int num, int fieldArrayIndex) {
        return this.getFieldBigIntegerValue(num, fieldArrayIndex, 65534);
    }

    public BigInteger getFieldBigIntegerValue(int num, int fieldArrayIndex, int subFieldIndex) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        if (subFieldIndex == 65534) {
            return field.getBigIntegerValue(fieldArrayIndex, this.getActiveSubFieldIndex(num));
        }
        SubField subField = field.getSubField(subFieldIndex);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getBigIntegerValue(fieldArrayIndex, subFieldIndex);
        }
        return null;
    }

    public BigInteger getFieldBigIntegerValue(int num, int fieldArrayIndex, String subFieldName) {
        Field field = this.getField(num);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(subFieldName);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getBigIntegerValue(fieldArrayIndex, subFieldName);
        }
        return null;
    }

    public BigInteger getFieldBigIntegerValue(String name) {
        return this.getFieldBigIntegerValue(name, 0);
    }

    public BigInteger getFieldBigIntegerValue(String name, int fieldArrayIndex) {
        Field field = this.getField(name, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(name);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getBigIntegerValue(fieldArrayIndex, name);
        }
        return null;
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public void setFields(Mesg mesg) {
        if (mesg.num != this.num) {
            return;
        }
        for (Field field : mesg.fields) {
            this.setField(field);
        }
    }

    public DateTime timestampToDateTime(Long timestamp) {
        if (timestamp == null) {
            return null;
        }
        DateTime dateTime = new DateTime(timestamp);
        dateTime.convertSystemTimeToUTC(this.systemTimeOffset);
        return dateTime;
    }

    public int getLocalNum() {
        return this.localNum;
    }

    public void setLocalNum(int localNum) {
        if (localNum >= 16) {
            throw new FitRuntimeException("Invalid local message number " + localNum + ".  Local message number must be < " + 16 + ".");
        }
        this.localNum = localNum;
    }

    protected void setDecoderMessageIndex(int decoderMesgIndex) {
        this.decoderMesgIndex = decoderMesgIndex;
    }

    public int getDecoderMesgIndex() {
        return this.decoderMesgIndex;
    }

    public boolean removeField(Field f) {
        boolean removedItem = false;
        if (this.fields.contains(f)) {
            this.fields.remove(f);
            removedItem = true;
        }
        return removedItem;
    }

    public Iterable<DeveloperField> getDeveloperFields() {
        return this.developerFields;
    }

    public Iterable<FieldBase> getOverrideField(short fieldNum) {
        LinkedList<FieldBase> fields = new LinkedList<FieldBase>();
        Field nativeField = this.getField(fieldNum);
        if (null != nativeField) {
            fields.add(nativeField);
        }
        for (DeveloperField devField : this.developerFields) {
            if (devField.getNativeOverride() != fieldNum) continue;
            fields.add(devField);
        }
        return fields;
    }
}

