/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgNum;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class MesgDefinition {
    protected int num;
    protected int localNum;
    protected int arch;
    protected ArrayList<FieldDefinition> fields;
    protected ArrayList<DeveloperFieldDefinition> developerFields;

    protected MesgDefinition() {
        this.num = MesgNum.INVALID;
        this.localNum = 0;
        this.arch = 1;
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
    }

    public MesgDefinition(Mesg mesg) {
        this.num = mesg.num;
        this.localNum = mesg.localNum;
        this.arch = 1;
        if (this.localNum >= 16) {
            throw new FitRuntimeException("Invalid local message number " + this.localNum + ".  Local message number must be < " + 16 + ".");
        }
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
        for (Field field : mesg.fields) {
            this.fields.add(new FieldDefinition(field));
        }
        for (DeveloperField developerField : mesg.developerFields) {
            this.developerFields.add(new DeveloperFieldDefinition(developerField));
        }
    }

    public int getNum() {
        return this.num;
    }

    public int getLocalNum() {
        return this.localNum;
    }

    public int getArch() {
        return this.arch;
    }

    public ArrayList<FieldDefinition> getFields() {
        return this.fields;
    }

    public FieldDefinition getField(int num) {
        for (FieldDefinition field : this.fields) {
            if (field.num != num) continue;
            return field;
        }
        return null;
    }

    public void addField(FieldDefinition fieldDef) {
        this.fields.add(fieldDef);
    }

    public void addDeveloperField(DeveloperFieldDefinition fieldDef) {
        this.developerFields.add(fieldDef);
    }

    public int getDeveloperFieldTotalSize() {
        int rv = 0;
        for (DeveloperFieldDefinition devField : this.developerFields) {
            rv += devField.getSize();
        }
        return rv;
    }

    public void write(OutputStream out) {
        try {
            int headerByte = 0x40 | this.localNum & 0xF;
            if (!this.developerFields.isEmpty()) {
                headerByte |= 0x20;
            }
            out.write(headerByte);
            out.write(0);
            out.write(1);
            out.write(this.num >> 8);
            out.write(this.num);
            out.write(this.fields.size());
            for (FieldDefinition fieldDefinition : this.fields) {
                fieldDefinition.write(out);
            }
            if (!this.developerFields.isEmpty()) {
                out.write(this.developerFields.size());
                for (DeveloperFieldDefinition developerFieldDefinition : this.developerFields) {
                    developerFieldDefinition.write(out);
                }
            }
        }
        catch (IOException e) {
            throw new FitRuntimeException(e);
        }
    }

    public boolean supports(Mesg mesg) {
        return this.supports(new MesgDefinition(mesg));
    }

    public boolean supports(MesgDefinition mesgDef) {
        if (mesgDef == null) {
            return false;
        }
        if (this.num != mesgDef.num) {
            return false;
        }
        if (this.localNum != mesgDef.localNum) {
            return false;
        }
        for (FieldDefinition fieldDefinition : mesgDef.fields) {
            FieldDefinition supportedFieldDef = this.getField(fieldDefinition.num);
            if (supportedFieldDef == null) {
                return false;
            }
            if (fieldDefinition.size <= supportedFieldDef.size) continue;
            return false;
        }
        for (DeveloperFieldDefinition developerFieldDefinition : mesgDef.developerFields) {
            DeveloperFieldDefinition supportedDef = this.getDeveloperField(developerFieldDefinition.getDeveloperDataIndex(), developerFieldDefinition.getNum());
            if (supportedDef == null) {
                return false;
            }
            if (developerFieldDefinition.getSize() <= supportedDef.getSize()) continue;
            return false;
        }
        return true;
    }

    private DeveloperFieldDefinition getDeveloperField(short developerIndex, int num) {
        for (DeveloperFieldDefinition field : this.developerFields) {
            if (field.getNum() != num || field.getDeveloperDataIndex() != developerIndex) continue;
            return field;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MesgDefinition)) {
            return false;
        }
        MesgDefinition other = (MesgDefinition)o;
        if (this.num != other.num) {
            return false;
        }
        if (this.localNum != other.localNum) {
            return false;
        }
        if (this.fields.size() != other.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equals(other.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 31 + new Integer(this.num).hashCode();
        hashCode = hashCode * 47 + new Integer(this.localNum).hashCode();
        hashCode = hashCode * 19 + this.fields.hashCode();
        return hashCode;
    }

    public Iterable<DeveloperFieldDefinition> getDeveloperFields() {
        return this.developerFields;
    }
}

