/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.MesgWithEventListener;
import java.util.ArrayList;
import java.util.LinkedList;

public class MesgWithEventBroadcaster
implements MesgWithEventListener {
    private int MAX_GROUPS = 256;
    private int DEFAULT_GROUP = 255;
    private int BEGIN_END_GROUP = 254;
    private ArrayList<MesgWithEventListener> listeners = new ArrayList();
    private ArrayList<LinkedList<MesgWithEvent>> startedEvents = new ArrayList();

    public MesgWithEventBroadcaster() {
        for (int i = 0; i < this.MAX_GROUPS; ++i) {
            this.startedEvents.add(new LinkedList());
        }
    }

    public void addListener(MesgWithEventListener mesgObserver) {
        this.listeners.add(mesgObserver);
    }

    public void removeListener(MesgWithEventListener mesgObserver) {
        this.listeners.remove(mesgObserver);
    }

    @Override
    public void onMesg(MesgWithEvent mesg) {
        MesgWithEvent broadcastMesg = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)mesg)));
        int group = this.DEFAULT_GROUP;
        if (broadcastMesg.getEventGroup() != null) {
            group = broadcastMesg.getEventGroup().shortValue();
        }
        if (broadcastMesg.getEventType() == null) {
            return;
        }
        switch (broadcastMesg.getEventType()) {
            case BEGIN_DEPRECIATED: {
                group = this.BEGIN_END_GROUP;
                broadcastMesg.setEventType(EventType.START);
                break;
            }
            case END_DEPRECIATED: {
                group = this.BEGIN_END_GROUP;
                broadcastMesg.setEventType(EventType.STOP);
                break;
            }
            case CONSECUTIVE_DEPRECIATED: {
                broadcastMesg.setEventType(EventType.STOP);
                break;
            }
            case END_ALL_DEPRECIATED: {
                group = this.BEGIN_END_GROUP;
                broadcastMesg.setEventType(EventType.STOP_ALL);
                break;
            }
        }
        switch (broadcastMesg.getEventType()) {
            case START: {
                for (int i = 0; i < this.startedEvents.get(group).size(); ++i) {
                    if (this.startedEvents.get(group).get(i).getEvent() != broadcastMesg.getEvent()) continue;
                    MesgWithEvent stopEvent = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)this.startedEvents.get(group).get(i))));
                    DateTime timestamp = broadcastMesg.getTimestamp();
                    stopEvent.setEventType(EventType.STOP);
                    if (timestamp != null) {
                        stopEvent.setTimestamp(timestamp);
                    }
                    this.broadcast(stopEvent);
                    this.startedEvents.get(group).remove(i);
                }
                this.startedEvents.get(group).add((MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)broadcastMesg))));
                break;
            }
            case STOP: 
            case STOP_DISABLE: {
                for (int i = 0; i < this.startedEvents.get(group).size(); ++i) {
                    if (this.startedEvents.get(group).get(i).getEvent() != broadcastMesg.getEvent()) continue;
                    this.startedEvents.get(group).remove(i);
                }
                break;
            }
            case STOP_ALL: {
                for (int i = 0; i < this.startedEvents.get(group).size(); ++i) {
                    if (this.startedEvents.get(group).get(i).getEvent() == broadcastMesg.getEvent()) continue;
                    MesgWithEvent stopEvent = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)this.startedEvents.get(group).get(i))));
                    DateTime timestamp = broadcastMesg.getTimestamp();
                    stopEvent.setEventType(EventType.STOP);
                    if (timestamp != null) {
                        stopEvent.setTimestamp(timestamp);
                    }
                    this.broadcast(stopEvent);
                }
                this.startedEvents.get(group).clear();
                broadcastMesg.setEventType(EventType.STOP);
                break;
            }
            case STOP_DISABLE_ALL: {
                for (int i = 0; i < this.startedEvents.get(group).size(); ++i) {
                    if (this.startedEvents.get(group).get(i).getEvent() == broadcastMesg.getEvent()) continue;
                    MesgWithEvent stopEvent = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)this.startedEvents.get(group).get(i))));
                    DateTime timestamp = broadcastMesg.getTimestamp();
                    stopEvent.setEventType(EventType.STOP_DISABLE);
                    if (timestamp != null) {
                        stopEvent.setTimestamp(timestamp);
                    }
                    this.broadcast(stopEvent);
                }
                this.startedEvents.get(group).clear();
                broadcastMesg.setEventType(EventType.STOP_DISABLE);
                break;
            }
        }
        this.broadcast(broadcastMesg);
    }

    private void broadcast(MesgWithEvent mesg) {
        for (MesgWithEventListener listener : this.listeners) {
            listener.onMesg(mesg);
        }
    }
}

