/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityLevel;
import com.garmin.fit.ActivitySubtype;
import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SubField;

public class MonitoringMesg
extends Mesg {
    public static final int TimestampFieldNum = 253;
    public static final int DeviceIndexFieldNum = 0;
    public static final int CaloriesFieldNum = 1;
    public static final int DistanceFieldNum = 2;
    public static final int CyclesFieldNum = 3;
    public static final int ActiveTimeFieldNum = 4;
    public static final int ActivityTypeFieldNum = 5;
    public static final int ActivitySubtypeFieldNum = 6;
    public static final int ActivityLevelFieldNum = 7;
    public static final int Distance16FieldNum = 8;
    public static final int Cycles16FieldNum = 9;
    public static final int ActiveTime16FieldNum = 10;
    public static final int LocalTimestampFieldNum = 11;
    public static final int TemperatureFieldNum = 12;
    public static final int TemperatureMinFieldNum = 14;
    public static final int TemperatureMaxFieldNum = 15;
    public static final int ActivityTimeFieldNum = 16;
    public static final int ActiveCaloriesFieldNum = 19;
    public static final int CurrentActivityTypeIntensityFieldNum = 24;
    public static final int TimestampMin8FieldNum = 25;
    public static final int Timestamp16FieldNum = 26;
    public static final int HeartRateFieldNum = 27;
    public static final int IntensityFieldNum = 28;
    public static final int DurationMinFieldNum = 29;
    public static final int DurationFieldNum = 30;
    public static final int AscentFieldNum = 31;
    public static final int DescentFieldNum = 32;
    public static final int ModerateActivityMinutesFieldNum = 33;
    public static final int VigorousActivityMinutesFieldNum = 34;
    protected static final Mesg monitoringMesg;

    public MonitoringMesg() {
        super(Factory.createMesg(55));
    }

    public MonitoringMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    public Short getDeviceIndex() {
        return this.getFieldShortValue(0, 0, 65535);
    }

    public void setDeviceIndex(Short deviceIndex) {
        this.setFieldValue(0, 0, (Object)deviceIndex, 65535);
    }

    public Integer getCalories() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public void setCalories(Integer calories) {
        this.setFieldValue(1, 0, (Object)calories, 65535);
    }

    public Float getDistance() {
        return this.getFieldFloatValue(2, 0, 65535);
    }

    public void setDistance(Float distance) {
        this.setFieldValue(2, 0, (Object)distance, 65535);
    }

    public Float getCycles() {
        return this.getFieldFloatValue(3, 0, 65535);
    }

    public void setCycles(Float cycles) {
        this.setFieldValue(3, 0, (Object)cycles, 65535);
    }

    public Long getSteps() {
        return this.getFieldLongValue(3, 0, 0);
    }

    public void setSteps(Long steps) {
        this.setFieldValue(3, 0, (Object)steps, 0);
    }

    public Float getStrokes() {
        return this.getFieldFloatValue(3, 0, 1);
    }

    public void setStrokes(Float strokes) {
        this.setFieldValue(3, 0, (Object)strokes, 1);
    }

    public Float getActiveTime() {
        return this.getFieldFloatValue(4, 0, 65535);
    }

    public void setActiveTime(Float activeTime) {
        this.setFieldValue(4, 0, (Object)activeTime, 65535);
    }

    public ActivityType getActivityType() {
        Short value = this.getFieldShortValue(5, 0, 65535);
        if (value == null) {
            return null;
        }
        return ActivityType.getByValue(value);
    }

    public void setActivityType(ActivityType activityType) {
        this.setFieldValue(5, 0, (Object)activityType.value, 65535);
    }

    public ActivitySubtype getActivitySubtype() {
        Short value = this.getFieldShortValue(6, 0, 65535);
        if (value == null) {
            return null;
        }
        return ActivitySubtype.getByValue(value);
    }

    public void setActivitySubtype(ActivitySubtype activitySubtype) {
        this.setFieldValue(6, 0, (Object)activitySubtype.value, 65535);
    }

    public ActivityLevel getActivityLevel() {
        Short value = this.getFieldShortValue(7, 0, 65535);
        if (value == null) {
            return null;
        }
        return ActivityLevel.getByValue(value);
    }

    public void setActivityLevel(ActivityLevel activityLevel) {
        this.setFieldValue(7, 0, (Object)activityLevel.value, 65535);
    }

    public Integer getDistance16() {
        return this.getFieldIntegerValue(8, 0, 65535);
    }

    public void setDistance16(Integer distance16) {
        this.setFieldValue(8, 0, (Object)distance16, 65535);
    }

    public Integer getCycles16() {
        return this.getFieldIntegerValue(9, 0, 65535);
    }

    public void setCycles16(Integer cycles16) {
        this.setFieldValue(9, 0, (Object)cycles16, 65535);
    }

    public Integer getActiveTime16() {
        return this.getFieldIntegerValue(10, 0, 65535);
    }

    public void setActiveTime16(Integer activeTime16) {
        this.setFieldValue(10, 0, (Object)activeTime16, 65535);
    }

    public Long getLocalTimestamp() {
        return this.getFieldLongValue(11, 0, 65535);
    }

    public void setLocalTimestamp(Long localTimestamp) {
        this.setFieldValue(11, 0, (Object)localTimestamp, 65535);
    }

    public Float getTemperature() {
        return this.getFieldFloatValue(12, 0, 65535);
    }

    public void setTemperature(Float temperature) {
        this.setFieldValue(12, 0, (Object)temperature, 65535);
    }

    public Float getTemperatureMin() {
        return this.getFieldFloatValue(14, 0, 65535);
    }

    public void setTemperatureMin(Float temperatureMin) {
        this.setFieldValue(14, 0, (Object)temperatureMin, 65535);
    }

    public Float getTemperatureMax() {
        return this.getFieldFloatValue(15, 0, 65535);
    }

    public void setTemperatureMax(Float temperatureMax) {
        this.setFieldValue(15, 0, (Object)temperatureMax, 65535);
    }

    public Integer[] getActivityTime() {
        return this.getFieldIntegerValues(16, 65535);
    }

    public int getNumActivityTime() {
        return this.getNumFieldValues(16, 65535);
    }

    public Integer getActivityTime(int index) {
        return this.getFieldIntegerValue(16, index, 65535);
    }

    public void setActivityTime(int index, Integer activityTime) {
        this.setFieldValue(16, index, (Object)activityTime, 65535);
    }

    public Integer getActiveCalories() {
        return this.getFieldIntegerValue(19, 0, 65535);
    }

    public void setActiveCalories(Integer activeCalories) {
        this.setFieldValue(19, 0, (Object)activeCalories, 65535);
    }

    public Byte getCurrentActivityTypeIntensity() {
        return this.getFieldByteValue(24, 0, 65535);
    }

    public void setCurrentActivityTypeIntensity(Byte currentActivityTypeIntensity) {
        this.setFieldValue(24, 0, (Object)currentActivityTypeIntensity, 65535);
    }

    public Short getTimestampMin8() {
        return this.getFieldShortValue(25, 0, 65535);
    }

    public void setTimestampMin8(Short timestampMin8) {
        this.setFieldValue(25, 0, (Object)timestampMin8, 65535);
    }

    public Integer getTimestamp16() {
        return this.getFieldIntegerValue(26, 0, 65535);
    }

    public void setTimestamp16(Integer timestamp16) {
        this.setFieldValue(26, 0, (Object)timestamp16, 65535);
    }

    public Short getHeartRate() {
        return this.getFieldShortValue(27, 0, 65535);
    }

    public void setHeartRate(Short heartRate) {
        this.setFieldValue(27, 0, (Object)heartRate, 65535);
    }

    public Float getIntensity() {
        return this.getFieldFloatValue(28, 0, 65535);
    }

    public void setIntensity(Float intensity) {
        this.setFieldValue(28, 0, (Object)intensity, 65535);
    }

    public Integer getDurationMin() {
        return this.getFieldIntegerValue(29, 0, 65535);
    }

    public void setDurationMin(Integer durationMin) {
        this.setFieldValue(29, 0, (Object)durationMin, 65535);
    }

    public Long getDuration() {
        return this.getFieldLongValue(30, 0, 65535);
    }

    public void setDuration(Long duration) {
        this.setFieldValue(30, 0, (Object)duration, 65535);
    }

    public Float getAscent() {
        return this.getFieldFloatValue(31, 0, 65535);
    }

    public void setAscent(Float ascent) {
        this.setFieldValue(31, 0, (Object)ascent, 65535);
    }

    public Float getDescent() {
        return this.getFieldFloatValue(32, 0, 65535);
    }

    public void setDescent(Float descent) {
        this.setFieldValue(32, 0, (Object)descent, 65535);
    }

    public Integer getModerateActivityMinutes() {
        return this.getFieldIntegerValue(33, 0, 65535);
    }

    public void setModerateActivityMinutes(Integer moderateActivityMinutes) {
        this.setFieldValue(33, 0, (Object)moderateActivityMinutes, 65535);
    }

    public Integer getVigorousActivityMinutes() {
        return this.getFieldIntegerValue(34, 0, 65535);
    }

    public void setVigorousActivityMinutes(Integer vigorousActivityMinutes) {
        this.setFieldValue(34, 0, (Object)vigorousActivityMinutes, 65535);
    }

    static {
        int field_index = 0;
        int subfield_index = 0;
        monitoringMesg = new Mesg("monitoring", 55);
        monitoringMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        ++field_index;
        monitoringMesg.addField(new Field("device_index", 0, 2, 1.0, 0.0, "", false, Profile.Type.DEVICE_INDEX));
        ++field_index;
        monitoringMesg.addField(new Field("calories", 1, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("distance", 2, 134, 100.0, 0.0, "m", false, Profile.Type.UINT32));
        monitoringMesg.addField(new Field("cycles", 3, 134, 2.0, 0.0, "cycles", false, Profile.Type.UINT32));
        subfield_index = 0;
        MonitoringMesg.monitoringMesg.fields.get((int)(++field_index)).subFields.add(new SubField("steps", 134, 1.0, 0.0, "steps"));
        MonitoringMesg.monitoringMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(5, 6L);
        MonitoringMesg.monitoringMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(5, 1L);
        MonitoringMesg.monitoringMesg.fields.get((int)field_index).subFields.add(new SubField("strokes", 134, 2.0, 0.0, "strokes"));
        MonitoringMesg.monitoringMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(5, 2L);
        MonitoringMesg.monitoringMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(5, 5L);
        ++subfield_index;
        ++field_index;
        monitoringMesg.addField(new Field("active_time", 4, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        monitoringMesg.addField(new Field("activity_type", 5, 0, 1.0, 0.0, "", false, Profile.Type.ACTIVITY_TYPE));
        ++field_index;
        monitoringMesg.addField(new Field("activity_subtype", 6, 0, 1.0, 0.0, "", false, Profile.Type.ACTIVITY_SUBTYPE));
        ++field_index;
        monitoringMesg.addField(new Field("activity_level", 7, 0, 1.0, 0.0, "", false, Profile.Type.ACTIVITY_LEVEL));
        ++field_index;
        monitoringMesg.addField(new Field("distance_16", 8, 132, 1.0, 0.0, "100 * m", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("cycles_16", 9, 132, 1.0, 0.0, "2 * cycles (steps)", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("active_time_16", 10, 132, 1.0, 0.0, "s", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("local_timestamp", 11, 134, 1.0, 0.0, "", false, Profile.Type.LOCAL_DATE_TIME));
        ++field_index;
        monitoringMesg.addField(new Field("temperature", 12, 131, 100.0, 0.0, "C", false, Profile.Type.SINT16));
        ++field_index;
        monitoringMesg.addField(new Field("temperature_min", 14, 131, 100.0, 0.0, "C", false, Profile.Type.SINT16));
        ++field_index;
        monitoringMesg.addField(new Field("temperature_max", 15, 131, 100.0, 0.0, "C", false, Profile.Type.SINT16));
        ++field_index;
        monitoringMesg.addField(new Field("activity_time", 16, 132, 1.0, 0.0, "minutes", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("active_calories", 19, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        monitoringMesg.addField(new Field("current_activity_type_intensity", 24, 13, 1.0, 0.0, "", false, Profile.Type.BYTE));
        MonitoringMesg.monitoringMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(5, false, 5, 1.0, 0.0));
        MonitoringMesg.monitoringMesg.fields.get((int)field_index).components.add(new FieldComponent(28, false, 3, 1.0, 0.0));
        ++field_index;
        monitoringMesg.addField(new Field("timestamp_min_8", 25, 2, 1.0, 0.0, "min", false, Profile.Type.UINT8));
        ++field_index;
        monitoringMesg.addField(new Field("timestamp_16", 26, 132, 1.0, 0.0, "s", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("heart_rate", 27, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        ++field_index;
        monitoringMesg.addField(new Field("intensity", 28, 2, 10.0, 0.0, "", false, Profile.Type.UINT8));
        ++field_index;
        monitoringMesg.addField(new Field("duration_min", 29, 132, 1.0, 0.0, "min", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("duration", 30, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        monitoringMesg.addField(new Field("ascent", 31, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        monitoringMesg.addField(new Field("descent", 32, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        monitoringMesg.addField(new Field("moderate_activity_minutes", 33, 132, 1.0, 0.0, "minutes", false, Profile.Type.UINT16));
        ++field_index;
        monitoringMesg.addField(new Field("vigorous_activity_minutes", 34, 132, 1.0, 0.0, "minutes", false, Profile.Type.UINT16));
        ++field_index;
    }
}

