/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.DeviceSettingsMesg;
import com.garmin.fit.DeviceSettingsMesgListener;
import com.garmin.fit.Field;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.FileIdMesgListener;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.LocalDateTime;
import com.garmin.fit.MonitoringInfoMesg;
import com.garmin.fit.MonitoringInfoMesgListener;
import com.garmin.fit.MonitoringMesg;
import com.garmin.fit.MonitoringMesgListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MonitoringReader
implements MonitoringInfoMesgListener,
MonitoringMesgListener,
DeviceSettingsMesgListener,
FileIdMesgListener {
    public static final int DAILY_INTERVAL = 86400;
    public static final String CYCLES_STRING = "cycles";
    public static final String DISTANCE_STRING = "distance";
    public static final String ACTIVE_CAL_STRING = "active_calories";
    public static final String CALORIE_STRING = "calories";
    public static final String ACTIVE_TIME_STRING = "active_time";
    public static final String INTENSITY_STRING = "intensity";
    public static final String HR_STRING = "heart_rate";
    public static final String TEMPERATURE_STRING = "temperature";
    public static final String ASCENT_STRING = "ascent";
    public static final String DESCENT_STRING = "descent";
    public static final String MOD_ACTIVITY_MIN_STRING = "moderate_activity_minutes";
    public static final String VIG_ACTIVITY_MIN_STRING = "vigorous_activity_minutes";
    private final String[] accumulatedFieldNames = new String[]{"cycles", "distance", "active_calories", "calories", "active_time"};
    private final String[] instantaneousFieldNames = new String[]{"intensity", "heart_rate", "temperature"};
    private final String[] summedInstantaneousFieldNames = new String[]{"ascent", "descent", "moderate_activity_minutes", "vigorous_activity_minutes"};
    private ArrayList<MonitoringMesgListener> listeners;
    private int interval;
    private boolean outputDailyTotals;
    private MonitoringInfoMesg infoMesg;
    private MonitoringMesg lastAccumMesg;
    private MonitoringMesg lastSummedInstMesg;
    private TreeMap<ActivityType, ArrayList<MonitoringMesg>> intervalMesgs;
    private TreeMap<ActivityType, MonitoringMesg> lastMesgs;
    private long startTimestamp;
    private long endTimestamp;
    private long lastTimestamp;
    private long localTimeOffset;
    private long mesgTimestamp;
    private long systemToUtcTimestampOffset;
    private long systemToLocalTimestampOffset;
    private HashSet<String> summedInstantaneousFields;
    private TreeMap<ActivityType, ExtractState> extractStates;
    private HashMap<String, Boolean> includedFields;

    public MonitoringReader(int interval) {
        if (interval < 0 || interval > 86400) {
            throw new FitRuntimeException(interval + "s is invalid.  Output interval duration must be between 1s and 86400s (1 day).");
        }
        this.listeners = new ArrayList();
        this.interval = interval;
        this.outputDailyTotals = false;
        this.intervalMesgs = new TreeMap();
        this.lastMesgs = new TreeMap();
        this.localTimeOffset = 0L;
        this.systemToUtcTimestampOffset = 0L;
        this.systemToLocalTimestampOffset = 0L;
        this.extractStates = new TreeMap();
        this.includedFields = new HashMap();
        this.summedInstantaneousFields = new HashSet();
        for (int i = 0; i < this.summedInstantaneousFieldNames.length; ++i) {
            this.summedInstantaneousFields.add(this.summedInstantaneousFieldNames[i]);
        }
        this.includedFields.put(CYCLES_STRING, true);
        this.includedFields.put(DISTANCE_STRING, true);
        this.includedFields.put(ACTIVE_CAL_STRING, true);
        this.includedFields.put(CALORIE_STRING, true);
        this.includedFields.put(ACTIVE_TIME_STRING, true);
        this.includedFields.put(INTENSITY_STRING, true);
        this.includedFields.put(HR_STRING, true);
        this.includedFields.put(TEMPERATURE_STRING, true);
        this.includedFields.put(ASCENT_STRING, true);
        this.includedFields.put(DESCENT_STRING, true);
        this.includedFields.put(MOD_ACTIVITY_MIN_STRING, true);
        this.includedFields.put(VIG_ACTIVITY_MIN_STRING, true);
    }

    public void setFieldIncluded(String field, boolean state) {
        this.includedFields.put(field, state);
    }

    public HashMap<String, Boolean> getFieldStates() {
        return new HashMap<String, Boolean>(this.includedFields);
    }

    public void excludeAllFields() {
        for (Map.Entry<String, Boolean> entry : this.includedFields.entrySet()) {
            this.includedFields.put(entry.getKey(), false);
        }
    }

    public void includeAllFields() {
        for (Map.Entry<String, Boolean> entry : this.includedFields.entrySet()) {
            this.includedFields.put(entry.getKey(), true);
        }
    }

    public void outputDailyTotals() {
        if (this.interval != 86400) {
            throw new FitRuntimeException("Interval must be 86400s to output daily totals");
        }
        this.outputDailyTotals = true;
    }

    public void setSystemToUtcTimestampOffset(long offset) {
        this.systemToUtcTimestampOffset = offset;
    }

    public void setSystemToLocalTimestampOffset(long offset) {
        this.systemToLocalTimestampOffset = offset;
    }

    public void addListener(MonitoringMesgListener mesgListener) {
        this.listeners.add(mesgListener);
    }

    public void broadcast() {
        while (this.broadcastInterval(false)) {
        }
    }

    private void broadcastCompleteIntervals() {
        while (this.broadcastInterval(true)) {
        }
    }

    private boolean broadcastInterval(boolean broadcastCompleteIntervalsOnly) {
        Iterator<ActivityType> activityTypeIterator = this.intervalMesgs.keySet().iterator();
        TreeMap<ActivityType, Object> broadcastMesgs = new TreeMap<ActivityType, Object>();
        String[] allActivityBroadcastMesg = null;
        if (this.endTimestamp == this.lastTimestamp) {
            return false;
        }
        if (this.outputDailyTotals) {
            this.startTimestamp = this.modTimestampToLocalInterval(this.startTimestamp);
        }
        if (this.endTimestamp < this.startTimestamp) {
            this.endTimestamp = this.modTimestampToLocalInterval(this.startTimestamp);
        }
        if (broadcastCompleteIntervalsOnly && this.endTimestamp + (long)this.interval > this.lastTimestamp) {
            return false;
        }
        this.endTimestamp += (long)this.interval;
        if (this.endTimestamp > this.lastTimestamp) {
            this.endTimestamp = this.lastTimestamp;
        }
        while (activityTypeIterator.hasNext()) {
            int i;
            ArrayList<MonitoringMesg> mesgList;
            ActivityType activityType = activityTypeIterator.next();
            String[] mesg = this.computeInterval(activityType, mesgList = this.intervalMesgs.get((Object)activityType));
            if (mesg != null) {
                broadcastMesgs.put(activityType, mesg);
                if (mesg.getActivityType() == ActivityType.ALL) {
                    allActivityBroadcastMesg = mesg;
                }
            }
            for (i = 0; i < mesgList.size() && mesgList.get(i).getTimestamp().getTimestamp() <= this.endTimestamp; ++i) {
            }
            --i;
            while (i > 0) {
                mesgList.remove(--i);
            }
        }
        if (broadcastMesgs.size() > 0) {
            MonitoringMesg mesg = (MonitoringMesg)broadcastMesgs.values().iterator().next();
            MonitoringMesg allActivityTotals = new MonitoringMesg();
            allActivityTotals.setTimestamp(mesg.getTimestamp());
            allActivityTotals.setLocalTimestamp(mesg.getLocalTimestamp());
            allActivityTotals.setActivityType(ActivityType.ALL);
            allActivityTotals.setDuration(mesg.getDuration());
            for (Object activityType : broadcastMesgs.keySet()) {
                mesg = (MonitoringMesg)broadcastMesgs.get(activityType);
                if (mesg.getActivityType() == ActivityType.ALL) continue;
                for (String fieldName : this.accumulatedFieldNames) {
                    if (mesg.getFieldDoubleValue(fieldName) == null) continue;
                    if (allActivityTotals.getFieldDoubleValue(fieldName) == null) {
                        allActivityTotals.setFieldValue(fieldName, (Object)Float.valueOf(0.0f));
                    }
                    allActivityTotals.setFieldValue(fieldName, (Object)(allActivityTotals.getFieldDoubleValue(fieldName) + mesg.getFieldDoubleValue(fieldName)));
                }
                for (String fieldName : this.summedInstantaneousFieldNames) {
                    if (mesg.getFieldDoubleValue(fieldName) == null) continue;
                    if (allActivityTotals.getFieldDoubleValue(fieldName) == null) {
                        allActivityTotals.setFieldValue(fieldName, (Object)Float.valueOf(0.0f));
                    }
                    allActivityTotals.setFieldValue(fieldName, (Object)(allActivityTotals.getFieldDoubleValue(fieldName) + mesg.getFieldDoubleValue(fieldName)));
                }
            }
            if (allActivityTotals.getCalories() == null && this.infoMesg.getRestingMetabolicRate() != null) {
                allActivityTotals.setCalories((int)(allActivityTotals.getDuration() * (long)this.infoMesg.getRestingMetabolicRate().intValue() / 86400L));
                if (allActivityTotals.getActiveCalories() != null) {
                    allActivityTotals.setCalories(allActivityTotals.getCalories() + allActivityTotals.getActiveCalories());
                }
            }
            if (allActivityBroadcastMesg != null) {
                for (Field field : allActivityTotals.fields) {
                    if (allActivityBroadcastMesg.getField(field.num) != null) continue;
                    allActivityBroadcastMesg.setField(field);
                }
            } else {
                broadcastMesgs.put(ActivityType.ALL, allActivityTotals);
            }
            for (Object activityType : broadcastMesgs.keySet()) {
                for (MonitoringMesgListener listener : this.listeners) {
                    listener.onMesg((MonitoringMesg)broadcastMesgs.get(activityType));
                }
            }
            this.startTimestamp = this.endTimestamp;
        }
        return true;
    }

    @Override
    public void onMesg(FileIdMesg mesg) {
    }

    @Override
    public void onMesg(MonitoringInfoMesg mesg) {
        this.infoMesg = mesg;
        DateTime utcTimestamp = this.infoMesg.getTimestamp();
        this.mesgTimestamp = utcTimestamp.getTimestamp();
        utcTimestamp.convertSystemTimeToUTC(this.systemToUtcTimestampOffset);
        this.infoMesg.setTimestamp(utcTimestamp);
        this.lastTimestamp = utcTimestamp.getTimestamp();
        if (this.infoMesg.getLocalTimestamp() != null) {
            LocalDateTime localTimestamp = new LocalDateTime(this.infoMesg.getLocalTimestamp());
            localTimestamp.convertSystemTimeToLocal(this.systemToLocalTimestampOffset);
            this.localTimeOffset = localTimestamp.getTimestamp() - this.lastTimestamp;
        } else {
            this.localTimeOffset = this.systemToLocalTimestampOffset - this.systemToUtcTimestampOffset;
        }
        this.startTimestamp = this.lastTimestamp;
    }

    @Override
    public void onMesg(MonitoringMesg mesg) {
        MonitoringMesg intervalMesg;
        ArrayList<Object> intervalMesgList;
        MonitoringMesg lastMesg;
        if (this.infoMesg == null) {
            return;
        }
        MonitoringMesg nextMesg = this.extract(mesg);
        if (nextMesg.getActivityType() == null) {
            nextMesg.setActivityType(ActivityType.ALL);
        }
        if (nextMesg.getTimestamp() == null) {
            return;
        }
        if (this.lastTimestamp != nextMesg.getTimestamp().getTimestamp() && this.lastTimestamp - this.modTimestampToLocalInterval(this.startTimestamp) >= (long)this.interval) {
            this.broadcastCompleteIntervals();
        }
        if (mesg.getCurrentActivityTypeIntensity() != null) {
            lastMesg = this.lastMesgs.get((Object)nextMesg.getActivityType());
            if (lastMesg == null) {
                intervalMesgList = new ArrayList();
                intervalMesg = new MonitoringMesg();
                intervalMesg.setActivityType(nextMesg.getActivityType());
                intervalMesg.setTimestamp(new DateTime(nextMesg.getTimestamp().getTimestamp() - nextMesg.getActiveTime().longValue()));
                intervalMesgList.add(intervalMesg);
                this.intervalMesgs.put(intervalMesg.getActivityType(), intervalMesgList);
            }
            for (MonitoringMesg otherActivityTypelastMesg : this.lastMesgs.values()) {
                if (otherActivityTypelastMesg.getActivityType() == nextMesg.getActivityType()) continue;
                MonitoringMesg startMesg = new MonitoringMesg();
                startMesg.setTimestamp(nextMesg.getTimestamp());
                startMesg.setActivityType(otherActivityTypelastMesg.getActivityType());
                for (String fieldName : this.accumulatedFieldNames) {
                    if (otherActivityTypelastMesg.getField(fieldName) == null) continue;
                    startMesg.setField(otherActivityTypelastMesg.getField(fieldName));
                }
                this.intervalMesgs.get((Object)startMesg.getActivityType()).add(startMesg);
            }
        }
        this.lastTimestamp = nextMesg.getTimestamp().getTimestamp();
        lastMesg = this.lastMesgs.get((Object)nextMesg.getActivityType());
        if (lastMesg == null) {
            lastMesg = new MonitoringMesg();
            this.lastMesgs.put(nextMesg.getActivityType(), lastMesg);
        }
        this.setFieldsFromMesg(lastMesg, nextMesg);
        intervalMesgList = this.intervalMesgs.get((Object)nextMesg.getActivityType());
        intervalMesg = null;
        if (intervalMesgList == null) {
            intervalMesgList = new ArrayList();
            this.intervalMesgs.put(nextMesg.getActivityType(), intervalMesgList);
        }
        if (intervalMesgList.size() > 0) {
            intervalMesg = (MonitoringMesg)intervalMesgList.get(intervalMesgList.size() - 1);
        }
        if (intervalMesg != null && nextMesg.getTimestamp().equals(intervalMesg.getTimestamp())) {
            this.setFieldsFromMesg(intervalMesg, nextMesg);
        } else {
            intervalMesgList.add(nextMesg);
        }
    }

    @Override
    public void onMesg(DeviceSettingsMesg mesg) {
        if (mesg.getUtcOffset() != null) {
            int timeZoneIndex = 0;
            long offset = mesg.getUtcOffset();
            this.setSystemToUtcTimestampOffset(offset);
            if (mesg.getActiveTimeZone() != null) {
                timeZoneIndex = mesg.getActiveTimeZone().shortValue();
            }
            if (mesg.getTimeZoneOffset(timeZoneIndex) != null) {
                offset = (long)((double)offset + (double)mesg.getTimeZoneOffset(timeZoneIndex).floatValue() * 3600.0);
            }
            this.setSystemToLocalTimestampOffset(offset);
        }
    }

    private long modTimestampToLocalInterval(long timestamp) {
        timestamp += this.localTimeOffset;
        timestamp -= timestamp % (long)this.interval;
        return timestamp -= this.localTimeOffset;
    }

    private void setFieldsFromMesg(MonitoringMesg destMesg, MonitoringMesg srcMesg) {
        Iterator fieldIterator = srcMesg.fields.iterator();
        while (fieldIterator.hasNext()) {
            destMesg.setField(new Field((Field)fieldIterator.next()));
        }
    }

    private MonitoringMesg extract(MonitoringMesg in) {
        long time;
        ActivityType inActivityType;
        ActivityType outActivityType;
        MonitoringMesg out = new MonitoringMesg();
        int activityTypeInfoIndex = Integer.MAX_VALUE;
        MonitoringMesg lastMesg = null;
        ExtractState extractState = null;
        if (in.getTimestamp() != null) {
            this.mesgTimestamp = in.getTimestamp().getTimestamp();
        } else if (in.getTimestamp16() != null) {
            this.mesgTimestamp += (long)in.getTimestamp16().intValue() - (this.mesgTimestamp & 0xFFFFL) & 0xFFFFL;
        } else if (in.getTimestampMin8() != null) {
            this.mesgTimestamp /= 60L;
            this.mesgTimestamp += (long)in.getTimestampMin8().shortValue() - (this.mesgTimestamp & 0xFFL) & 0xFFL;
            this.mesgTimestamp *= 60L;
        }
        DateTime timestamp = new DateTime(this.mesgTimestamp);
        timestamp.convertSystemTimeToUTC(this.systemToUtcTimestampOffset);
        out.setTimestamp(timestamp);
        if (in.getLocalTimestamp() != null) {
            out.setLocalTimestamp(in.getLocalTimestamp());
        } else {
            out.setLocalTimestamp(timestamp.getTimestamp() + this.localTimeOffset);
        }
        if (in.getActivityType() != null) {
            out.setActivityType(in.getActivityType());
        }
        if ((outActivityType = out.getActivityType()) != null) {
            extractState = this.extractStates.get((Object)outActivityType);
        }
        if (extractState == null) {
            extractState = new ExtractState();
            if (outActivityType != null) {
                this.extractStates.put(outActivityType, extractState);
            }
        }
        if (this.infoMesg.getNumActivityType() > 0) {
            for (int i = 0; i < this.infoMesg.getNumActivityType(); ++i) {
                if (this.infoMesg.getActivityType(i) != out.getActivityType()) continue;
                activityTypeInfoIndex = i;
            }
        }
        if ((inActivityType = in.getActivityType()) != null) {
            lastMesg = this.lastMesgs.get((Object)inActivityType);
        }
        if (lastMesg == null) {
            lastMesg = new MonitoringMesg();
        }
        if (in.getDuration() != null) {
            out.setDuration(in.getDuration());
        } else if (in.getDurationMin() != null) {
            out.setDuration((long)in.getDurationMin().intValue() * 60L);
        }
        if (in.getActiveTime() != null) {
            out.setActiveTime(in.getActiveTime());
        } else if (in.getActiveTime16() != null) {
            time = 0L;
            if (lastMesg.getActiveTime() != null) {
                time = (long)((double)lastMesg.getActiveTime().floatValue() + 0.5);
            }
            time += (long)in.getActiveTime16().intValue() - (time & 0xFFFFL) & 0xFFFFL;
            out.setActiveTime(Float.valueOf(time));
        } else if (in.getCurrentActivityTypeIntensity() != null) {
            time = 0L;
            if (lastMesg.getActiveTime() != null) {
                time = (long)((double)lastMesg.getActiveTime().floatValue() + 0.5);
            }
            out.setActiveTime(Float.valueOf(time += timestamp.getTimestamp() - this.lastTimestamp));
        }
        if (in.getCycles() != null) {
            out.setCycles(in.getCycles());
        } else if (in.getCycles16() != null) {
            long cycles = 0L;
            if (lastMesg.getCycles() != null) {
                cycles = (long)(lastMesg.getCycles().floatValue() * 2.0f);
            }
            cycles += (long)in.getCycles16().intValue() - (cycles & 0xFFFFL) & 0xFFFFL;
            out.setCycles(Float.valueOf((float)cycles / 2.0f));
        }
        if (in.getDistance() != null) {
            out.setDistance(in.getDistance());
        } else if (in.getDistance16() != null) {
            long distance = 0L;
            if (lastMesg.getDistance() != null) {
                distance = (long)(lastMesg.getDistance().floatValue() * 100.0f);
            }
            distance += (long)in.getDistance16().intValue() - (distance & 0xFFFFL) & 0xFFFFL;
            out.setDistance(Float.valueOf((float)distance / 100.0f));
        }
        if (in.getActiveCalories() != null) {
            out.setActiveCalories(in.getActiveCalories());
        }
        if (in.getCalories() != null) {
            out.setCalories(in.getCalories());
        }
        if (in.getIntensity() != null) {
            out.setIntensity(in.getIntensity());
        }
        if (in.getHeartRate() != null) {
            out.setHeartRate(in.getHeartRate());
        }
        if (in.getTemperature() != null) {
            out.setTemperature(in.getTemperature());
        }
        if (in.getAscent() != null) {
            out.setAscent(in.getAscent());
        }
        if (in.getDescent() != null) {
            out.setDescent(in.getDescent());
        }
        if (in.getModerateActivityMinutes() != null) {
            out.setModerateActivityMinutes(in.getModerateActivityMinutes());
        }
        if (in.getVigorousActivityMinutes() != null) {
            out.setVigorousActivityMinutes(in.getVigorousActivityMinutes());
        }
        if (out.getDistance() != null) {
            extractState.cyclesToDistanceStartDist = out.getDistance().floatValue();
            extractState.cyclesToDistanceStartCycles = out.getCycles().floatValue();
        } else if (activityTypeInfoIndex < this.infoMesg.getNumCyclesToDistance() && out.getCycles() != null) {
            out.setDistance(Float.valueOf(extractState.cyclesToDistanceStartDist + (out.getCycles().floatValue() - extractState.cyclesToDistanceStartCycles) * this.infoMesg.getCyclesToDistance(activityTypeInfoIndex).floatValue()));
        }
        if (out.getActiveCalories() != null) {
            extractState.cyclesToCaloriesStartCal = out.getActiveCalories();
            extractState.cyclesToCaloriesStartCycles = out.getCycles().floatValue();
        } else if (activityTypeInfoIndex < this.infoMesg.getNumCyclesToCalories() && out.getCycles() != null) {
            out.setActiveCalories((int)((float)extractState.cyclesToCaloriesStartCal + (out.getCycles().floatValue() - extractState.cyclesToCaloriesStartCycles) * this.infoMesg.getCyclesToCalories(activityTypeInfoIndex).floatValue()));
        }
        return out;
    }

    private MonitoringMesg computeInterval(ActivityType activityType, ArrayList<MonitoringMesg> intervalMesgs) {
        MonitoringMesg intervalMesg = new MonitoringMesg();
        ArrayList<Field> fields = new ArrayList<Field>();
        boolean intervalHasData = false;
        boolean mesgInInterval = false;
        if (intervalMesgs.size() == 0) {
            return null;
        }
        intervalMesg.setTimestamp(new DateTime(this.endTimestamp));
        intervalMesg.setLocalTimestamp(this.endTimestamp + this.localTimeOffset);
        intervalMesg.setActivityType(activityType);
        intervalMesg.setDuration(this.endTimestamp - this.startTimestamp);
        for (String fieldName : this.accumulatedFieldNames) {
            fields.add(new AccumField(MonitoringMesg.monitoringMesg.getField(fieldName)));
        }
        for (String fieldName : this.instantaneousFieldNames) {
            fields.add(new InstField(MonitoringMesg.monitoringMesg.getField(fieldName)));
        }
        for (String fieldName : this.summedInstantaneousFieldNames) {
            fields.add(new SummedInstField(MonitoringMesg.monitoringMesg.getField(fieldName)));
        }
        for (MonitoringMesg monitoringMesg : intervalMesgs) {
            boolean updateMesg = true;
            for (int i = 0; i < this.summedInstantaneousFieldNames.length; ++i) {
                if (monitoringMesg.getField(this.summedInstantaneousFieldNames[i]) != null) {
                    updateMesg = false;
                    this.lastSummedInstMesg = monitoringMesg;
                }
                if (!updateMesg) continue;
                this.lastAccumMesg = monitoringMesg;
            }
        }
        for (MonitoringMesg monitoringMesg : intervalMesgs) {
            long mesgTimestamp = monitoringMesg.getTimestamp().getTimestamp();
            if (mesgTimestamp > this.startTimestamp && mesgTimestamp < this.endTimestamp + (long)this.interval) {
                mesgInInterval = true;
            }
            for (ReaderField readerField : fields) {
                if (this.summedInstantaneousFields.contains(readerField.getName())) {
                    if (mesgTimestamp <= this.startTimestamp || mesgTimestamp > this.endTimestamp) continue;
                    readerField.onMesg(monitoringMesg);
                    continue;
                }
                readerField.onMesg(monitoringMesg);
            }
        }
        if (!mesgInInterval) {
            return null;
        }
        for (ReaderField readerField : fields) {
            if (!readerField.setMesg(intervalMesg)) continue;
            intervalHasData = true;
        }
        if (!intervalHasData) {
            return null;
        }
        return intervalMesg;
    }

    private class SummedInstField
    extends Field
    implements ReaderField {
        private double sum;

        public SummedInstField(Field field) {
            super(field);
            this.sum = 0.0;
        }

        @Override
        public boolean setMesg(MonitoringMesg mesg) {
            if (this.sum == 0.0) {
                return false;
            }
            mesg.setFieldValue(this.num, 0, (Object)this.sum);
            return true;
        }

        @Override
        public double getVal() {
            return this.sum;
        }

        @Override
        public void onMesg(MonitoringMesg mesg) {
            Field field = mesg.getField(this.num);
            if (!((Boolean)MonitoringReader.this.includedFields.get(this.name)).booleanValue()) {
                return;
            }
            long mesgTimestamp = mesg.getTimestamp().getTimestamp();
            if (mesgTimestamp > MonitoringReader.this.endTimestamp) {
                mesgTimestamp = MonitoringReader.this.endTimestamp;
            }
            if (field == null) {
                return;
            }
            Double value = field.getDoubleValue();
            if (value == null) {
                return;
            }
            this.sum += value.doubleValue();
        }
    }

    private class InstField
    extends Field
    implements ReaderField {
        private double sum;
        private double sumDuration;
        private long sumEndTimestamp;

        public InstField(Field field) {
            super(field);
            this.sum = 0.0;
            this.sumDuration = 0.0;
            this.sumEndTimestamp = MonitoringReader.this.startTimestamp;
        }

        @Override
        public boolean setMesg(MonitoringMesg mesg) {
            if (this.sumDuration == 0.0) {
                return false;
            }
            mesg.setFieldValue(this.num, 0, (Object)(this.sum / this.sumDuration));
            return true;
        }

        @Override
        public double getVal() {
            return this.sum / this.sumDuration;
        }

        @Override
        public void onMesg(MonitoringMesg mesg) {
            Field field = mesg.getField(this.num);
            if (MonitoringReader.this.outputDailyTotals || !((Boolean)MonitoringReader.this.includedFields.get(this.name)).booleanValue()) {
                return;
            }
            long mesgTimestamp = mesg.getTimestamp().getTimestamp();
            if (mesgTimestamp > MonitoringReader.this.endTimestamp) {
                mesgTimestamp = MonitoringReader.this.endTimestamp;
            }
            if (this.sumEndTimestamp >= mesgTimestamp) {
                return;
            }
            double mesgDuration = mesgTimestamp - this.sumEndTimestamp;
            this.sumEndTimestamp = mesgTimestamp;
            if (field == null) {
                return;
            }
            Double value = field.getDoubleValue();
            if (value == null) {
                return;
            }
            this.sumDuration += mesgDuration;
            this.sum += value * mesgDuration;
        }
    }

    private class AccumField
    extends Field
    implements ReaderField {
        private Double startValue;
        private long startValueTimestamp;
        private Double endValue;
        private long endValueTimestamp;

        public AccumField(Field field) {
            super(field);
            this.startValue = new Double(0.0);
            this.startValueTimestamp = MonitoringReader.this.startTimestamp + MonitoringReader.this.localTimeOffset;
            this.startValueTimestamp -= this.startValueTimestamp % 86400L;
            this.startValueTimestamp -= MonitoringReader.this.localTimeOffset;
            this.endValue = null;
            this.endValueTimestamp = 0L;
        }

        @Override
        public boolean setMesg(MonitoringMesg mesg) {
            if (this.endValue == null) {
                return false;
            }
            double value = this.endValue - this.startValue;
            if (value < 0.0) {
                value = 0.0;
            }
            mesg.setFieldValue(this.num, 0, (Object)value);
            return value != 0.0;
        }

        @Override
        public double getVal() {
            return -1.0;
        }

        @Override
        public void onMesg(MonitoringMesg mesg) {
            Field field = mesg.getField(this.num);
            long mesgTimestamp = mesg.getTimestamp().getTimestamp();
            Double value = null;
            if (!((Boolean)MonitoringReader.this.includedFields.get(this.name)).booleanValue()) {
                return;
            }
            if (field != null) {
                value = field.getDoubleValue();
            }
            if (mesgTimestamp <= MonitoringReader.this.startTimestamp) {
                if (value != null) {
                    this.startValue = value;
                }
                this.startValueTimestamp = mesgTimestamp;
            } else {
                long lastAccumTimestamp = 0L;
                if (MonitoringReader.this.lastAccumMesg != null && MonitoringReader.this.lastAccumMesg.getTimestamp() != null) {
                    lastAccumTimestamp = MonitoringReader.this.lastAccumMesg.getTimestamp().getTimestamp();
                }
                if (this.startValueTimestamp < MonitoringReader.this.startTimestamp && (MonitoringReader.this.startTimestamp >= lastAccumTimestamp || MonitoringReader.this.lastSummedInstMesg == null || MonitoringReader.this.lastSummedInstMesg.getTimestamp().getTimestamp() < this.startValueTimestamp)) {
                    if (value != null) {
                        if (this.startValueTimestamp == mesgTimestamp) {
                            this.startValueTimestamp -= MonitoringReader.this.startTimestamp - this.startValueTimestamp;
                        }
                        this.startValue = this.startValue + (value - this.startValue) * (double)(MonitoringReader.this.startTimestamp - this.startValueTimestamp) / (double)(mesgTimestamp - this.startValueTimestamp);
                    }
                    this.startValueTimestamp = MonitoringReader.this.startTimestamp;
                }
                if (mesgTimestamp > MonitoringReader.this.endTimestamp && value != null) {
                    if (this.endValue == null) {
                        this.endValue = this.startValue;
                        this.endValueTimestamp = this.startValueTimestamp;
                    }
                    if (this.endValueTimestamp == mesgTimestamp) {
                        this.endValueTimestamp -= mesgTimestamp - MonitoringReader.this.endTimestamp;
                    }
                    value = this.endValue + (value - this.endValue) * (double)(MonitoringReader.this.endTimestamp - this.endValueTimestamp) / (double)(mesgTimestamp - this.endValueTimestamp);
                }
                this.endValueTimestamp = mesgTimestamp;
                if (value != null) {
                    this.endValue = value;
                }
            }
        }
    }

    private static interface ReaderField
    extends MonitoringMesgListener {
        public boolean setMesg(MonitoringMesg var1);

        public double getVal();

        public String getName();
    }

    private class ExtractState {
        public float cyclesToCaloriesStartCycles = 0.0f;
        public int cyclesToCaloriesStartCal = 0;
        public float cyclesToDistanceStartCycles = 0.0f;
        public float cyclesToDistanceStartDist = 0.0f;

        private ExtractState() {
        }
    }
}

