/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.StrokeType;

public class RecordMesg
extends Mesg {
    public static final int TimestampFieldNum = 253;
    public static final int PositionLatFieldNum = 0;
    public static final int PositionLongFieldNum = 1;
    public static final int AltitudeFieldNum = 2;
    public static final int HeartRateFieldNum = 3;
    public static final int CadenceFieldNum = 4;
    public static final int DistanceFieldNum = 5;
    public static final int SpeedFieldNum = 6;
    public static final int PowerFieldNum = 7;
    public static final int CompressedSpeedDistanceFieldNum = 8;
    public static final int GradeFieldNum = 9;
    public static final int ResistanceFieldNum = 10;
    public static final int TimeFromCourseFieldNum = 11;
    public static final int CycleLengthFieldNum = 12;
    public static final int TemperatureFieldNum = 13;
    public static final int Speed1sFieldNum = 17;
    public static final int CyclesFieldNum = 18;
    public static final int TotalCyclesFieldNum = 19;
    public static final int CompressedAccumulatedPowerFieldNum = 28;
    public static final int AccumulatedPowerFieldNum = 29;
    public static final int LeftRightBalanceFieldNum = 30;
    public static final int GpsAccuracyFieldNum = 31;
    public static final int VerticalSpeedFieldNum = 32;
    public static final int CaloriesFieldNum = 33;
    public static final int VerticalOscillationFieldNum = 39;
    public static final int StanceTimePercentFieldNum = 40;
    public static final int StanceTimeFieldNum = 41;
    public static final int ActivityTypeFieldNum = 42;
    public static final int LeftTorqueEffectivenessFieldNum = 43;
    public static final int RightTorqueEffectivenessFieldNum = 44;
    public static final int LeftPedalSmoothnessFieldNum = 45;
    public static final int RightPedalSmoothnessFieldNum = 46;
    public static final int CombinedPedalSmoothnessFieldNum = 47;
    public static final int Time128FieldNum = 48;
    public static final int StrokeTypeFieldNum = 49;
    public static final int ZoneFieldNum = 50;
    public static final int BallSpeedFieldNum = 51;
    public static final int Cadence256FieldNum = 52;
    public static final int FractionalCadenceFieldNum = 53;
    public static final int TotalHemoglobinConcFieldNum = 54;
    public static final int TotalHemoglobinConcMinFieldNum = 55;
    public static final int TotalHemoglobinConcMaxFieldNum = 56;
    public static final int SaturatedHemoglobinPercentFieldNum = 57;
    public static final int SaturatedHemoglobinPercentMinFieldNum = 58;
    public static final int SaturatedHemoglobinPercentMaxFieldNum = 59;
    public static final int DeviceIndexFieldNum = 62;
    public static final int LeftPcoFieldNum = 67;
    public static final int RightPcoFieldNum = 68;
    public static final int LeftPowerPhaseFieldNum = 69;
    public static final int LeftPowerPhasePeakFieldNum = 70;
    public static final int RightPowerPhaseFieldNum = 71;
    public static final int RightPowerPhasePeakFieldNum = 72;
    public static final int EnhancedSpeedFieldNum = 73;
    public static final int EnhancedAltitudeFieldNum = 78;
    public static final int BatterySocFieldNum = 81;
    public static final int MotorPowerFieldNum = 82;
    public static final int VerticalRatioFieldNum = 83;
    public static final int StanceTimeBalanceFieldNum = 84;
    public static final int StepLengthFieldNum = 85;
    public static final int CycleLength16FieldNum = 87;
    public static final int AbsolutePressureFieldNum = 91;
    public static final int DepthFieldNum = 92;
    public static final int NextStopDepthFieldNum = 93;
    public static final int NextStopTimeFieldNum = 94;
    public static final int TimeToSurfaceFieldNum = 95;
    public static final int NdlTimeFieldNum = 96;
    public static final int CnsLoadFieldNum = 97;
    public static final int N2LoadFieldNum = 98;
    public static final int RespirationRateFieldNum = 99;
    public static final int EnhancedRespirationRateFieldNum = 108;
    public static final int GritFieldNum = 114;
    public static final int FlowFieldNum = 115;
    public static final int CurrentStressFieldNum = 116;
    public static final int EbikeTravelRangeFieldNum = 117;
    public static final int EbikeBatteryLevelFieldNum = 118;
    public static final int EbikeAssistModeFieldNum = 119;
    public static final int EbikeAssistLevelPercentFieldNum = 120;
    public static final int AirTimeRemainingFieldNum = 123;
    public static final int PressureSacFieldNum = 124;
    public static final int VolumeSacFieldNum = 125;
    public static final int RmvFieldNum = 126;
    public static final int AscentRateFieldNum = 127;
    public static final int Po2FieldNum = 129;
    public static final int CoreTemperatureFieldNum = 139;
    protected static final Mesg recordMesg;

    public RecordMesg() {
        super(Factory.createMesg(20));
    }

    public RecordMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    public Integer getPositionLat() {
        return this.getFieldIntegerValue(0, 0, 65535);
    }

    public void setPositionLat(Integer positionLat) {
        this.setFieldValue(0, 0, (Object)positionLat, 65535);
    }

    public Integer getPositionLong() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public void setPositionLong(Integer positionLong) {
        this.setFieldValue(1, 0, (Object)positionLong, 65535);
    }

    public Float getAltitude() {
        return this.getFieldFloatValue(2, 0, 65535);
    }

    public void setAltitude(Float altitude) {
        this.setFieldValue(2, 0, (Object)altitude, 65535);
    }

    public Short getHeartRate() {
        return this.getFieldShortValue(3, 0, 65535);
    }

    public void setHeartRate(Short heartRate) {
        this.setFieldValue(3, 0, (Object)heartRate, 65535);
    }

    public Short getCadence() {
        return this.getFieldShortValue(4, 0, 65535);
    }

    public void setCadence(Short cadence) {
        this.setFieldValue(4, 0, (Object)cadence, 65535);
    }

    public Float getDistance() {
        return this.getFieldFloatValue(5, 0, 65535);
    }

    public void setDistance(Float distance) {
        this.setFieldValue(5, 0, (Object)distance, 65535);
    }

    public Float getSpeed() {
        return this.getFieldFloatValue(6, 0, 65535);
    }

    public void setSpeed(Float speed) {
        this.setFieldValue(6, 0, (Object)speed, 65535);
    }

    public Integer getPower() {
        return this.getFieldIntegerValue(7, 0, 65535);
    }

    public void setPower(Integer power) {
        this.setFieldValue(7, 0, (Object)power, 65535);
    }

    public Byte[] getCompressedSpeedDistance() {
        return this.getFieldByteValues(8, 65535);
    }

    public int getNumCompressedSpeedDistance() {
        return this.getNumFieldValues(8, 65535);
    }

    public Byte getCompressedSpeedDistance(int index) {
        return this.getFieldByteValue(8, index, 65535);
    }

    public void setCompressedSpeedDistance(int index, Byte compressedSpeedDistance) {
        this.setFieldValue(8, index, (Object)compressedSpeedDistance, 65535);
    }

    public Float getGrade() {
        return this.getFieldFloatValue(9, 0, 65535);
    }

    public void setGrade(Float grade) {
        this.setFieldValue(9, 0, (Object)grade, 65535);
    }

    public Short getResistance() {
        return this.getFieldShortValue(10, 0, 65535);
    }

    public void setResistance(Short resistance) {
        this.setFieldValue(10, 0, (Object)resistance, 65535);
    }

    public Float getTimeFromCourse() {
        return this.getFieldFloatValue(11, 0, 65535);
    }

    public void setTimeFromCourse(Float timeFromCourse) {
        this.setFieldValue(11, 0, (Object)timeFromCourse, 65535);
    }

    public Float getCycleLength() {
        return this.getFieldFloatValue(12, 0, 65535);
    }

    public void setCycleLength(Float cycleLength) {
        this.setFieldValue(12, 0, (Object)cycleLength, 65535);
    }

    public Byte getTemperature() {
        return this.getFieldByteValue(13, 0, 65535);
    }

    public void setTemperature(Byte temperature) {
        this.setFieldValue(13, 0, (Object)temperature, 65535);
    }

    public Float[] getSpeed1s() {
        return this.getFieldFloatValues(17, 65535);
    }

    public int getNumSpeed1s() {
        return this.getNumFieldValues(17, 65535);
    }

    public Float getSpeed1s(int index) {
        return this.getFieldFloatValue(17, index, 65535);
    }

    public void setSpeed1s(int index, Float speed1s) {
        this.setFieldValue(17, index, (Object)speed1s, 65535);
    }

    public Short getCycles() {
        return this.getFieldShortValue(18, 0, 65535);
    }

    public void setCycles(Short cycles) {
        this.setFieldValue(18, 0, (Object)cycles, 65535);
    }

    public Long getTotalCycles() {
        return this.getFieldLongValue(19, 0, 65535);
    }

    public void setTotalCycles(Long totalCycles) {
        this.setFieldValue(19, 0, (Object)totalCycles, 65535);
    }

    public Integer getCompressedAccumulatedPower() {
        return this.getFieldIntegerValue(28, 0, 65535);
    }

    public void setCompressedAccumulatedPower(Integer compressedAccumulatedPower) {
        this.setFieldValue(28, 0, (Object)compressedAccumulatedPower, 65535);
    }

    public Long getAccumulatedPower() {
        return this.getFieldLongValue(29, 0, 65535);
    }

    public void setAccumulatedPower(Long accumulatedPower) {
        this.setFieldValue(29, 0, (Object)accumulatedPower, 65535);
    }

    public Short getLeftRightBalance() {
        return this.getFieldShortValue(30, 0, 65535);
    }

    public void setLeftRightBalance(Short leftRightBalance) {
        this.setFieldValue(30, 0, (Object)leftRightBalance, 65535);
    }

    public Short getGpsAccuracy() {
        return this.getFieldShortValue(31, 0, 65535);
    }

    public void setGpsAccuracy(Short gpsAccuracy) {
        this.setFieldValue(31, 0, (Object)gpsAccuracy, 65535);
    }

    public Float getVerticalSpeed() {
        return this.getFieldFloatValue(32, 0, 65535);
    }

    public void setVerticalSpeed(Float verticalSpeed) {
        this.setFieldValue(32, 0, (Object)verticalSpeed, 65535);
    }

    public Integer getCalories() {
        return this.getFieldIntegerValue(33, 0, 65535);
    }

    public void setCalories(Integer calories) {
        this.setFieldValue(33, 0, (Object)calories, 65535);
    }

    public Float getVerticalOscillation() {
        return this.getFieldFloatValue(39, 0, 65535);
    }

    public void setVerticalOscillation(Float verticalOscillation) {
        this.setFieldValue(39, 0, (Object)verticalOscillation, 65535);
    }

    public Float getStanceTimePercent() {
        return this.getFieldFloatValue(40, 0, 65535);
    }

    public void setStanceTimePercent(Float stanceTimePercent) {
        this.setFieldValue(40, 0, (Object)stanceTimePercent, 65535);
    }

    public Float getStanceTime() {
        return this.getFieldFloatValue(41, 0, 65535);
    }

    public void setStanceTime(Float stanceTime) {
        this.setFieldValue(41, 0, (Object)stanceTime, 65535);
    }

    public ActivityType getActivityType() {
        Short value = this.getFieldShortValue(42, 0, 65535);
        if (value == null) {
            return null;
        }
        return ActivityType.getByValue(value);
    }

    public void setActivityType(ActivityType activityType) {
        this.setFieldValue(42, 0, (Object)activityType.value, 65535);
    }

    public Float getLeftTorqueEffectiveness() {
        return this.getFieldFloatValue(43, 0, 65535);
    }

    public void setLeftTorqueEffectiveness(Float leftTorqueEffectiveness) {
        this.setFieldValue(43, 0, (Object)leftTorqueEffectiveness, 65535);
    }

    public Float getRightTorqueEffectiveness() {
        return this.getFieldFloatValue(44, 0, 65535);
    }

    public void setRightTorqueEffectiveness(Float rightTorqueEffectiveness) {
        this.setFieldValue(44, 0, (Object)rightTorqueEffectiveness, 65535);
    }

    public Float getLeftPedalSmoothness() {
        return this.getFieldFloatValue(45, 0, 65535);
    }

    public void setLeftPedalSmoothness(Float leftPedalSmoothness) {
        this.setFieldValue(45, 0, (Object)leftPedalSmoothness, 65535);
    }

    public Float getRightPedalSmoothness() {
        return this.getFieldFloatValue(46, 0, 65535);
    }

    public void setRightPedalSmoothness(Float rightPedalSmoothness) {
        this.setFieldValue(46, 0, (Object)rightPedalSmoothness, 65535);
    }

    public Float getCombinedPedalSmoothness() {
        return this.getFieldFloatValue(47, 0, 65535);
    }

    public void setCombinedPedalSmoothness(Float combinedPedalSmoothness) {
        this.setFieldValue(47, 0, (Object)combinedPedalSmoothness, 65535);
    }

    public Float getTime128() {
        return this.getFieldFloatValue(48, 0, 65535);
    }

    public void setTime128(Float time128) {
        this.setFieldValue(48, 0, (Object)time128, 65535);
    }

    public StrokeType getStrokeType() {
        Short value = this.getFieldShortValue(49, 0, 65535);
        if (value == null) {
            return null;
        }
        return StrokeType.getByValue(value);
    }

    public void setStrokeType(StrokeType strokeType) {
        this.setFieldValue(49, 0, (Object)strokeType.value, 65535);
    }

    public Short getZone() {
        return this.getFieldShortValue(50, 0, 65535);
    }

    public void setZone(Short zone) {
        this.setFieldValue(50, 0, (Object)zone, 65535);
    }

    public Float getBallSpeed() {
        return this.getFieldFloatValue(51, 0, 65535);
    }

    public void setBallSpeed(Float ballSpeed) {
        this.setFieldValue(51, 0, (Object)ballSpeed, 65535);
    }

    public Float getCadence256() {
        return this.getFieldFloatValue(52, 0, 65535);
    }

    public void setCadence256(Float cadence256) {
        this.setFieldValue(52, 0, (Object)cadence256, 65535);
    }

    public Float getFractionalCadence() {
        return this.getFieldFloatValue(53, 0, 65535);
    }

    public void setFractionalCadence(Float fractionalCadence) {
        this.setFieldValue(53, 0, (Object)fractionalCadence, 65535);
    }

    public Float getTotalHemoglobinConc() {
        return this.getFieldFloatValue(54, 0, 65535);
    }

    public void setTotalHemoglobinConc(Float totalHemoglobinConc) {
        this.setFieldValue(54, 0, (Object)totalHemoglobinConc, 65535);
    }

    public Float getTotalHemoglobinConcMin() {
        return this.getFieldFloatValue(55, 0, 65535);
    }

    public void setTotalHemoglobinConcMin(Float totalHemoglobinConcMin) {
        this.setFieldValue(55, 0, (Object)totalHemoglobinConcMin, 65535);
    }

    public Float getTotalHemoglobinConcMax() {
        return this.getFieldFloatValue(56, 0, 65535);
    }

    public void setTotalHemoglobinConcMax(Float totalHemoglobinConcMax) {
        this.setFieldValue(56, 0, (Object)totalHemoglobinConcMax, 65535);
    }

    public Float getSaturatedHemoglobinPercent() {
        return this.getFieldFloatValue(57, 0, 65535);
    }

    public void setSaturatedHemoglobinPercent(Float saturatedHemoglobinPercent) {
        this.setFieldValue(57, 0, (Object)saturatedHemoglobinPercent, 65535);
    }

    public Float getSaturatedHemoglobinPercentMin() {
        return this.getFieldFloatValue(58, 0, 65535);
    }

    public void setSaturatedHemoglobinPercentMin(Float saturatedHemoglobinPercentMin) {
        this.setFieldValue(58, 0, (Object)saturatedHemoglobinPercentMin, 65535);
    }

    public Float getSaturatedHemoglobinPercentMax() {
        return this.getFieldFloatValue(59, 0, 65535);
    }

    public void setSaturatedHemoglobinPercentMax(Float saturatedHemoglobinPercentMax) {
        this.setFieldValue(59, 0, (Object)saturatedHemoglobinPercentMax, 65535);
    }

    public Short getDeviceIndex() {
        return this.getFieldShortValue(62, 0, 65535);
    }

    public void setDeviceIndex(Short deviceIndex) {
        this.setFieldValue(62, 0, (Object)deviceIndex, 65535);
    }

    public Byte getLeftPco() {
        return this.getFieldByteValue(67, 0, 65535);
    }

    public void setLeftPco(Byte leftPco) {
        this.setFieldValue(67, 0, (Object)leftPco, 65535);
    }

    public Byte getRightPco() {
        return this.getFieldByteValue(68, 0, 65535);
    }

    public void setRightPco(Byte rightPco) {
        this.setFieldValue(68, 0, (Object)rightPco, 65535);
    }

    public Float[] getLeftPowerPhase() {
        return this.getFieldFloatValues(69, 65535);
    }

    public int getNumLeftPowerPhase() {
        return this.getNumFieldValues(69, 65535);
    }

    public Float getLeftPowerPhase(int index) {
        return this.getFieldFloatValue(69, index, 65535);
    }

    public void setLeftPowerPhase(int index, Float leftPowerPhase) {
        this.setFieldValue(69, index, (Object)leftPowerPhase, 65535);
    }

    public Float[] getLeftPowerPhasePeak() {
        return this.getFieldFloatValues(70, 65535);
    }

    public int getNumLeftPowerPhasePeak() {
        return this.getNumFieldValues(70, 65535);
    }

    public Float getLeftPowerPhasePeak(int index) {
        return this.getFieldFloatValue(70, index, 65535);
    }

    public void setLeftPowerPhasePeak(int index, Float leftPowerPhasePeak) {
        this.setFieldValue(70, index, (Object)leftPowerPhasePeak, 65535);
    }

    public Float[] getRightPowerPhase() {
        return this.getFieldFloatValues(71, 65535);
    }

    public int getNumRightPowerPhase() {
        return this.getNumFieldValues(71, 65535);
    }

    public Float getRightPowerPhase(int index) {
        return this.getFieldFloatValue(71, index, 65535);
    }

    public void setRightPowerPhase(int index, Float rightPowerPhase) {
        this.setFieldValue(71, index, (Object)rightPowerPhase, 65535);
    }

    public Float[] getRightPowerPhasePeak() {
        return this.getFieldFloatValues(72, 65535);
    }

    public int getNumRightPowerPhasePeak() {
        return this.getNumFieldValues(72, 65535);
    }

    public Float getRightPowerPhasePeak(int index) {
        return this.getFieldFloatValue(72, index, 65535);
    }

    public void setRightPowerPhasePeak(int index, Float rightPowerPhasePeak) {
        this.setFieldValue(72, index, (Object)rightPowerPhasePeak, 65535);
    }

    public Float getEnhancedSpeed() {
        return this.getFieldFloatValue(73, 0, 65535);
    }

    public void setEnhancedSpeed(Float enhancedSpeed) {
        this.setFieldValue(73, 0, (Object)enhancedSpeed, 65535);
    }

    public Float getEnhancedAltitude() {
        return this.getFieldFloatValue(78, 0, 65535);
    }

    public void setEnhancedAltitude(Float enhancedAltitude) {
        this.setFieldValue(78, 0, (Object)enhancedAltitude, 65535);
    }

    public Float getBatterySoc() {
        return this.getFieldFloatValue(81, 0, 65535);
    }

    public void setBatterySoc(Float batterySoc) {
        this.setFieldValue(81, 0, (Object)batterySoc, 65535);
    }

    public Integer getMotorPower() {
        return this.getFieldIntegerValue(82, 0, 65535);
    }

    public void setMotorPower(Integer motorPower) {
        this.setFieldValue(82, 0, (Object)motorPower, 65535);
    }

    public Float getVerticalRatio() {
        return this.getFieldFloatValue(83, 0, 65535);
    }

    public void setVerticalRatio(Float verticalRatio) {
        this.setFieldValue(83, 0, (Object)verticalRatio, 65535);
    }

    public Float getStanceTimeBalance() {
        return this.getFieldFloatValue(84, 0, 65535);
    }

    public void setStanceTimeBalance(Float stanceTimeBalance) {
        this.setFieldValue(84, 0, (Object)stanceTimeBalance, 65535);
    }

    public Float getStepLength() {
        return this.getFieldFloatValue(85, 0, 65535);
    }

    public void setStepLength(Float stepLength) {
        this.setFieldValue(85, 0, (Object)stepLength, 65535);
    }

    public Float getCycleLength16() {
        return this.getFieldFloatValue(87, 0, 65535);
    }

    public void setCycleLength16(Float cycleLength16) {
        this.setFieldValue(87, 0, (Object)cycleLength16, 65535);
    }

    public Long getAbsolutePressure() {
        return this.getFieldLongValue(91, 0, 65535);
    }

    public void setAbsolutePressure(Long absolutePressure) {
        this.setFieldValue(91, 0, (Object)absolutePressure, 65535);
    }

    public Float getDepth() {
        return this.getFieldFloatValue(92, 0, 65535);
    }

    public void setDepth(Float depth) {
        this.setFieldValue(92, 0, (Object)depth, 65535);
    }

    public Float getNextStopDepth() {
        return this.getFieldFloatValue(93, 0, 65535);
    }

    public void setNextStopDepth(Float nextStopDepth) {
        this.setFieldValue(93, 0, (Object)nextStopDepth, 65535);
    }

    public Long getNextStopTime() {
        return this.getFieldLongValue(94, 0, 65535);
    }

    public void setNextStopTime(Long nextStopTime) {
        this.setFieldValue(94, 0, (Object)nextStopTime, 65535);
    }

    public Long getTimeToSurface() {
        return this.getFieldLongValue(95, 0, 65535);
    }

    public void setTimeToSurface(Long timeToSurface) {
        this.setFieldValue(95, 0, (Object)timeToSurface, 65535);
    }

    public Long getNdlTime() {
        return this.getFieldLongValue(96, 0, 65535);
    }

    public void setNdlTime(Long ndlTime) {
        this.setFieldValue(96, 0, (Object)ndlTime, 65535);
    }

    public Short getCnsLoad() {
        return this.getFieldShortValue(97, 0, 65535);
    }

    public void setCnsLoad(Short cnsLoad) {
        this.setFieldValue(97, 0, (Object)cnsLoad, 65535);
    }

    public Integer getN2Load() {
        return this.getFieldIntegerValue(98, 0, 65535);
    }

    public void setN2Load(Integer n2Load) {
        this.setFieldValue(98, 0, (Object)n2Load, 65535);
    }

    public Short getRespirationRate() {
        return this.getFieldShortValue(99, 0, 65535);
    }

    public void setRespirationRate(Short respirationRate) {
        this.setFieldValue(99, 0, (Object)respirationRate, 65535);
    }

    public Float getEnhancedRespirationRate() {
        return this.getFieldFloatValue(108, 0, 65535);
    }

    public void setEnhancedRespirationRate(Float enhancedRespirationRate) {
        this.setFieldValue(108, 0, (Object)enhancedRespirationRate, 65535);
    }

    public Float getGrit() {
        return this.getFieldFloatValue(114, 0, 65535);
    }

    public void setGrit(Float grit) {
        this.setFieldValue(114, 0, (Object)grit, 65535);
    }

    public Float getFlow() {
        return this.getFieldFloatValue(115, 0, 65535);
    }

    public void setFlow(Float flow) {
        this.setFieldValue(115, 0, (Object)flow, 65535);
    }

    public Float getCurrentStress() {
        return this.getFieldFloatValue(116, 0, 65535);
    }

    public void setCurrentStress(Float currentStress) {
        this.setFieldValue(116, 0, (Object)currentStress, 65535);
    }

    public Integer getEbikeTravelRange() {
        return this.getFieldIntegerValue(117, 0, 65535);
    }

    public void setEbikeTravelRange(Integer ebikeTravelRange) {
        this.setFieldValue(117, 0, (Object)ebikeTravelRange, 65535);
    }

    public Short getEbikeBatteryLevel() {
        return this.getFieldShortValue(118, 0, 65535);
    }

    public void setEbikeBatteryLevel(Short ebikeBatteryLevel) {
        this.setFieldValue(118, 0, (Object)ebikeBatteryLevel, 65535);
    }

    public Short getEbikeAssistMode() {
        return this.getFieldShortValue(119, 0, 65535);
    }

    public void setEbikeAssistMode(Short ebikeAssistMode) {
        this.setFieldValue(119, 0, (Object)ebikeAssistMode, 65535);
    }

    public Short getEbikeAssistLevelPercent() {
        return this.getFieldShortValue(120, 0, 65535);
    }

    public void setEbikeAssistLevelPercent(Short ebikeAssistLevelPercent) {
        this.setFieldValue(120, 0, (Object)ebikeAssistLevelPercent, 65535);
    }

    public Long getAirTimeRemaining() {
        return this.getFieldLongValue(123, 0, 65535);
    }

    public void setAirTimeRemaining(Long airTimeRemaining) {
        this.setFieldValue(123, 0, (Object)airTimeRemaining, 65535);
    }

    public Float getPressureSac() {
        return this.getFieldFloatValue(124, 0, 65535);
    }

    public void setPressureSac(Float pressureSac) {
        this.setFieldValue(124, 0, (Object)pressureSac, 65535);
    }

    public Float getVolumeSac() {
        return this.getFieldFloatValue(125, 0, 65535);
    }

    public void setVolumeSac(Float volumeSac) {
        this.setFieldValue(125, 0, (Object)volumeSac, 65535);
    }

    public Float getRmv() {
        return this.getFieldFloatValue(126, 0, 65535);
    }

    public void setRmv(Float rmv) {
        this.setFieldValue(126, 0, (Object)rmv, 65535);
    }

    public Float getAscentRate() {
        return this.getFieldFloatValue(127, 0, 65535);
    }

    public void setAscentRate(Float ascentRate) {
        this.setFieldValue(127, 0, (Object)ascentRate, 65535);
    }

    public Float getPo2() {
        return this.getFieldFloatValue(129, 0, 65535);
    }

    public void setPo2(Float po2) {
        this.setFieldValue(129, 0, (Object)po2, 65535);
    }

    public Float getCoreTemperature() {
        return this.getFieldFloatValue(139, 0, 65535);
    }

    public void setCoreTemperature(Float coreTemperature) {
        this.setFieldValue(139, 0, (Object)coreTemperature, 65535);
    }

    static {
        int field_index = 0;
        recordMesg = new Mesg("record", 20);
        recordMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        ++field_index;
        recordMesg.addField(new Field("position_lat", 0, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        ++field_index;
        recordMesg.addField(new Field("position_long", 1, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        recordMesg.addField(new Field("altitude", 2, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        RecordMesg.recordMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(78, false, 16, 5.0, 500.0));
        ++field_index;
        recordMesg.addField(new Field("heart_rate", 3, 2, 1.0, 0.0, "bpm", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("cadence", 4, 2, 1.0, 0.0, "rpm", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("distance", 5, 134, 100.0, 0.0, "m", true, Profile.Type.UINT32));
        recordMesg.addField(new Field("speed", 6, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        RecordMesg.recordMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(73, false, 16, 1000.0, 0.0));
        ++field_index;
        recordMesg.addField(new Field("power", 7, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        recordMesg.addField(new Field("compressed_speed_distance", 8, 13, 1.0, 0.0, "", false, Profile.Type.BYTE));
        RecordMesg.recordMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(6, false, 12, 100.0, 0.0));
        RecordMesg.recordMesg.fields.get((int)field_index).components.add(new FieldComponent(5, true, 12, 16.0, 0.0));
        ++field_index;
        recordMesg.addField(new Field("grade", 9, 131, 100.0, 0.0, "%", false, Profile.Type.SINT16));
        ++field_index;
        recordMesg.addField(new Field("resistance", 10, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("time_from_course", 11, 133, 1000.0, 0.0, "s", false, Profile.Type.SINT32));
        ++field_index;
        recordMesg.addField(new Field("cycle_length", 12, 2, 100.0, 0.0, "m", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("temperature", 13, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        ++field_index;
        recordMesg.addField(new Field("speed_1s", 17, 2, 16.0, 0.0, "m/s", false, Profile.Type.UINT8));
        recordMesg.addField(new Field("cycles", 18, 2, 1.0, 0.0, "cycles", false, Profile.Type.UINT8));
        RecordMesg.recordMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(19, true, 8, 1.0, 0.0));
        ++field_index;
        recordMesg.addField(new Field("total_cycles", 19, 134, 1.0, 0.0, "cycles", true, Profile.Type.UINT32));
        recordMesg.addField(new Field("compressed_accumulated_power", 28, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        RecordMesg.recordMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(29, true, 16, 1.0, 0.0));
        ++field_index;
        recordMesg.addField(new Field("accumulated_power", 29, 134, 1.0, 0.0, "watts", true, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("left_right_balance", 30, 2, 1.0, 0.0, "", false, Profile.Type.LEFT_RIGHT_BALANCE));
        ++field_index;
        recordMesg.addField(new Field("gps_accuracy", 31, 2, 1.0, 0.0, "m", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("vertical_speed", 32, 131, 1000.0, 0.0, "m/s", false, Profile.Type.SINT16));
        ++field_index;
        recordMesg.addField(new Field("calories", 33, 132, 1.0, 0.0, "kcal", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("vertical_oscillation", 39, 132, 10.0, 0.0, "mm", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("stance_time_percent", 40, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("stance_time", 41, 132, 10.0, 0.0, "ms", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("activity_type", 42, 0, 1.0, 0.0, "", false, Profile.Type.ACTIVITY_TYPE));
        ++field_index;
        recordMesg.addField(new Field("left_torque_effectiveness", 43, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("right_torque_effectiveness", 44, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("left_pedal_smoothness", 45, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("right_pedal_smoothness", 46, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("combined_pedal_smoothness", 47, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("time128", 48, 2, 128.0, 0.0, "s", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("stroke_type", 49, 0, 1.0, 0.0, "", false, Profile.Type.STROKE_TYPE));
        ++field_index;
        recordMesg.addField(new Field("zone", 50, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("ball_speed", 51, 132, 100.0, 0.0, "m/s", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("cadence256", 52, 132, 256.0, 0.0, "rpm", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("fractional_cadence", 53, 2, 128.0, 0.0, "rpm", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("total_hemoglobin_conc", 54, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("total_hemoglobin_conc_min", 55, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("total_hemoglobin_conc_max", 56, 132, 100.0, 0.0, "g/dL", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("saturated_hemoglobin_percent", 57, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("saturated_hemoglobin_percent_min", 58, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("saturated_hemoglobin_percent_max", 59, 132, 10.0, 0.0, "%", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("device_index", 62, 2, 1.0, 0.0, "", false, Profile.Type.DEVICE_INDEX));
        ++field_index;
        recordMesg.addField(new Field("left_pco", 67, 1, 1.0, 0.0, "mm", false, Profile.Type.SINT8));
        ++field_index;
        recordMesg.addField(new Field("right_pco", 68, 1, 1.0, 0.0, "mm", false, Profile.Type.SINT8));
        ++field_index;
        recordMesg.addField(new Field("left_power_phase", 69, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("left_power_phase_peak", 70, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("right_power_phase", 71, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("right_power_phase_peak", 72, 2, 0.7111111, 0.0, "degrees", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("enhanced_speed", 73, 134, 1000.0, 0.0, "m/s", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("enhanced_altitude", 78, 134, 5.0, 500.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("battery_soc", 81, 2, 2.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("motor_power", 82, 132, 1.0, 0.0, "watts", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("vertical_ratio", 83, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("stance_time_balance", 84, 132, 100.0, 0.0, "percent", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("step_length", 85, 132, 10.0, 0.0, "mm", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("cycle_length16", 87, 132, 100.0, 0.0, "m", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("absolute_pressure", 91, 134, 1.0, 0.0, "Pa", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("depth", 92, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("next_stop_depth", 93, 134, 1000.0, 0.0, "m", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("next_stop_time", 94, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("time_to_surface", 95, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("ndl_time", 96, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("cns_load", 97, 2, 1.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("n2_load", 98, 132, 1.0, 0.0, "percent", false, Profile.Type.UINT16));
        recordMesg.addField(new Field("respiration_rate", 99, 2, 1.0, 0.0, "s", false, Profile.Type.UINT8));
        RecordMesg.recordMesg.fields.get((int)(++field_index)).components.add(new FieldComponent(108, false, 8, 1.0, 0.0));
        ++field_index;
        recordMesg.addField(new Field("enhanced_respiration_rate", 108, 132, 100.0, 0.0, "Breaths/min", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("grit", 114, 136, 1.0, 0.0, "", false, Profile.Type.FLOAT32));
        ++field_index;
        recordMesg.addField(new Field("flow", 115, 136, 1.0, 0.0, "", false, Profile.Type.FLOAT32));
        ++field_index;
        recordMesg.addField(new Field("current_stress", 116, 132, 100.0, 0.0, "", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("ebike_travel_range", 117, 132, 1.0, 0.0, "km", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("ebike_battery_level", 118, 2, 1.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("ebike_assist_mode", 119, 2, 1.0, 0.0, "depends on sensor", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("ebike_assist_level_percent", 120, 2, 1.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("air_time_remaining", 123, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        ++field_index;
        recordMesg.addField(new Field("pressure_sac", 124, 132, 100.0, 0.0, "bar/min", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("volume_sac", 125, 132, 100.0, 0.0, "L/min", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("rmv", 126, 132, 100.0, 0.0, "L/min", false, Profile.Type.UINT16));
        ++field_index;
        recordMesg.addField(new Field("ascent_rate", 127, 133, 1000.0, 0.0, "m/s", false, Profile.Type.SINT32));
        ++field_index;
        recordMesg.addField(new Field("po2", 129, 2, 100.0, 0.0, "percent", false, Profile.Type.UINT8));
        ++field_index;
        recordMesg.addField(new Field("core_temperature", 139, 132, 100.0, 0.0, "C", false, Profile.Type.UINT16));
        ++field_index;
    }
}

