/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Mesg;
import java.util.ArrayList;

public class SubField {
    protected String name;
    protected int type;
    protected double scale;
    protected double offset;
    protected String units;
    private ArrayList<SubFieldMap> maps;
    protected ArrayList<FieldComponent> components;

    protected SubField(SubField subField) {
        if (subField == null) {
            this.name = "unknown";
            this.type = 0;
            this.scale = 1.0;
            this.offset = 0.0;
            this.units = "";
            this.maps = new ArrayList();
            this.components = new ArrayList();
            return;
        }
        this.name = subField.name;
        this.type = subField.type;
        this.scale = subField.scale;
        this.offset = subField.offset;
        this.units = subField.units;
        this.maps = subField.maps;
        this.components = subField.components;
    }

    protected SubField(String name, int type, double scale, double offset, String units) {
        this.name = name;
        this.type = type;
        this.scale = scale;
        this.offset = offset;
        this.units = units;
        this.maps = new ArrayList();
        this.components = new ArrayList();
    }

    protected String getName() {
        return this.name;
    }

    protected int getType() {
        return this.type;
    }

    protected String getUnits() {
        return this.units;
    }

    protected void addMap(int refFieldNum, long refFieldValue) {
        this.maps.add(new SubFieldMap(refFieldNum, refFieldValue));
    }

    protected void addComponent(FieldComponent component) {
        this.components.add(component);
    }

    public boolean canMesgSupport(Mesg mesg) {
        for (SubFieldMap map : this.maps) {
            if (!map.canMesgSupport(mesg)) continue;
            return true;
        }
        return false;
    }

    private class SubFieldMap {
        private int refFieldNum;
        private long refFieldValue;

        protected SubFieldMap(int refFieldNum, long refFieldValue) {
            this.refFieldNum = refFieldNum;
            this.refFieldValue = refFieldValue;
        }

        protected boolean canMesgSupport(Mesg mesg) {
            Long value;
            Field field = mesg.getField(this.refFieldNum);
            return field != null && (value = field.getLongValue(0, 65535)) != null && value == this.refFieldValue;
        }
    }
}

