/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SensorType;
import com.garmin.fit.SubField;

public class ThreeDSensorCalibrationMesg
extends Mesg {
    public static final int TimestampFieldNum = 253;
    public static final int SensorTypeFieldNum = 0;
    public static final int CalibrationFactorFieldNum = 1;
    public static final int CalibrationDivisorFieldNum = 2;
    public static final int LevelShiftFieldNum = 3;
    public static final int OffsetCalFieldNum = 4;
    public static final int OrientationMatrixFieldNum = 5;
    protected static final Mesg threeDSensorCalibrationMesg;

    public ThreeDSensorCalibrationMesg() {
        super(Factory.createMesg(167));
    }

    public ThreeDSensorCalibrationMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    public SensorType getSensorType() {
        Short value = this.getFieldShortValue(0, 0, 65535);
        if (value == null) {
            return null;
        }
        return SensorType.getByValue(value);
    }

    public void setSensorType(SensorType sensorType) {
        this.setFieldValue(0, 0, (Object)sensorType.value, 65535);
    }

    public Long getCalibrationFactor() {
        return this.getFieldLongValue(1, 0, 65535);
    }

    public void setCalibrationFactor(Long calibrationFactor) {
        this.setFieldValue(1, 0, (Object)calibrationFactor, 65535);
    }

    public Long getAccelCalFactor() {
        return this.getFieldLongValue(1, 0, 0);
    }

    public void setAccelCalFactor(Long accelCalFactor) {
        this.setFieldValue(1, 0, (Object)accelCalFactor, 0);
    }

    public Long getGyroCalFactor() {
        return this.getFieldLongValue(1, 0, 1);
    }

    public void setGyroCalFactor(Long gyroCalFactor) {
        this.setFieldValue(1, 0, (Object)gyroCalFactor, 1);
    }

    public Long getCalibrationDivisor() {
        return this.getFieldLongValue(2, 0, 65535);
    }

    public void setCalibrationDivisor(Long calibrationDivisor) {
        this.setFieldValue(2, 0, (Object)calibrationDivisor, 65535);
    }

    public Long getLevelShift() {
        return this.getFieldLongValue(3, 0, 65535);
    }

    public void setLevelShift(Long levelShift) {
        this.setFieldValue(3, 0, (Object)levelShift, 65535);
    }

    public Integer[] getOffsetCal() {
        return this.getFieldIntegerValues(4, 65535);
    }

    public int getNumOffsetCal() {
        return this.getNumFieldValues(4, 65535);
    }

    public Integer getOffsetCal(int index) {
        return this.getFieldIntegerValue(4, index, 65535);
    }

    public void setOffsetCal(int index, Integer offsetCal) {
        this.setFieldValue(4, index, (Object)offsetCal, 65535);
    }

    public Float[] getOrientationMatrix() {
        return this.getFieldFloatValues(5, 65535);
    }

    public int getNumOrientationMatrix() {
        return this.getNumFieldValues(5, 65535);
    }

    public Float getOrientationMatrix(int index) {
        return this.getFieldFloatValue(5, index, 65535);
    }

    public void setOrientationMatrix(int index, Float orientationMatrix) {
        this.setFieldValue(5, index, (Object)orientationMatrix, 65535);
    }

    static {
        int field_index = 0;
        int subfield_index = 0;
        threeDSensorCalibrationMesg = new Mesg("three_d_sensor_calibration", 167);
        threeDSensorCalibrationMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        ++field_index;
        threeDSensorCalibrationMesg.addField(new Field("sensor_type", 0, 0, 1.0, 0.0, "", false, Profile.Type.SENSOR_TYPE));
        threeDSensorCalibrationMesg.addField(new Field("calibration_factor", 1, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        subfield_index = 0;
        ThreeDSensorCalibrationMesg.threeDSensorCalibrationMesg.fields.get((int)(++field_index)).subFields.add(new SubField("accel_cal_factor", 134, 1.0, 0.0, "g"));
        ThreeDSensorCalibrationMesg.threeDSensorCalibrationMesg.fields.get((int)field_index).subFields.get(subfield_index).addMap(0, 0L);
        ThreeDSensorCalibrationMesg.threeDSensorCalibrationMesg.fields.get((int)field_index).subFields.add(new SubField("gyro_cal_factor", 134, 1.0, 0.0, "deg/s"));
        ThreeDSensorCalibrationMesg.threeDSensorCalibrationMesg.fields.get((int)field_index).subFields.get(++subfield_index).addMap(0, 1L);
        ++subfield_index;
        ++field_index;
        threeDSensorCalibrationMesg.addField(new Field("calibration_divisor", 2, 134, 1.0, 0.0, "counts", false, Profile.Type.UINT32));
        ++field_index;
        threeDSensorCalibrationMesg.addField(new Field("level_shift", 3, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        ++field_index;
        threeDSensorCalibrationMesg.addField(new Field("offset_cal", 4, 133, 1.0, 0.0, "", false, Profile.Type.SINT32));
        ++field_index;
        threeDSensorCalibrationMesg.addField(new Field("orientation_matrix", 5, 133, 65535.0, 0.0, "", false, Profile.Type.SINT32));
        ++field_index;
    }
}

