/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.ProtocolValidator;

class V1Validator
implements ProtocolValidator {
    V1Validator() {
    }

    private boolean hasDeveloperData(MesgDefinition defn) {
        return defn.developerFields.size() > 0;
    }

    @Override
    public boolean validateMesgDefn(MesgDefinition mesgDefinition) {
        if (this.hasDeveloperData(mesgDefinition)) {
            return false;
        }
        for (FieldDefinition def : mesgDefinition.getFields()) {
            int typeNum = def.getType() & 0x1F;
            if (typeNum <= 13) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validateMesg(Mesg mesg) {
        if (this.hasDeveloperData(new MesgDefinition(mesg))) {
            return false;
        }
        for (Field fld : mesg.getFields()) {
            int typeNum = fld.getType() & 0x1F;
            if (typeNum <= 13) continue;
            return false;
        }
        return true;
    }
}

