/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.DayOfWeek;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.WeatherReport;
import com.garmin.fit.WeatherStatus;

public class WeatherConditionsMesg
extends Mesg {
    public static final int TimestampFieldNum = 253;
    public static final int WeatherReportFieldNum = 0;
    public static final int TemperatureFieldNum = 1;
    public static final int ConditionFieldNum = 2;
    public static final int WindDirectionFieldNum = 3;
    public static final int WindSpeedFieldNum = 4;
    public static final int PrecipitationProbabilityFieldNum = 5;
    public static final int TemperatureFeelsLikeFieldNum = 6;
    public static final int RelativeHumidityFieldNum = 7;
    public static final int LocationFieldNum = 8;
    public static final int ObservedAtTimeFieldNum = 9;
    public static final int ObservedLocationLatFieldNum = 10;
    public static final int ObservedLocationLongFieldNum = 11;
    public static final int DayOfWeekFieldNum = 12;
    public static final int HighTemperatureFieldNum = 13;
    public static final int LowTemperatureFieldNum = 14;
    protected static final Mesg weatherConditionsMesg = new Mesg("weather_conditions", 128);

    public WeatherConditionsMesg() {
        super(Factory.createMesg(128));
    }

    public WeatherConditionsMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime timestamp) {
        this.setFieldValue(253, 0, (Object)timestamp.getTimestamp(), 65535);
    }

    public WeatherReport getWeatherReport() {
        Short value = this.getFieldShortValue(0, 0, 65535);
        if (value == null) {
            return null;
        }
        return WeatherReport.getByValue(value);
    }

    public void setWeatherReport(WeatherReport weatherReport) {
        this.setFieldValue(0, 0, (Object)weatherReport.value, 65535);
    }

    public Byte getTemperature() {
        return this.getFieldByteValue(1, 0, 65535);
    }

    public void setTemperature(Byte temperature) {
        this.setFieldValue(1, 0, (Object)temperature, 65535);
    }

    public WeatherStatus getCondition() {
        Short value = this.getFieldShortValue(2, 0, 65535);
        if (value == null) {
            return null;
        }
        return WeatherStatus.getByValue(value);
    }

    public void setCondition(WeatherStatus condition) {
        this.setFieldValue(2, 0, (Object)condition.value, 65535);
    }

    public Integer getWindDirection() {
        return this.getFieldIntegerValue(3, 0, 65535);
    }

    public void setWindDirection(Integer windDirection) {
        this.setFieldValue(3, 0, (Object)windDirection, 65535);
    }

    public Float getWindSpeed() {
        return this.getFieldFloatValue(4, 0, 65535);
    }

    public void setWindSpeed(Float windSpeed) {
        this.setFieldValue(4, 0, (Object)windSpeed, 65535);
    }

    public Short getPrecipitationProbability() {
        return this.getFieldShortValue(5, 0, 65535);
    }

    public void setPrecipitationProbability(Short precipitationProbability) {
        this.setFieldValue(5, 0, (Object)precipitationProbability, 65535);
    }

    public Byte getTemperatureFeelsLike() {
        return this.getFieldByteValue(6, 0, 65535);
    }

    public void setTemperatureFeelsLike(Byte temperatureFeelsLike) {
        this.setFieldValue(6, 0, (Object)temperatureFeelsLike, 65535);
    }

    public Short getRelativeHumidity() {
        return this.getFieldShortValue(7, 0, 65535);
    }

    public void setRelativeHumidity(Short relativeHumidity) {
        this.setFieldValue(7, 0, (Object)relativeHumidity, 65535);
    }

    public String getLocation() {
        return this.getFieldStringValue(8, 0, 65535);
    }

    public void setLocation(String location) {
        this.setFieldValue(8, 0, (Object)location, 65535);
    }

    public DateTime getObservedAtTime() {
        return this.timestampToDateTime(this.getFieldLongValue(9, 0, 65535));
    }

    public void setObservedAtTime(DateTime observedAtTime) {
        this.setFieldValue(9, 0, (Object)observedAtTime.getTimestamp(), 65535);
    }

    public Integer getObservedLocationLat() {
        return this.getFieldIntegerValue(10, 0, 65535);
    }

    public void setObservedLocationLat(Integer observedLocationLat) {
        this.setFieldValue(10, 0, (Object)observedLocationLat, 65535);
    }

    public Integer getObservedLocationLong() {
        return this.getFieldIntegerValue(11, 0, 65535);
    }

    public void setObservedLocationLong(Integer observedLocationLong) {
        this.setFieldValue(11, 0, (Object)observedLocationLong, 65535);
    }

    public DayOfWeek getDayOfWeek() {
        Short value = this.getFieldShortValue(12, 0, 65535);
        if (value == null) {
            return null;
        }
        return DayOfWeek.getByValue(value);
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.setFieldValue(12, 0, (Object)dayOfWeek.value, 65535);
    }

    public Byte getHighTemperature() {
        return this.getFieldByteValue(13, 0, 65535);
    }

    public void setHighTemperature(Byte highTemperature) {
        this.setFieldValue(13, 0, (Object)highTemperature, 65535);
    }

    public Byte getLowTemperature() {
        return this.getFieldByteValue(14, 0, 65535);
    }

    public void setLowTemperature(Byte lowTemperature) {
        this.setFieldValue(14, 0, (Object)lowTemperature, 65535);
    }

    static {
        weatherConditionsMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        weatherConditionsMesg.addField(new Field("weather_report", 0, 0, 1.0, 0.0, "", false, Profile.Type.WEATHER_REPORT));
        weatherConditionsMesg.addField(new Field("temperature", 1, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        weatherConditionsMesg.addField(new Field("condition", 2, 0, 1.0, 0.0, "", false, Profile.Type.WEATHER_STATUS));
        weatherConditionsMesg.addField(new Field("wind_direction", 3, 132, 1.0, 0.0, "degrees", false, Profile.Type.UINT16));
        weatherConditionsMesg.addField(new Field("wind_speed", 4, 132, 1000.0, 0.0, "m/s", false, Profile.Type.UINT16));
        weatherConditionsMesg.addField(new Field("precipitation_probability", 5, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        weatherConditionsMesg.addField(new Field("temperature_feels_like", 6, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        weatherConditionsMesg.addField(new Field("relative_humidity", 7, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        weatherConditionsMesg.addField(new Field("location", 8, 7, 1.0, 0.0, "", false, Profile.Type.STRING));
        weatherConditionsMesg.addField(new Field("observed_at_time", 9, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        weatherConditionsMesg.addField(new Field("observed_location_lat", 10, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        weatherConditionsMesg.addField(new Field("observed_location_long", 11, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        weatherConditionsMesg.addField(new Field("day_of_week", 12, 0, 1.0, 0.0, "", false, Profile.Type.DAY_OF_WEEK));
        weatherConditionsMesg.addField(new Field("high_temperature", 13, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
        weatherConditionsMesg.addField(new Field("low_temperature", 14, 1, 1.0, 0.0, "C", false, Profile.Type.SINT8));
    }
}

