/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgNum;
import com.garmin.fit.util.DateTimeConverter;
import com.garmin.fit.util.SemicirclesConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVReader {
    private static final Pattern csvPattern = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");
    private static final Pattern doublePattern = Pattern.compile("^([0-9]+)?\\.[0-9]+$");
    private static final Pattern hexPattern = Pattern.compile("^(0[xX]){1}[a-fA-F0-9]{2}$");
    private final Fit.ProtocolVersion protocolVersion;
    private int unknownMesgCount = 0;
    private int unknownFieldCount = 0;
    private int typeCol = -1;
    private int localNumCol = -1;
    private int mesgCol = -1;
    private int fieldCol = -1;
    private int lineNum = 1;
    private LinkedList<FieldDescriptionMesg> fieldDescriptionMesgs = new LinkedList();
    private HashMap<Short, DeveloperDataIdMesg> developerDataIdMesgs = new HashMap();

    public static boolean read(InputStream in, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener) {
        return CSVReader.read(in, mesgListener, mesgDefinitionListener, Fit.ProtocolVersion.V1_0);
    }

    public static boolean read(InputStream in, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener, Fit.ProtocolVersion protocolVersion) {
        CSVReader csvReader = new CSVReader(protocolVersion);
        return csvReader.readCSV(in, mesgListener, mesgDefinitionListener);
    }

    CSVReader() {
        this(Fit.ProtocolVersion.V1_0);
    }

    CSVReader(Fit.ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean readCSV(InputStream in, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = reader.readLine();
            line = this.stripUTF8Bom(line);
            ArrayList<String> cells = this.readCells(line);
            for (int col = 0; col < cells.size(); ++col) {
                if (cells.get(col).equals("Type")) {
                    this.typeCol = col;
                    continue;
                }
                if (cells.get(col).equals("Local Number")) {
                    this.localNumCol = col;
                    continue;
                }
                if (cells.get(col).equals("Message")) {
                    this.mesgCol = col;
                    continue;
                }
                if (!cells.get(col).equals("Field 1")) continue;
                this.fieldCol = col;
                break;
            }
            while ((line = reader.readLine()) != null) {
                cells = this.readCells(line);
                ++this.lineNum;
                if (cells.size() <= this.typeCol || cells.size() <= this.localNumCol || cells.size() <= this.mesgCol) continue;
                if (cells.get(this.mesgCol).equalsIgnoreCase("unknown")) {
                    ++this.unknownMesgCount;
                    continue;
                }
                if (!(cells.get(this.typeCol).equalsIgnoreCase("Definition") ? !this.readMessageDefinition(cells, mesgDefinitionListener) : cells.get(this.typeCol).equalsIgnoreCase("Data") && !this.readMessage(cells, mesgListener))) continue;
                return false;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.unknownMesgCount > 0 || this.unknownFieldCount > 0) {
            System.out.printf("Ignored %d unknown field(s) and %d unknown message(s) during encoding.\n", this.unknownFieldCount, this.unknownMesgCount);
        }
        return true;
    }

    private ArrayList<String> readCells(String line) {
        String match;
        ArrayList<String> list = new ArrayList<String>();
        if (line == null) {
            return null;
        }
        Matcher m = csvPattern.matcher(line);
        while (m.find() && (match = m.group()) != null) {
            if (match.endsWith(",")) {
                match = match.substring(0, match.length() - 1);
            }
            if (match.startsWith("\"")) {
                match = match.substring(1, match.length() - 1);
            }
            if (match.length() == 0) {
                match = null;
            }
            list.add(match);
        }
        return list;
    }

    private ArrayList<String> readValues(String cell) {
        ArrayList<String> list = new ArrayList<String>();
        if (cell == null) {
            return null;
        }
        String value = "";
        for (int i = 0; i < cell.length(); ++i) {
            if (cell.charAt(i) == '|') {
                list.add(value);
                value = "";
                continue;
            }
            value = value + cell.charAt(i);
        }
        if (value.length() > 0) {
            list.add(value);
        }
        return list;
    }

    private String stripUTF8Bom(String input) {
        byte[] beforeStrip = input.getBytes(Charset.forName("UTF-8"));
        if (beforeStrip[0] == -17 && beforeStrip[1] == -69 && beforeStrip[2] == -65) {
            byte[] afterStrip = new byte[beforeStrip.length - 3];
            System.arraycopy(beforeStrip, 3, afterStrip, 0, afterStrip.length);
            try {
                input = new String(afterStrip, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return input;
    }

    Boolean isDoubleValue(String value) {
        Matcher m = doublePattern.matcher(value);
        return m.find();
    }

    Boolean isHexValue(String value) {
        Matcher m = hexPattern.matcher(value);
        return m.find();
    }

    private boolean readMessage(ArrayList<String> cells, MesgListener mesgListener) {
        Mesg mesg = Factory.createMesg(cells.get(this.mesgCol));
        if (mesg.getNum() == MesgNum.INVALID) {
            System.err.printf("CSVReader.read(): Error on line %d - Unknown message \"%s\".\n", this.lineNum, mesg.getName());
            return false;
        }
        if (this.localNumCol >= 0) {
            mesg.setLocalNum(Integer.valueOf(cells.get(this.localNumCol)));
        }
        int cellIndex = this.fieldCol;
        while (cellIndex + 2 <= cells.size()) {
            String fieldOrSubFieldName = cells.get(cellIndex++);
            ArrayList<String> values = this.readValues(cells.get(cellIndex++));
            FieldBase field = null;
            ++cellIndex;
            if (fieldOrSubFieldName == null) break;
            if (fieldOrSubFieldName.equalsIgnoreCase("unknown")) {
                ++this.unknownFieldCount;
                continue;
            }
            Field nativeField = Factory.createField(mesg.getName(), fieldOrSubFieldName);
            if (values == null) continue;
            if (nativeField.getNum() == 255) {
                for (FieldDescriptionMesg descriptionMesg : this.fieldDescriptionMesgs) {
                    if (!descriptionMesg.getFieldName(0).equals(fieldOrSubFieldName)) continue;
                    if (this.protocolVersion == Fit.ProtocolVersion.V1_0) {
                        throw new RuntimeException("FIT Protocol Error. A developer field was found while using Protocol Version 1.0. To use developer data, specify the -p2 command line option to enable FIT Protocol 2.0.");
                    }
                    DeveloperDataIdMesg devId = this.developerDataIdMesgs.get(descriptionMesg.getDeveloperDataIndex());
                    field = new DeveloperField(descriptionMesg, devId);
                    break;
                }
            } else {
                field = nativeField;
            }
            if (field == null) {
                System.err.printf("CSVReader.read(): Error on line %d - Unknown field \"%s\" in message \"%s\".\n", this.lineNum, fieldOrSubFieldName, mesg.getName());
                return false;
            }
            for (String value : values) {
                int numValues = field.getNumValues();
                if (((FieldBase)field).getType() == 7) {
                    field.setValue(numValues, (Object)value, fieldOrSubFieldName);
                    continue;
                }
                try {
                    boolean setRawValue = false;
                    switch (((FieldBase)field).getType()) {
                        case 0: {
                            if (!Short.valueOf(value).equals(Fit.ENUM_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 1: {
                            if (!Byte.valueOf(value).equals(Fit.SINT8_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 2: {
                            if (!Short.valueOf(value).equals(Fit.UINT8_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 10: {
                            if (!Short.valueOf(value).equals(Fit.UINT8Z_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 131: {
                            if (!Short.valueOf(value).equals(Fit.SINT16_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 132: {
                            if (!Integer.valueOf(value).equals(Fit.UINT16_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 139: {
                            if (!Integer.valueOf(value).equals(Fit.UINT16Z_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 133: {
                            if (nativeField.getUnits().equals("semicircles") && this.isDoubleValue(value).booleanValue()) {
                                int semicircles = SemicirclesConverter.degreesToSemicircles(Double.parseDouble(value));
                                value = Integer.toString(semicircles);
                            }
                            if (!Integer.valueOf(value).equals(Fit.SINT32_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 134: {
                            if (nativeField.getProfileType().name().equalsIgnoreCase("DATE_TIME")) {
                                value = DateTimeConverter.parseDateTime(value);
                            }
                            if (!Long.valueOf(value).equals(Fit.UINT32_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 140: {
                            if (!Long.valueOf(value).equals(Fit.UINT32Z_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 136: {
                            if (!Float.valueOf(value).equals(Fit.FLOAT32_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 137: {
                            if (!Double.valueOf(value).equals(Fit.FLOAT64_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                        case 13: {
                            if (this.isHexValue(value).booleanValue()) {
                                value = Integer.decode(value).toString();
                            }
                            if (!Short.valueOf(value).equals(Fit.BYTE_INVALID)) break;
                            setRawValue = true;
                            break;
                        }
                    }
                    Double doubleValue = Double.valueOf(value);
                    if (setRawValue) {
                        field.setRawValue(numValues, doubleValue);
                        continue;
                    }
                    field.setValue(numValues, (Object)doubleValue, fieldOrSubFieldName);
                }
                catch (NumberFormatException e) {
                    field.setValue(numValues, (Object)Double.valueOf(value), fieldOrSubFieldName);
                }
            }
            if (field instanceof Field) {
                mesg.addField((Field)field);
                continue;
            }
            mesg.addDeveloperField((DeveloperField)field);
        }
        if (mesg.getNum() == 206) {
            this.fieldDescriptionMesgs.add(new FieldDescriptionMesg(mesg));
        } else if (mesg.getNum() == 207) {
            DeveloperDataIdMesg devId = new DeveloperDataIdMesg(mesg);
            short developerIndex = devId.getDeveloperDataIndex();
            this.developerDataIdMesgs.put(developerIndex, devId);
            Iterator it = this.fieldDescriptionMesgs.iterator();
            while (it.hasNext()) {
                FieldDescriptionMesg next = (FieldDescriptionMesg)it.next();
                if (next.getDeveloperDataIndex() != developerIndex) continue;
                it.remove();
            }
        }
        if (mesgListener != null) {
            mesgListener.onMesg(mesg);
        }
        return true;
    }

    private boolean readMessageDefinition(ArrayList<String> cells, MesgDefinitionListener mesgDefinitionListener) {
        int cellIndex = this.fieldCol;
        Mesg mesg = Factory.createMesg(cells.get(this.mesgCol));
        if (mesg.getNum() == MesgNum.INVALID) {
            System.err.printf("CSVReader.read(): Error on line %d - Unknown message \"%s\".\n", this.lineNum, mesg.getName());
            return false;
        }
        if (this.localNumCol >= 0) {
            mesg.setLocalNum(Integer.valueOf(cells.get(this.localNumCol)));
        }
        MesgDefinition mesgDef = new MesgDefinition(mesg);
        while (cellIndex + 2 <= cells.size()) {
            String fieldOrSubFieldName = cells.get(cellIndex++);
            ArrayList<String> values = this.readValues(cells.get(cellIndex++));
            FieldBase field = null;
            FieldDefinitionBase fieldDef = null;
            ++cellIndex;
            if (fieldOrSubFieldName == null) break;
            if (fieldOrSubFieldName.equalsIgnoreCase("unknown")) {
                ++this.unknownFieldCount;
                continue;
            }
            Field nativeField = Factory.createField(mesg.getName(), fieldOrSubFieldName);
            if (values == null) continue;
            if (nativeField.getNum() == 255) {
                for (FieldDescriptionMesg descriptionMesg : this.fieldDescriptionMesgs) {
                    if (!descriptionMesg.getFieldName(0).equals(fieldOrSubFieldName)) continue;
                    if (this.protocolVersion == Fit.ProtocolVersion.V1_0) {
                        throw new RuntimeException("FIT Protocol Error. A developer field was found while using Protocol Version 1.0. To use developer data, specify the -p2 command line option to enable FIT Protocol 2.0.");
                    }
                    DeveloperDataIdMesg devId = this.developerDataIdMesgs.get(descriptionMesg.getDeveloperDataIndex());
                    field = new DeveloperField(descriptionMesg, devId);
                    fieldDef = new DeveloperFieldDefinition(descriptionMesg, devId);
                    break;
                }
            } else {
                field = nativeField;
                fieldDef = new FieldDefinition((Field)field);
            }
            if (field == null) {
                System.err.printf("CSVReader.read(): Error on line %d - Unknown field \"%s\" in message \"%s\".\n", this.lineNum, fieldOrSubFieldName, mesg.getName());
                return false;
            }
            for (String value : values) {
                ((FieldDefinitionBase)fieldDef).setSize(Integer.valueOf(value) * Fit.baseTypeSizes[((FieldBase)field).getType() & 0x1F]);
            }
            if (field instanceof Field) {
                mesgDef.addField((FieldDefinition)fieldDef);
                continue;
            }
            mesgDef.addDeveloperField((DeveloperFieldDefinition)fieldDef);
        }
        if (mesgDefinitionListener != null) {
            mesgDefinitionListener.onMesgDefinition(mesgDef);
        }
        return true;
    }
}

